/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.crowd.embedded;

import com.atlassian.jira.functest.framework.FuncTestCase;

public class TestCrowdServerConfiguration
extends FuncTestCase {
    private static final String MY_APP = "My App";
    private static final String MY_APP_ADDRESS = "192.168.0.1";

    public void testAddApplication() throws Exception {
        this.tester.clickLink("crowd-add-application");
        String appName = "FishEye";
        String appAddress = "127.0.0.1";
        this.submitEditForm("", "", "not_an_address");
        this.text.assertTextPresent(this.locator.css("#edit-crowd-application-name-error"), "You must provide an application name.");
        this.text.assertTextPresent(this.locator.css("#edit-crowd-application-credential-error"), "A password is required.");
        this.text.assertTextPresent(this.locator.css("#edit-crowd-application-remoteAddresses-error"), "'not_an_address' is not a valid IP address.");
        this.submitEditForm("FishEye", "pass", "127.0.0.1");
        this.assertAppPresent("FishEye", "127.0.0.1");
    }

    public void testEditApplication() throws Exception {
        String newAppName = "MyNewApp";
        String newAppAddress = "127.0.0.127";
        this.tester.clickLink("crowd-edit-application-My App");
        this.submitEditForm("", "", "not_an_address");
        this.text.assertTextPresent(this.locator.css("#edit-crowd-application-name-error"), "You must provide an application name.");
        this.text.assertTextNotPresent(this.locator.css("#edit-crowd-application-credential-error"), "A password is required.");
        this.text.assertTextPresent(this.locator.css("#edit-crowd-application-remoteAddresses-error"), "'not_an_address' is not a valid IP address.");
        this.submitEditForm("MyNewApp", "", "127.0.0.127");
        this.assertAppPresent("MyNewApp", "127.0.0.127");
        this.assertAppNotPresent(MY_APP, MY_APP_ADDRESS);
    }

    public void testDeleteApplication() throws Exception {
        this.tester.clickLink("crowd-delete-application-My App");
        this.assertAppNotPresent(MY_APP, MY_APP_ADDRESS);
    }

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestCrowdServerConfiguration.xml");
        this.navigation.gotoPage("secure/project/ConfigureCrowdServer.jspa");
        this.navigation.checkWebSudoWithLastPassword();
    }

    private void submitEditForm(String name, String credential, String remoteAddresses) {
        this.tester.setWorkingForm("edit-crowd-application");
        this.tester.setFormElement("name", name);
        this.tester.setFormElement("credential", credential);
        this.tester.setFormElement("remoteAddresses", remoteAddresses);
        this.tester.clickButton("edit-crowd-application-submit");
    }

    private void assertAppPresent(String appName, String appAddress) {
        String appRowLocator = String.format("#crowd-app-%s", appName);
        this.text.assertTextPresent(this.locator.css(appRowLocator + " td[headers=application]"), appName);
        this.text.assertTextPresent(this.locator.css(appRowLocator + " td[headers=address]"), appAddress);
    }

    private void assertAppNotPresent(String appName, String appAddress) {
        String appRowLocator = String.format("#crowd-app-%s", appName);
        this.text.assertTextNotPresent(this.locator.css(appRowLocator + " td[headers=application]"), appName);
        this.text.assertTextNotPresent(this.locator.css(appRowLocator + " td[headers=address]"), appAddress);
    }
}

