/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.crowd.embedded;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.util.LocalTestEnvironmentData;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.AtlassianTenantFilter;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.ReflectionUtils;

class CrowdEmbeddedServer
implements RestServer {
    static final String XML_BACKUP = "TestCrowdRestAPI.xml";
    private final JIRAEnvironmentData environmentData;
    private String xmlBackup = null;

    public CrowdEmbeddedServer() {
        this(new LocalTestEnvironmentData());
    }

    public CrowdEmbeddedServer(JIRAEnvironmentData environmentData) {
        this.environmentData = environmentData;
    }

    public CrowdEmbeddedServer usingXmlBackup(String xmlBackup) {
        this.xmlBackup = xmlBackup;
        return this;
    }

    public void before() throws Exception {
        if (this.xmlBackup != null) {
            FakeTestCase ftc = new FakeTestCase();
            Method setUp = TestCase.class.getDeclaredMethod("setUp", null);
            ReflectionUtils.makeAccessible((Method)setUp);
            setUp.invoke((Object)ftc, (Object[])null);
            ftc.restore(this.xmlBackup);
        }
    }

    public String getHost() {
        return this.environmentData.getBaseUrl().getHost();
    }

    public int getPort() {
        return this.environmentData.getBaseUrl().getPort();
    }

    public String getContextPath() {
        return this.environmentData.getContext();
    }

    public Client decorateClient(Client client) {
        if (StringUtils.isNotBlank((String)this.environmentData.getTenant())) {
            client.addFilter((ClientFilter)new AtlassianTenantFilter(this.environmentData.getTenant()));
        }
        return client;
    }

    static class FakeTestCase
    extends FuncTestCase {
        FakeTestCase() {
        }

        public void restore(String xmlBackup) {
            this.administration.restoreData(xmlBackup);
        }
    }
}

