/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.comment;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestCommentVisibility
extends JIRAWebTest {
    public TestCommentVisibility(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestCommentVisibility.xml");
    }

    public void testCommentVisibilitySwitch() {
        this.enableCommentGroupVisibility(Boolean.TRUE);
        this.displayAllIssues();
        this.clickLinkWithText("HSP-1");
        this.assertFormElementPresent("commentLevel");
        this.selectOption("commentLevel", "jira-administrators");
        this.selectOption("commentLevel", "jira-developers");
        this.selectOption("commentLevel", "jira-users");
        this.selectOption("commentLevel", "Administrators");
        this.selectOption("commentLevel", "Developers");
        this.selectOption("commentLevel", "Users");
        this.enableCommentGroupVisibility(Boolean.FALSE);
        this.displayAllIssues();
        this.clickLinkWithText("HSP-1");
        this.assertOptionNotPresent("commentLevel", "jira-administrators");
        this.assertOptionNotPresent("commentLevel", "jira-developers");
        this.assertOptionNotPresent("commentLevel", "jira-users");
        this.selectOption("commentLevel", "Administrators");
        this.selectOption("commentLevel", "Developers");
        this.selectOption("commentLevel", "Users");
    }

    public void testAnonymousCommenterAllowed() {
        this.enableCommentGroupVisibility(Boolean.TRUE);
        this.clickLink("admin_link");
        this.clickLinkWithText("homosapien");
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("add_perm_10");
        this.selectOption("permissions", "Browse Projects");
        this.selectMultiOption("permissions", "Browse Projects");
        this.selectMultiOption("permissions", "Add Comments");
        this.checkCheckbox("type", "group");
        this.submit(" Add ");
        this.logout();
        this.clickLinkWithText("Log in again.");
        this.clickLink("find_link");
        this.selectOption("pid", "All projects");
        this.submit("show");
        this.clickLinkWithText("HSP-1");
        this.assertFormElementPresent("comment");
        this.assertFormElementNotPresent("commentLevel");
    }

    public void testWorklogVisibilitySwitch() {
        this.activateTimeTracking();
        this.enableCommentGroupVisibility(Boolean.TRUE);
        this.displayAllIssues();
        this.clickLinkWithText("HSP-1");
        this.clickLink("log-work");
        this.assertFormElementPresent("commentLevel");
        this.selectOption("commentLevel", "jira-administrators");
        this.selectOption("commentLevel", "jira-developers");
        this.selectOption("commentLevel", "jira-users");
        this.selectOption("commentLevel", "Administrators");
        this.selectOption("commentLevel", "Developers");
        this.selectOption("commentLevel", "Users");
        this.enableCommentGroupVisibility(Boolean.FALSE);
        this.displayAllIssues();
        this.clickLinkWithText("HSP-1");
        this.clickLink("log-work");
        this.assertOptionNotPresent("commentLevel", "jira-administrators");
        this.assertOptionNotPresent("commentLevel", "jira-developers");
        this.assertOptionNotPresent("commentLevel", "jira-users");
        this.selectOption("commentLevel", "Administrators");
        this.selectOption("commentLevel", "Developers");
        this.selectOption("commentLevel", "Users");
    }

    public void testCommentSearchNoLevels() {
        this.gotoIssue("HSP-1");
        this.addCommentOnCurrentIssue("comment with animal kangaroo");
        this.gotoIssue("MKY-1");
        this.addCommentOnCurrentIssue("comment with animal tasmanian devil");
        String[] accounts = new String[]{"fred", "admin"};
        for (int i = 0; i < accounts.length; ++i) {
            String usernameAndPassword = accounts[i];
            this.login(usernameAndPassword, usernameAndPassword);
            this.assertCommentSearchResults("visible", null, new String[0], new String[]{"HSP-1", "MKY-1"});
            this.assertCommentSearchResults("animal", null, new String[]{"HSP-1", "MKY-1"}, new String[0]);
            this.assertCommentSearchResults("kangaroo", null, new String[]{"HSP-1"}, new String[]{"MKY-1"});
        }
    }

    public void testCommentSearchResultsWithLevels() {
        this.gotoIssue("HSP-1");
        this.addCommentOnCurrentIssue("comment visible to haxors", "Developers");
        this.gotoIssue("MKY-1");
        this.addCommentOnCurrentIssue("comment visible to haxors", "Developers");
        String[] ALL_PROJECTS = null;
        String[] PROJECT_MONKEY = new String[]{"monkey"};
        String[] PROJECT_HOMOSAPIEN = new String[]{"homosapien"};
        String[] PROJECTS_BOTH = new String[]{"monkey", "homosapien"};
        String[] ISSUE_MONKEY = new String[]{"MKY-1"};
        String[] ISSUE_HOMOSAPIEN = new String[]{"HSP-1"};
        String[] ISSUES_BOTH = new String[]{"MKY-1", "HSP-1"};
        String[] ISSUES_NONE = new String[]{};
        this.login("fred", "fred");
        this.assertCommentSearchResults("visible", ALL_PROJECTS, ISSUE_MONKEY, ISSUE_HOMOSAPIEN);
        this.assertCommentSearchResults("visible", PROJECT_MONKEY, ISSUE_MONKEY, ISSUE_HOMOSAPIEN);
        this.assertCommentSearchResults("visible", PROJECT_HOMOSAPIEN, ISSUES_NONE, ISSUES_BOTH);
        this.assertCommentSearchResults("visible", PROJECTS_BOTH, ISSUE_MONKEY, ISSUE_HOMOSAPIEN);
        this.assertCommentSearchResults("haxors", PROJECTS_BOTH, ISSUE_MONKEY, ISSUE_HOMOSAPIEN);
        this.login("admin", "admin");
        this.assertCommentSearchResults("visible", ALL_PROJECTS, ISSUES_BOTH, ISSUES_NONE);
        this.assertCommentSearchResults("visible", PROJECT_MONKEY, ISSUE_MONKEY, ISSUE_HOMOSAPIEN);
        this.assertCommentSearchResults("visible", PROJECT_HOMOSAPIEN, ISSUE_HOMOSAPIEN, ISSUE_MONKEY);
        this.assertCommentSearchResults("visible", PROJECTS_BOTH, ISSUES_BOTH, ISSUES_NONE);
        this.assertCommentSearchResults("haxors", PROJECTS_BOTH, ISSUES_BOTH, ISSUES_NONE);
    }

    private void assertCommentSearchResults(String commentBody, String[] projects, String[] expectedPresent, String[] expectedAbsent) {
        int i;
        this.clickLink("find_link");
        this.getDialog().setWorkingForm("issue-filter");
        if (projects == null || projects.length == 0) {
            this.selectOption("pid", "All projects");
        } else {
            for (i = 0; i < projects.length; ++i) {
                this.selectMultiOption("pid", projects[i]);
            }
        }
        this.checkCheckbox("body", "true");
        this.setFormElement("query", commentBody);
        this.submit("show");
        for (i = 0; i < expectedPresent.length; ++i) {
            this.assertTextPresent(expectedPresent[i]);
        }
        for (i = 0; i < expectedAbsent.length; ++i) {
            this.assertTextNotPresent(expectedAbsent[i]);
        }
    }
}

