/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Worklog;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.WorklogClient;

public class TestWorklogResource
extends RestFuncTest {
    private WorklogClient worklogClient;

    public void testViewWorklog() throws Exception {
        Worklog worklog = this.worklogClient.get("10000");
        TestWorklogResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/worklog/10000"), (String)worklog.self);
        TestWorklogResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/issue/HSP-1"), (String)worklog.issue);
        TestWorklogResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/user?username=admin"), (String)worklog.author.self);
        TestWorklogResource.assertEquals((String)"admin", (String)worklog.author.name);
        TestWorklogResource.assertEquals((String)"Administrator", (String)worklog.author.displayName);
        TestWorklogResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/user?username=admin"), (String)worklog.updateAuthor.self);
        TestWorklogResource.assertEquals((String)"admin", (String)worklog.updateAuthor.name);
        TestWorklogResource.assertEquals((String)"Administrator", (String)worklog.updateAuthor.displayName);
        TestWorklogResource.assertEquals((String)"", (String)worklog.comment);
        this.assertEqualDateStrings("2010-05-24T09:52:41.092+1000", worklog.created);
        this.assertEqualDateStrings("2010-05-24T09:52:41.092+1000", worklog.updated);
        this.assertEqualDateStrings("2010-05-24T09:52:00.000+1000", worklog.started);
        TestWorklogResource.assertEquals((long)120L, (long)worklog.minutesSpent);
    }

    public void testViewWorklogNotFound() throws Exception {
        Response response123 = this.worklogClient.getResponse("123");
        TestWorklogResource.assertEquals((int)404, (int)response123.statusCode);
        TestWorklogResource.assertEquals((int)1, (int)response123.entity.errorMessages.size());
        TestWorklogResource.assertEquals((String)"Cannot find worklog with id: '123'.", (String)response123.entity.errorMessages.get(0));
        Response responseAbc = this.worklogClient.getResponse("abc");
        TestWorklogResource.assertEquals((int)404, (int)responseAbc.statusCode);
        TestWorklogResource.assertEquals((int)1, (int)responseAbc.entity.errorMessages.size());
        TestWorklogResource.assertEquals((String)"Cannot find worklog with id: 'abc'.", (String)responseAbc.entity.errorMessages.get(0));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.worklogClient = new WorklogClient(this.getEnvironmentData());
        this.administration.restoreData("TestWorklogAndTimeTracking.xml");
    }
}

