/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Version;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.VersionClient;

public class TestVersionResource
extends RestFuncTest {
    private VersionClient versionClient;

    public void testViewVersion() throws Exception {
        Version version = this.versionClient.get("10000");
        TestVersionResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/version/10000"), (String)version.self);
        TestVersionResource.assertEquals((String)"Test Version Description 1", (String)version.description);
        TestVersionResource.assertEquals((String)"New Version 1", (String)version.name);
        TestVersionResource.assertFalse((boolean)version.archived);
        TestVersionResource.assertFalse((boolean)version.released);
    }

    public void testViewVersionNotFound() throws Exception {
        Response resp1 = this.versionClient.getResponse("1");
        TestVersionResource.assertEquals((int)404, (int)resp1.statusCode);
        TestVersionResource.assertTrue((boolean)resp1.entity.errorMessages.contains("Could not find version for id '1'"));
        Response respZbing = this.versionClient.getResponse("zbing");
        TestVersionResource.assertEquals((int)404, (int)respZbing.statusCode);
        TestVersionResource.assertTrue((boolean)respZbing.entity.errorMessages.contains("Could not find version for id 'zbing'"));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.versionClient = new VersionClient(this.getEnvironmentData());
        this.administration.restoreBlankInstance();
    }
}

