/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Group;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.User;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.UserClient;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class TestUserResource
extends RestFuncTest {
    private static final String USER_PATH = "user";
    private static final String REST_PATH = "rest/api/2.0.alpha1";
    private static final String REST_USER_URL = "rest/api/2.0.alpha1/user";
    private UserClient userClient;

    public void testUserResourceNoUsername() throws Exception {
        Response response = this.userClient.getResponse(null);
        TestUserResource.assertEquals((int)404, (int)response.statusCode);
        TestUserResource.assertTrue((boolean)response.entity.errorMessages.contains("The username query parameter was not provided"));
    }

    public void testUserResourceForUserThatDoesntExist() throws Exception {
        Response response = this.userClient.getResponse("bofh");
        TestUserResource.assertEquals((int)404, (int)response.statusCode);
        TestUserResource.assertTrue((boolean)response.entity.errorMessages.contains("The user named 'bofh' does not exist"));
    }

    public void testUserResourceGroupsNotExpanded() throws Exception {
        String username = "fred";
        String userPath = this.getPathFor("fred");
        User user = this.userClient.get("fred", new User.Expand[0]);
        TestUserResource.assertEquals((String)this.getBaseUrlPlus(userPath), (String)user.self);
        TestUserResource.assertEquals((String)"groups", (String)user.expand);
        TestUserResource.assertNotNull((Object)user.groups.size);
        TestUserResource.assertEquals((long)1L, (long)user.groups.size);
        TestUserResource.assertNotNull(user.groups.items);
        TestUserResource.assertTrue((boolean)user.groups.items.isEmpty());
    }

    public void testUserResourceGroupsExpanded() throws Exception {
        String username = "fred";
        String userPath = this.getPathFor("fred");
        User user = this.userClient.get("fred", User.Expand.groups);
        TestUserResource.assertEquals((String)this.getBaseUrlPlus(userPath), (String)user.self);
        TestUserResource.assertNotNull(user.groups);
        TestUserResource.assertEquals((long)1L, (long)user.groups.size);
        TestUserResource.assertNotNull(user.groups.items);
        TestUserResource.assertEquals((int)1, (int)user.groups.items.size());
        TestUserResource.assertEquals((String)"jira-users", (String)((Group)user.groups.items.get((int)0)).name);
    }

    public void testGetAnonymouslyUserResource() throws Exception {
        Response response = ((UserClient)this.userClient.anonymous()).getResponse("fred");
        TestUserResource.assertEquals((int)401, (int)response.statusCode);
    }

    public void testUnicodeCharacters() throws Exception {
        String username = "\u611b";
        String userPath = this.getPathFor("%E6%84%9B");
        User user = this.userClient.get("\u611b", new User.Expand[0]);
        TestUserResource.assertEquals((String)this.getBaseUrlPlus(userPath), (String)user.self);
        TestUserResource.assertEquals((String)"\u611b", (String)user.name);
        TestUserResource.assertEquals((String)"\u611b \u6237", (String)user.displayName);
        TestUserResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/user?username=%E6%84%9B"), (String)user.self);
        TestUserResource.assertEquals((String)this.getBaseUrlPlus("secure/useravatar?size=large&ownerId=%E6%84%9B"), (String)user.avatarUrl);
    }

    public void testUsernamesWithInterestingCharacters() throws Exception {
        this.assertUserRepresentationIsOK("a\\b", "a%5Cb");
        this.assertUserRepresentationIsOK("c/d", "c/d");
        this.assertUserRepresentationIsOK("sp ace", "sp+ace");
        this.assertUserRepresentationIsOK("pl+us", "pl%2Bus");
        this.assertUserRepresentationIsOK("per%cent", "per%25cent");
        this.assertUserRepresentationIsOK("\u611b", "%E6%84%9B");
    }

    public void testUserResourceShouldMaskEmailAddresses() throws Exception {
        this.administration.generalConfiguration().setUserEmailVisibility(GeneralConfiguration.EmailVisibility.MASKED);
        User user = this.userClient.get("fred", new User.Expand[0]);
        Assert.assertThat((Object)user.emailAddress, (Matcher)CoreMatchers.equalTo((Object)"fred at example dot com"));
    }

    public void testUserResourceShouldHideEmailAddresses() throws Exception {
        this.administration.generalConfiguration().setUserEmailVisibility(GeneralConfiguration.EmailVisibility.HIDDEN);
        User user = this.userClient.get("fred", new User.Expand[0]);
        TestUserResource.assertNull((Object)user.emailAddress);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.userClient = new UserClient(this.getEnvironmentData());
        this.administration.restoreData("TestUserResource.xml");
    }

    protected String getPathFor(String username) {
        return this.getPathFor(username, Collections.emptyMap());
    }

    private void assertUserRepresentationIsOK(String username, String encodedUsername) {
        String userPath = this.getPathFor(encodedUsername);
        User user = this.userClient.get(username, new User.Expand[0]);
        TestUserResource.assertEquals((String)username, (String)user.name);
        TestUserResource.assertEquals((String)"The username is not encoded in the self link", (String)this.getBaseUrlPlus("rest/api/2.0.alpha1/user?username=" + encodedUsername), (String)user.self);
        TestUserResource.assertEquals((String)"The username is not encoded in the avatar URL", (String)this.getBaseUrlPlus("secure/useravatar?size=large&ownerId=" + encodedUsername), (String)user.avatarUrl);
    }

    protected String getPathFor(String username, Map<?, ?> queryParams) {
        return "rest/api/2.0.alpha1/user?username=" + username + StringUtils.join((Collection)Collections2.transform(queryParams.entrySet(), (Function)new Function<Map.Entry, Object>(){

            public Object apply(Map.Entry from) {
                return String.format("&%s=%s", from.getKey(), from.getValue());
            }
        }), (String)"");
    }
}

