/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Priority;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.PriorityClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;

public class TestPriorityResource
extends RestFuncTest {
    private PriorityClient priorityClient;

    public void testViewPriority() throws Exception {
        Priority priority = this.priorityClient.get("1");
        TestPriorityResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/priority/1"), (String)priority.self);
        TestPriorityResource.assertEquals((String)"#cc0000", (String)priority.statusColor);
        TestPriorityResource.assertEquals((String)"Blocks development and/or testing work, production could not run.", (String)priority.description);
        TestPriorityResource.assertEquals((String)this.getBaseUrlPlus("images/icons/priority_blocker.gif"), (String)priority.iconUrl);
        TestPriorityResource.assertEquals((String)"Blocker", (String)priority.name);
    }

    public void testViewPriorityNotFound() throws Exception {
        Response resp123 = this.priorityClient.getResponse("123");
        TestPriorityResource.assertEquals((int)404, (int)resp123.statusCode);
        TestPriorityResource.assertEquals((int)1, (int)resp123.entity.errorMessages.size());
        TestPriorityResource.assertTrue((boolean)resp123.entity.errorMessages.contains("The priority with id '123' does not exist"));
        Response respFoo = this.priorityClient.getResponse("foo");
        TestPriorityResource.assertEquals((int)404, (int)respFoo.statusCode);
        TestPriorityResource.assertTrue((boolean)respFoo.entity.errorMessages.contains("The priority with id 'foo' does not exist"));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.priorityClient = new PriorityClient(this.getEnvironmentData());
        this.administration.restoreBlankInstance();
    }
}

