/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Comment;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Issue;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueLink;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.LinkIssueClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.LinkRequest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;
import java.util.List;

public class TestLinkIssueResource
extends RestFuncTest {
    private LinkIssueClient linkIssueClient;
    private IssueClient issueClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.linkIssueClient = new LinkIssueClient(this.getEnvironmentData());
        this.issueClient = new IssueClient(this.getEnvironmentData());
        this.administration.restoreData("TestLinkIssueResource.xml");
    }

    public void testLinkIssuesWithComment() throws Exception {
        Comment comment;
        LinkRequest linkRequest = new LinkRequest();
        linkRequest.comment = comment = new Comment();
        comment.body = "Issue linked via REST!";
        linkRequest.linkType = "Duplicate";
        linkRequest.fromIssueKey = "HSP-1";
        linkRequest.toIssueKey = "MKY-1";
        Response response = this.linkIssueClient.linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)200, (int)response.statusCode);
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Issue.IssueField<List<Comment>> comments = issue.fields.comment;
        TestLinkIssueResource.assertEquals((String)"Issue linked via REST!", (String)((Comment)((List)comments.value).get((int)0)).body);
        Issue.IssueField<List<IssueLink>> issueLinks = issue.fields.links;
        IssueLink issueLink = (IssueLink)((List)issueLinks.value).get(0);
        TestLinkIssueResource.assertEquals((String)"MKY-1", (String)issueLink.issueKey);
        IssueLink.Type type = issueLink.type;
        TestLinkIssueResource.assertEquals((String)"Duplicate", (String)type.name);
        TestLinkIssueResource.assertEquals((String)"Duplicates", (String)type.description);
        TestLinkIssueResource.assertEquals((String)"OUTBOUND", (String)type.direction);
        issue = this.issueClient.get("MKY-1", new Issue.Expand[0]);
        comments = issue.fields.comment;
        TestLinkIssueResource.assertEquals((int)0, (int)((List)comments.value).size());
        issueLinks = issue.fields.links;
        issueLink = (IssueLink)((List)issueLinks.value).get(0);
        TestLinkIssueResource.assertEquals((String)"HSP-1", (String)issueLink.issueKey);
        type = issueLink.type;
        TestLinkIssueResource.assertEquals((String)"Duplicate", (String)type.name);
        TestLinkIssueResource.assertEquals((String)"Duplicated by", (String)type.description);
        TestLinkIssueResource.assertEquals((String)"INBOUND", (String)type.direction);
    }

    public void testLinkIssues() throws Exception {
        LinkRequest linkRequest = new LinkRequest();
        linkRequest.linkType = "Duplicate";
        linkRequest.fromIssueKey = "HSP-1";
        linkRequest.toIssueKey = "MKY-1";
        Response response = this.linkIssueClient.linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)200, (int)response.statusCode);
    }

    public void testLinkIssuesWithInvalidRoleLevelSpecified() throws Exception {
        Comment comment;
        LinkRequest linkRequest = new LinkRequest();
        linkRequest.comment = comment = new Comment();
        comment.body = "Issue linked via REST!";
        comment.visibility = new Comment.Visibility("ROLE", "Developers");
        linkRequest.linkType = "Duplicate";
        linkRequest.fromIssueKey = "HSP-1";
        linkRequest.toIssueKey = "MKY-1";
        Response response = this.linkIssueClient.linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)400, (int)response.statusCode);
        TestLinkIssueResource.assertEquals((String)"You are currently not a member of the project role: Developers.", (String)response.entity.errors.values().iterator().next());
    }

    public void testLinkIssuesWithGroupLevelSpecified() throws Exception {
        Comment comment;
        LinkRequest linkRequest = new LinkRequest();
        linkRequest.comment = comment = new Comment();
        comment.body = "Issue linked via REST!";
        comment.visibility = new Comment.Visibility("GROUP", "jira-administrators");
        linkRequest.linkType = "Duplicate";
        linkRequest.fromIssueKey = "HSP-1";
        linkRequest.toIssueKey = "MKY-1";
        Response response = this.linkIssueClient.linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)200, (int)response.statusCode);
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Issue.IssueField<List<Comment>> comments = issue.fields.comment;
        TestLinkIssueResource.assertEquals((String)"Issue linked via REST!", (String)((Comment)((List)comments.value).get((int)0)).body);
    }

    public void testLinkIssuesWithRoleLevelSpecified() throws Exception {
        Comment comment;
        LinkRequest linkRequest = new LinkRequest();
        linkRequest.comment = comment = new Comment();
        comment.body = "Issue linked via REST!";
        comment.visibility = new Comment.Visibility("ROLE", "Administrators");
        linkRequest.linkType = "Duplicate";
        linkRequest.fromIssueKey = "HSP-1";
        linkRequest.toIssueKey = "MKY-1";
        Response response = this.linkIssueClient.linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)200, (int)response.statusCode);
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Issue.IssueField<List<Comment>> comments = issue.fields.comment;
        TestLinkIssueResource.assertEquals((String)"Issue linked via REST!", (String)((Comment)((List)comments.value).get((int)0)).body);
    }

    public void testLinkIssuesFailedBecauseIssueLinkingDisabled() throws Exception {
        Comment comment;
        this.oldway_consider_porting.deactivateIssueLinking();
        LinkRequest linkRequest = new LinkRequest();
        linkRequest.comment = comment = new Comment();
        comment.body = "Issue linked via REST!";
        linkRequest.linkType = "Duplicate";
        linkRequest.fromIssueKey = "HSP-1";
        linkRequest.toIssueKey = "MKY-1";
        Response response = this.linkIssueClient.linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)404, (int)response.statusCode);
        TestLinkIssueResource.assertEquals((String)"Issue linking is currently disabled.", (String)response.entity.errorMessages.get(0));
    }

    public void testLinkIssuesFailedIssueANotVisible() throws Exception {
        Comment comment;
        LinkRequest linkRequest = new LinkRequest();
        linkRequest.comment = comment = new Comment();
        comment.body = "Issue linked via REST!";
        linkRequest.linkType = "Duplicate";
        linkRequest.fromIssueKey = "HSP-1";
        linkRequest.toIssueKey = "MKY-1";
        Response response = ((LinkIssueClient)this.linkIssueClient.loginAs("fred")).linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)404, (int)response.statusCode);
        TestLinkIssueResource.assertEquals((String)"You do not have the permission to see the specified issue", (String)response.entity.errorMessages.get(0));
    }

    public void testLinkIssuesFailedIssueBNotVisible() throws Exception {
        Comment comment;
        LinkRequest linkRequest = new LinkRequest();
        linkRequest.comment = comment = new Comment();
        comment.body = "Issue linked via REST!";
        linkRequest.linkType = "Duplicate";
        linkRequest.fromIssueKey = "HSP-1";
        linkRequest.toIssueKey = "MKY-1";
        Response response = ((LinkIssueClient)this.linkIssueClient.loginAs("bob")).linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)404, (int)response.statusCode);
        TestLinkIssueResource.assertEquals((String)"You do not have the permission to see the specified issue", (String)response.entity.errorMessages.get(0));
    }

    public void testLinkIssuesFailedNoLInkIssuePermissionIssueA() throws Exception {
        Comment comment;
        LinkRequest linkRequest = new LinkRequest();
        linkRequest.comment = comment = new Comment();
        comment.body = "Issue linked via REST!";
        linkRequest.linkType = "Duplicate";
        linkRequest.fromIssueKey = "HSP-1";
        linkRequest.toIssueKey = "HSP-2";
        Response response = ((LinkIssueClient)this.linkIssueClient.loginAs("bob")).linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)401, (int)response.statusCode);
        TestLinkIssueResource.assertEquals((String)"No Link Issue Permission for issue 'HSP-1'", (String)response.entity.errorMessages.get(0));
    }

    public void testLinkIssuesFailedNoLInkIssuePermissionIssueB() throws Exception {
        Comment comment;
        LinkRequest linkRequest = new LinkRequest();
        linkRequest.comment = comment = new Comment();
        comment.body = "Issue linked via REST!";
        linkRequest.linkType = "Duplicate";
        linkRequest.fromIssueKey = "MKY-1";
        linkRequest.toIssueKey = "MKY-2";
        Response response = ((LinkIssueClient)this.linkIssueClient.loginAs("fred")).linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)401, (int)response.statusCode);
        TestLinkIssueResource.assertEquals((String)"No Link Issue Permission for issue 'MKY-1'", (String)response.entity.errorMessages.get(0));
    }

    public void testLinkIssuesFailedBecauseLinkTypeDoesNotExist() throws Exception {
        Comment comment;
        LinkRequest linkRequest = new LinkRequest();
        linkRequest.comment = comment = new Comment();
        comment.body = "Issue linked via REST!";
        linkRequest.linkType = "calculated";
        linkRequest.fromIssueKey = "MKY-1";
        linkRequest.toIssueKey = "MKY-2";
        Response response = this.linkIssueClient.linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)404, (int)response.statusCode);
        TestLinkIssueResource.assertEquals((String)"No issue link type with name 'calculated' found.", (String)response.entity.errorMessages.get(0));
    }

    public void testLinkIssuesLinkIssuePermissionForIssueAButNotB() throws Exception {
        Comment comment;
        LinkRequest linkRequest = new LinkRequest();
        linkRequest.comment = comment = new Comment();
        comment.body = "Issue linked via REST!";
        linkRequest.linkType = "Duplicate";
        linkRequest.fromIssueKey = "HSP-1";
        linkRequest.toIssueKey = "MKY-1";
        Response response = ((LinkIssueClient)this.linkIssueClient.loginAs("linker")).linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)200, (int)response.statusCode);
    }

    public void testLinkIssuesNoLinkIssuePermissionForIssueBButB() throws Exception {
        Comment comment;
        LinkRequest linkRequest = new LinkRequest();
        linkRequest.comment = comment = new Comment();
        comment.body = "Issue linked via REST!";
        linkRequest.linkType = "Duplicate";
        linkRequest.fromIssueKey = "MKY-1";
        linkRequest.toIssueKey = "HSP-1";
        Response response = ((LinkIssueClient)this.linkIssueClient.loginAs("linker")).linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)401, (int)response.statusCode);
        TestLinkIssueResource.assertEquals((String)"No Link Issue Permission for issue 'MKY-1'", (String)response.entity.errorMessages.get(0));
    }
}

