/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Issue;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.User;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Worklog;
import java.util.List;

public class TestIssueResourceWorklog
extends RestFuncTest {
    private IssueClient issueClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient(this.getEnvironmentData());
        this.administration.restoreData("TestWorklogAndTimeTracking.xml");
    }

    public void testView() throws Exception {
        Issue json = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        List worklogs = (List)json.fields.worklog.value;
        TestIssueResourceWorklog.assertEquals((int)1, (int)worklogs.size());
        Worklog log = (Worklog)worklogs.get(0);
        TestIssueResourceWorklog.assertNotNull((Object)log.self);
        TestIssueResourceWorklog.assertEquals((String)"", (String)log.comment);
        TestIssueResourceWorklog.assertEquals((long)120L, (long)log.minutesSpent);
        this.assertEqualDateStrings("2010-05-24T09:52:41.092+1000", log.created);
        this.assertEqualDateStrings("2010-05-24T09:52:41.092+1000", log.updated);
        this.assertEqualDateStrings("2010-05-24T09:52:00.000+1000", log.started);
        TestIssueResourceWorklog.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-1"), (String)log.issue);
        User author = log.author;
        TestIssueResourceWorklog.assertNotNull((Object)author.self);
        TestIssueResourceWorklog.assertEquals((String)"admin", (String)author.name);
        TestIssueResourceWorklog.assertEquals((String)"Administrator", (String)author.displayName);
        User updateAuthor = log.updateAuthor;
        TestIssueResourceWorklog.assertNotNull((Object)updateAuthor.self);
        TestIssueResourceWorklog.assertEquals((String)"admin", (String)updateAuthor.name);
        TestIssueResourceWorklog.assertEquals((String)"Administrator", (String)updateAuthor.displayName);
    }

    public void testViewLoggedByDeletedUser() throws Exception {
        Issue json = this.issueClient.get("HSP-3", new Issue.Expand[0]);
        List worklogs = (List)json.fields.worklog.value;
        TestIssueResourceWorklog.assertEquals((int)1, (int)worklogs.size());
        Worklog log = (Worklog)worklogs.get(0);
        TestIssueResourceWorklog.assertNotNull((Object)log.self);
        TestIssueResourceWorklog.assertEquals((String)"spent a whole minute on this", (String)log.comment);
        TestIssueResourceWorklog.assertEquals((long)1L, (long)log.minutesSpent);
        this.assertEqualDateStrings("2010-07-12T12:47:39.198+1000", log.created);
        this.assertEqualDateStrings("2010-07-12T12:47:39.198+1000", log.updated);
        this.assertEqualDateStrings("2010-07-12T12:47:00.000+1000", log.started);
        TestIssueResourceWorklog.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-3"), (String)log.issue);
        User author = log.author;
        TestIssueResourceWorklog.assertEquals((String)"deleted", (String)author.name);
        User updateAuthor = log.updateAuthor;
        TestIssueResourceWorklog.assertEquals((String)"deleted", (String)updateAuthor.name);
    }
}

