/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Comment;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Issue;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Resolution;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Status;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Transition;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.TransitionPost;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.TransitionsClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Version;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class TestIssueResourceTransitions
extends RestFuncTest {
    private IssueClient issueClient;
    private TransitionsClient transitionsClient;

    public void testTransitionLink() throws Exception {
        this.administration.restoreData("TestWorkflowActions.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        TestIssueResourceTransitions.assertEquals((String)(this.getEnvironmentData().getBaseUrl().toExternalForm() + "/rest/api/2.0.alpha1/issue/HSP-1/transitions"), (String)issue.transitions);
    }

    public void testCustomFieldInTransition() throws Exception {
        this.administration.restoreData("TestIssueResourceTransitions.xml");
        Map<Integer, Transition> transitions = this.transitionsClient.get("HSP-1");
        List<Transition.TransitionField> fields = transitions.get((Object)Integer.valueOf((int)2)).fields;
        for (Transition.TransitionField field : fields) {
            if (!field.id.equals("customfield_10000")) continue;
            TestIssueResourceTransitions.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:float", (String)field.type);
        }
    }

    public void testNumberCustomFieldLocalized() throws Exception {
        this.administration.restoreData("TestIssueResourceTransitions.xml");
        this.navigation.userProfile().changeUserLanguage("French (France)");
        TransitionPost transition = new TransitionPost();
        transition.transition = 2;
        transition.fields.put("resolution", "Duplicate");
        transition.fields.put("customfield_10000", 2.5);
        Response response = this.transitionsClient.postResponse("HSP-1", transition);
        TestIssueResourceTransitions.assertEquals((int)204, (int)response.statusCode);
    }

    public void testTransitionGET() throws Exception {
        this.administration.restoreData("TestWorkflowActions.xml");
        Map<Integer, Transition> transitions = this.transitionsClient.get("HSP-1");
        TestIssueResourceTransitions.assertEquals((int)3, (int)transitions.size());
        List<Transition.TransitionField> fields = Arrays.asList(new Transition.TransitionField("resolution", true, "com.atlassian.jira.issue.resolution.Resolution"), new Transition.TransitionField("fixVersions", false, "com.atlassian.jira.project.version.Version"), new Transition.TransitionField("assignee", false, "com.opensymphony.user.User"));
        Transition transition = transitions.get(2);
        TestIssueResourceTransitions.assertEquals((String)"Close Issue", (String)transition.name);
        List<Transition.TransitionField> closeIssue = transition.fields;
        TestIssueResourceTransitions.assertEquals((int)3, (int)closeIssue.size());
        TestIssueResourceTransitions.assertEquals(fields, closeIssue);
        transition = transitions.get(5);
        TestIssueResourceTransitions.assertEquals((String)"Resolve Issue", (String)transition.name);
        List<Transition.TransitionField> resolveIssue = transition.fields;
        TestIssueResourceTransitions.assertEquals((int)3, (int)resolveIssue.size());
        TestIssueResourceTransitions.assertEquals(fields, resolveIssue);
        transition = transitions.get(4);
        TestIssueResourceTransitions.assertEquals((String)"Start Progress", (String)transition.name);
        List<Transition.TransitionField> startProgress = transition.fields;
        TestIssueResourceTransitions.assertEquals((int)0, (int)startProgress.size());
    }

    public void testTransitionPUT_noComment() throws Exception {
        this.administration.restoreData("TestWorkflowActions.xml");
        String transitionURL = this.getEnvironmentData().getBaseUrl().toExternalForm() + "/rest/api/2.0.alpha1/issue/HSP-1/transitions";
        TransitionPost transition = new TransitionPost();
        transition.transition = 2;
        transition.fields.put("resolution", "Won't Fix");
        transition.fields.put("fixVersions", CollectionBuilder.newBuilder("New Version 4", "New Version 5").asCollection());
        Response response = this.transitionsClient.postResponse("HSP-1", transition);
        TestIssueResourceTransitions.assertEquals((int)204, (int)response.statusCode);
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        TestIssueResourceTransitions.assertEquals((String)"Closed", (String)((Status)issue.fields.status.value).name);
        TestIssueResourceTransitions.assertEquals((String)"Won't Fix", (String)((Resolution)issue.fields.resolution.value).name);
        TestIssueResourceTransitions.assertEquals((String)"New Version 4", (String)((Version)((List)issue.fields.fixVersions.value).get((int)0)).name);
        TestIssueResourceTransitions.assertEquals((String)"New Version 5", (String)((Version)((List)issue.fields.fixVersions.value).get((int)1)).name);
    }

    public void testTransitionPOST_invalidRole() throws Exception {
        this.administration.restoreData("TestWorkflowActions.xml");
        TransitionPost transitionPost = new TransitionPost();
        transitionPost.transition = 2;
        transitionPost.fields.put("resolution", "Won't Fix");
        Comment comment = new Comment("My comment", "some-non-existing-role");
        comment.visibility = new Comment.Visibility("ROLE", "NON-EXISTING-ROLE");
        transitionPost.comment = comment;
        Response response = this.transitionsClient.postResponse("HSP-1", transitionPost);
        TestIssueResourceTransitions.assertEquals((int)400, (int)response.statusCode);
        TestIssueResourceTransitions.assertEquals((String)"Invalid role [NON-EXISTING-ROLE]", (String)response.entity.errorMessages.get(0));
    }

    public void testBasicTimeTracking() throws Exception {
        this.administration.restoreData("TestRESTTransitionsSimple.xml");
        this.transitionsClient.get("MKY-1");
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient(this.getEnvironmentData());
        this.transitionsClient = new TransitionsClient(this.getEnvironmentData());
    }
}

