/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Comment;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Issue;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueClient;
import java.util.List;

public class TestIssueResourceComments
extends RestFuncTest {
    private IssueClient issueClient;

    public void testCommentRendering() throws Exception {
        this.administration.restoreData("TestEditComment.xml");
        Issue hsp1 = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        TestIssueResourceComments.assertEquals((String)"I'm a hero!", (String)((Comment)((List)hsp1.fields.comment.value).get((int)0)).body);
        Issue expandedHsp1 = this.issueClient.get("HSP-1", Issue.Expand.html);
        TestIssueResourceComments.assertEquals((String)"I'm a hero!", (String)((Comment)((List)expandedHsp1.fields.comment.value).get((int)0)).body);
        TestIssueResourceComments.assertEquals((String)"I&#39;m a hero!", (String)expandedHsp1.html.comment.get(0));
    }

    public void testSystemTextFieldRendering() throws Exception {
        this.administration.restoreData("TestEditComment.xml");
        this.navigation.issue().setDescription("HSP-1", "I'll have 5<10<15 things?");
        this.navigation.issue().setEnvironment("HSP-1", "I'll have 5<10<15 things?");
        Issue hsp1 = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        TestIssueResourceComments.assertEquals((String)"\r\nI'll have 5<10<15 things?", (String)((String)hsp1.fields.description.value));
        TestIssueResourceComments.assertEquals((String)"I'll have 5<10<15 things?", (String)((String)hsp1.fields.environment.value));
        Issue expandedHsp1 = this.issueClient.get("HSP-1", Issue.Expand.html);
        TestIssueResourceComments.assertEquals((String)"\r<br/>\nI&#39;ll have 5&lt;10&lt;15 things?", (String)expandedHsp1.html.description);
        TestIssueResourceComments.assertEquals((String)"I&#39;ll have 5&lt;10&lt;15 things?", (String)expandedHsp1.html.environment);
    }

    public void testComment() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.generalConfiguration().setCommentVisibility(GeneralConfiguration.CommentVisibility.PROJECT_ROLES);
        this.administration.roles().addProjectRoleForUser("Monkey", 10002, "admin");
        String key = this.navigation.issue().createIssue("monkey", "Bug", "First Test Issue");
        this.navigation.issue().addComment(key, "comment", "Administrators");
        Issue issue = this.issueClient.get(key, new Issue.Expand[0]);
        TestIssueResourceComments.assertEquals((int)1, (int)((List)issue.fields.comment.value).size());
        this.tester.gotoPage("/rest/api/2.0.alpha1/issue/" + key);
        Comment comment = (Comment)((List)issue.fields.comment.value).get(0);
        TestIssueResourceComments.assertEquals((String)"comment", (String)comment.body);
        TestIssueResourceComments.assertEquals((String)"ROLE", (String)comment.visibility.type);
        TestIssueResourceComments.assertEquals((String)"Administrators", (String)comment.visibility.value);
        TestIssueResourceComments.assertNotNull((Object)comment.created);
        TestIssueResourceComments.assertNotNull((Object)comment.updated);
        TestIssueResourceComments.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2.0.alpha1/comment/10000"), (String)comment.self);
        TestIssueResourceComments.assertEquals((String)"admin", (String)comment.author.name);
        TestIssueResourceComments.assertEquals((String)"Administrator", (String)comment.author.displayName);
        TestIssueResourceComments.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2.0.alpha1/user?username=admin"), (String)comment.author.self);
        TestIssueResourceComments.assertEquals((String)"admin", (String)comment.updateAuthor.name);
        TestIssueResourceComments.assertEquals((String)"Administrator", (String)comment.updateAuthor.displayName);
        TestIssueResourceComments.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2.0.alpha1/user?username=admin"), (String)comment.updateAuthor.self);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient(this.getEnvironmentData());
    }
}

