/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.webtests.JIRAWebTest;
import java.util.ArrayList;
import java.util.Arrays;

public class TestBulkOperationIssueNavigator
extends JIRAWebTest {
    public TestBulkOperationIssueNavigator(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestBulkOperationIssueNavigator.xml");
    }

    @Override
    public void tearDown() {
        super.tearDown();
    }

    public void testColumns() {
        this._testUnsavedFilter();
        this._testCustomFilterCustomColumns();
        this._testCustomFilterStandardColumns();
    }

    public void _testUnsavedFilter() {
        this.clickLink("find_link");
        this.submit("show");
        this.assertColumnsInBulkWizard(new Object[]{"T", "Key", "Summary", "Assignee", "Reporter", "Status", "Resolution", "Created", "Updated"});
    }

    public void _testCustomFilterCustomColumns() {
        this.navigation.issueNavigator().loadFilter(10011L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertColumnsInBulkWizard(new Object[]{"T", "Key", "Summary"});
    }

    public void _testCustomFilterStandardColumns() {
        this.navigation.issueNavigator().loadFilter(10010L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertColumnsInBulkWizard(new Object[]{"T", "Key", "Summary", "Assignee", "Reporter", "Status", "Resolution", "Created", "Updated"});
    }

    private void assertColumnsInBulkWizard(Object[] headerRow) {
        this.assertTableHasMatchingRow(this.getWebTableWithID("issuetable"), headerRow);
        this.clickLink("bulkedit_all");
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(headerRow));
        list.add(0, null);
        this.assertTableHasMatchingRow(this.getWebTableWithID("issuetable"), list.toArray());
        this.checkCheckbox("bulkedit_10030", "on");
        this.submit("Next");
        this.checkCheckbox("operation", "bulk.edit.operation.name");
        this.submit("Next");
        this.checkCheckbox("actions", "comment");
        this.setFormElement("comment", "Test");
        this.submit("Next");
        this.assertTableHasMatchingRow(this.getWebTableWithID("issuetable"), headerRow);
    }
}

