/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.navigation.BulkChangeWizard;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;

public class TestBulkMoveTimeTracking
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestTimeTrackingBulkMove.xml");
    }

    public void testValidationInModernMode() throws Exception {
        this.administration.fieldConfigurations().defaultFieldConfiguration().requireField("Log Work");
        BulkChangeWizard wizard = this.bulkMoveAllIssuesToProject("monkey");
        this.text.assertTextNotPresent(new WebPageLocator(this.tester), "Log Work");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Time Tracking");
        wizard.finaliseFields();
        WebPageLocator pageLocator = new WebPageLocator(this.tester);
        this.text.assertTextPresent(pageLocator, "Original Estimate is required");
        this.text.assertTextPresent(pageLocator, "Remaining Estimate is required");
        wizard.setFieldValue("timetracking_originalestimate", "xxx").setFieldValue("timetracking_remainingestimate", "6h").finaliseFields();
        pageLocator = new WebPageLocator(this.tester);
        this.text.assertTextPresent(pageLocator, "The original estimate specified is not valid.");
        this.text.assertTextNotPresent(pageLocator, "The remaining estimate specified is not valid.");
        wizard.setFieldValue("timetracking_originalestimate", "6h").setFieldValue("timetracking_remainingestimate", "xxx").finaliseFields();
        pageLocator = new WebPageLocator(this.tester);
        this.text.assertTextNotPresent(pageLocator, "The original estimate specified is not valid.");
        this.text.assertTextPresent(pageLocator, "The remaining estimate specified is not valid.");
    }

    public void testValidationInLegacyMode() throws Exception {
        this.administration.timeTracking().switchMode(TimeTracking.Mode.LEGACY);
        BulkChangeWizard wizard = this.bulkMoveAllIssuesToProject("monkey");
        wizard.finaliseFields();
        WebPageLocator pageLocator = new WebPageLocator(this.tester);
        this.text.assertTextPresent(pageLocator, "Time Tracking is required.");
        wizard.setFieldValue("timetracking", "xxx").finaliseFields();
        pageLocator = new WebPageLocator(this.tester);
        this.text.assertAtLeastOneTextPresent(pageLocator, "The original estimate specified is not valid.", "The remaining estimate specified is not valid.");
    }

    public void testOnlyOriginalEstimateSpecifiedNoRetainInModernMode() throws Exception {
        this.bulkMoveAllIssuesToProject("monkey").setFieldValue("timetracking_originalestimate", "6h").finaliseFields().complete();
        this.tester.clickLinkWithText("Issue 1");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("6h", "6h", "3d");
        this.navigation.issue().returnToSearch();
        this.tester.clickLinkWithText("Issue to move with no Time Tracking");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("6h", "6h", "Not Specified");
    }

    public void testOnlyOriginalEstimateSpecifiedRetainCheckedInModernMode() throws Exception {
        this.bulkMoveAllIssuesToProject("monkey").setFieldValue("timetracking_originalestimate", "6h").checkRetainForField("timetracking").finaliseFields().complete();
        this.tester.clickLinkWithText("Issue 1");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("1w", "1d", "3d");
        this.navigation.issue().returnToSearch();
        this.tester.clickLinkWithText("Issue to move with no Time Tracking");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("6h", "6h", "Not Specified");
    }

    public void testOnlyRemainingEstimateSpecifiedNoRetainInModernMode() throws Exception {
        this.bulkMoveAllIssuesToProject("monkey").setFieldValue("timetracking_remainingestimate", "3h").finaliseFields().complete();
        this.tester.clickLinkWithText("Issue 1");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("3h", "3h", "3d");
        this.navigation.issue().returnToSearch();
        this.tester.clickLinkWithText("Issue to move with no Time Tracking");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("3h", "3h", "Not Specified");
    }

    public void testOnlyRemainingEstimateSpecifiedRetainCheckedInModernMode() throws Exception {
        this.bulkMoveAllIssuesToProject("monkey").setFieldValue("timetracking_remainingestimate", "3h").checkRetainForField("timetracking").finaliseFields().complete();
        this.tester.clickLinkWithText("Issue 1");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("1w", "1d", "3d");
        this.navigation.issue().returnToSearch();
        this.tester.clickLinkWithText("Issue to move with no Time Tracking");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("3h", "3h", "Not Specified");
    }

    public void testBothSpecifiedNoRetainInModernMode() throws Exception {
        this.bulkMoveAllIssuesToProject("monkey").setFieldValue("timetracking_originalestimate", "4h").setFieldValue("timetracking_remainingestimate", "2h").finaliseFields().complete();
        this.tester.clickLinkWithText("Issue 1");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("4h", "2h", "3d");
        this.navigation.issue().returnToSearch();
        this.tester.clickLinkWithText("Issue to move with no Time Tracking");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("4h", "2h", "Not Specified");
    }

    public void testBothSpecifiedRetainCheckedInModernMode() throws Exception {
        this.bulkMoveAllIssuesToProject("monkey").setFieldValue("timetracking_originalestimate", "4h").setFieldValue("timetracking_remainingestimate", "2h").checkRetainForField("timetracking").finaliseFields().complete();
        this.tester.clickLinkWithText("Issue 1");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("1w", "1d", "3d");
        this.navigation.issue().returnToSearch();
        this.tester.clickLinkWithText("Issue to move with no Time Tracking");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("4h", "2h", "Not Specified");
    }

    public void testEstimateSpecifiedNoRetainInLegacyMode() throws Exception {
        this.administration.timeTracking().switchMode(TimeTracking.Mode.LEGACY);
        this.bulkMoveAllIssuesToProject("monkey").setFieldValue("timetracking", "1h").finaliseFields().complete();
        this.tester.clickLinkWithText("Issue 1");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("1w", "1h", "3d");
        this.navigation.issue().returnToSearch();
        this.tester.clickLinkWithText("Issue to move with no Time Tracking");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("1h", "1h", "Not Specified");
    }

    public void testEstimateSpecifiedRetainCheckedInLegacyMode() throws Exception {
        this.administration.timeTracking().switchMode(TimeTracking.Mode.LEGACY);
        this.bulkMoveAllIssuesToProject("monkey").setFieldValue("timetracking", "1h").checkRetainForField("timetracking").finaliseFields().complete();
        this.tester.clickLinkWithText("Issue 1");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("1w", "1d", "3d");
        this.navigation.issue().returnToSearch();
        this.tester.clickLinkWithText("Issue to move with no Time Tracking");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("1h", "1h", "Not Specified");
    }

    private BulkChangeWizard bulkMoveAllIssuesToProject(String projectName) {
        this.navigation.issueNavigator().displayAllIssues();
        return this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperations.MOVE).chooseTargetContextForAll(projectName);
    }
}

