/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.meterware.httpunit.HttpUnitOptions;

public class TestAttachFile
extends FuncTestCase {
    private static final String LOGIN = "log in";
    private static final String SIGNUP = "sign up";
    private static final String ANONYMOUS_USERS_GROUP_NAME = "";
    private static final String JIRA_USERS_GROUP_NAME = "jira-users";
    private static final int CREATE_ATTACHMENTS_PERMISSION_ID = 19;

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestFullAnonymousPermissions.xml");
        this.administration.attachments().enable();
    }

    @Override
    public void tearDownTest() {
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        super.tearDownTest();
    }

    public void testAttachFileLoggedIn() {
        this.disallowAnonymousAttachmentCreation();
        this.navigation.issue().gotoIssue("MKY-2");
        this.tester.clickLink("attach-file");
        this.tester.assertElementPresent("attach-file-submit");
    }

    public void testAttachNoFileError() {
        this.navigation.issue().gotoIssue("MKY-2");
        this.tester.clickLink("attach-file");
        this.text.assertTextNotPresent(this.locator.page(), "Errors");
        this.text.assertTextNotPresent(this.locator.page(), "Please indicate the file you wish to upload");
        this.tester.setWorkingForm("attach-file");
        this.tester.submit();
        this.text.assertTextPresent(this.locator.page(), "Please indicate the file you wish to upload");
    }

    public void testAttachFileLoggedOutNoAnonymousPermission() {
        this.disallowAnonymousAttachmentCreation();
        this.navigation.logout();
        this.navigation.clickLinkWithExactText("Log in again.");
        this.navigation.issue().gotoIssue("MKY-2");
        this.tester.assertLinkNotPresent("attach-file");
        this.tester.gotoPage("/secure/AttachFile!default.jspa?id=10011");
        this.text.assertTextPresent(this.locator.page(), "You do not have permission to create attachments for this issue.");
        this.text.assertTextPresent(this.locator.page(), "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.tester.assertLinkPresentWithText(LOGIN);
        this.tester.assertLinkPresentWithText(SIGNUP);
        this.tester.assertElementNotPresent("attach-file-submit");
        this.tester.gotoPage("/secure/AttachFile!default.jspa?id=99999");
        this.text.assertTextNotPresent(this.locator.page(), "You do not have permission to create attachments for this issue.");
        this.text.assertTextNotPresent(this.locator.page(), "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.tester.assertElementNotPresent("attach-file-submit");
    }

    public void testAttachFileLoggedOutWithAnonymousPermission() {
        this.navigation.logout();
        this.navigation.clickLinkWithExactText("Log in again.");
        this.navigation.issue().gotoIssue("MKY-2");
        this.tester.clickLink("attach-file");
        this.tester.gotoPage("/secure/AttachFile!default.jspa?id=10011");
        this.tester.assertElementPresent("attach-file-submit");
        this.text.assertTextNotPresent(this.locator.page(), "You are not logged in, and do not have the permissions required to attach a file on the selected issue as a guest.");
        this.tester.gotoPage("/secure/AttachFile!default.jspa?id=99999");
        this.text.assertTextNotPresent(this.locator.page(), "You do not have permission to create attachments for this issue.");
        this.text.assertTextNotPresent(this.locator.page(), "You are not logged in, and do not have the permissions required to attach a file on the selected issue as a guest.");
        this.tester.assertElementNotPresent("attach-file-submit");
    }

    public void testAttachFileLoggedInWithoutPermission() {
        this.disallowAnyoneAttachmentCreation();
        this.navigation.issue().gotoIssue("MKY-2");
        this.tester.assertLinkNotPresent("attach-file");
        this.tester.gotoPage("/secure/AttachFile!default.jspa?id=10011");
        this.text.assertTextPresent(this.locator.page(), "You do not have permission to create attachments for this issue.");
        this.tester.assertElementNotPresent("attach-file-submit");
        this.tester.gotoPage("/secure/AttachFile!default.jspa?id=99999");
        this.text.assertTextNotPresent(this.locator.page(), "You do not have permission to create attachments for this issue.");
        this.text.assertTextNotPresent(this.locator.page(), "You are not logged in, and do not have the permissions required to attach a file on the selected issue as a guest.");
        this.tester.assertElementNotPresent("attach-file-submit");
    }

    private void disallowAnonymousAttachmentCreation() {
        this.administration.permissionSchemes().defaultScheme().removePermission(19, ANONYMOUS_USERS_GROUP_NAME);
    }

    private void disallowUsersAttachmentCreation() {
        this.administration.permissionSchemes().defaultScheme().removePermission(19, JIRA_USERS_GROUP_NAME);
    }

    private void disallowAnyoneAttachmentCreation() {
        this.disallowAnonymousAttachmentCreation();
        this.disallowUsersAttachmentCreation();
    }
}

