/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.meterware.httpunit.SubmitButton;

public class TestXsrfSystemOps
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testSystemOps() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Integrity Checker", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.tester.clickLink("admin_link");
                TestXsrfSystemOps.this.tester.clickLink("integrity_checker");
                TestXsrfSystemOps.this.navigation.checkWebSudoWithLastPassword();
            }
        }, new XsrfCheck.FormSubmission("check")), new XsrfCheck("License Details", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.tester.clickLink("admin_link");
                TestXsrfSystemOps.this.tester.clickLink("license_details");
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Add Listener", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.tester.clickLink("admin_link");
                TestXsrfSystemOps.this.tester.clickLink("listeners");
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Edit Listener", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.tester.clickLink("admin_link");
                TestXsrfSystemOps.this.tester.clickLink("listeners");
                TestXsrfSystemOps.this.tester.setFormElement("name", "l1");
                TestXsrfSystemOps.this.tester.setFormElement("clazz", "com.atlassian.jira.event.listeners.DebugParamListener");
                TestXsrfSystemOps.this.tester.submit("Add");
                TestXsrfSystemOps.this.tester.clickLinkWithText("Edit");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Delete Listener", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.gotoHome();
                TestXsrfSystemOps.this.tester.clickLink("admin_link");
                TestXsrfSystemOps.this.tester.clickLink("listeners");
                TestXsrfSystemOps.this.tester.setFormElement("name", "ldel");
                TestXsrfSystemOps.this.tester.setFormElement("clazz", "com.atlassian.jira.event.listeners.DebugParamListener");
                TestXsrfSystemOps.this.tester.submit("Add");
                TestXsrfSystemOps.this.tester.clickLink("listeners");
            }
        }, new XsrfCheck.LinkWithTextSubmission("Delete")), new XsrfCheck("Mail Queue Flush", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.gotoHome();
                TestXsrfSystemOps.this.tester.clickLink("admin_link");
                TestXsrfSystemOps.this.tester.clickLink("mail_queue");
            }
        }, new XsrfCheck.LinkWithTextSubmission("Flush mail queue")), new XsrfCheck("Add Service", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.navigation.dashboard().navigateTo();
                TestXsrfSystemOps.this.tester.clickLink("admin_link");
                TestXsrfSystemOps.this.tester.clickLink("services");
                TestXsrfSystemOps.this.tester.setFormElement("name", "name");
                TestXsrfSystemOps.this.tester.setFormElement("clazz", "com.atlassian.jira.service.services.export.ExportService");
            }
        }, new XsrfCheck.FormSubmission("Add Service")), new XsrfCheck("Edit Service", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.navigation.dashboard().navigateTo();
                TestXsrfSystemOps.this.tester.clickLink("admin_link");
                TestXsrfSystemOps.this.tester.clickLink("services");
                TestXsrfSystemOps.this.tester.clickLinkWithText("Edit");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Delete Service", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.navigation.dashboard().navigateTo();
                TestXsrfSystemOps.this.tester.clickLink("admin_link");
                TestXsrfSystemOps.this.tester.clickLink("services");
            }
        }, new XsrfCheck.LinkWithTextSubmission("Delete")), new XsrfCheck("ReIndex", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.navigation.dashboard().navigateTo();
                TestXsrfSystemOps.this.tester.clickLink("admin_link");
                TestXsrfSystemOps.this.tester.clickLink("indexing");
            }
        }, new XsrfCheck.AsynchFormSubmission("Re-Index", 30000L){

            @Override
            public boolean isOperationFinished() {
                TestXsrfSystemOps.this.tester.setWorkingForm("jiraform");
                SubmitButton button = TestXsrfSystemOps.this.tester.getDialog().getSubmitButton("Refresh");
                if (button != null) {
                    TestXsrfSystemOps.this.tester.submit("Refresh");
                }
                return TestXsrfSystemOps.this.tester.getDialog().getResponseText().contains("Re-indexing is 100% complete.");
            }
        })).run(this.funcTestHelperFactory);
    }

    private void gotoHome() {
        this.tester.gotoPage("");
    }
}

