/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.scheme;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

public class TestSchemeComparisonTool
extends JIRAWebTest {
    private static final String MANAGE_WATCHERS = "Manage Watchers";

    public TestSchemeComparisonTool(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestSchemeComparisonTool.xml");
    }

    public void testPermissionSchemeComparison() {
        this.gotoPage("secure/admin/SchemeComparisonPicker!default.jspa");
        this.navigation.checkWebSudoWithLastPassword();
        this.assertTextPresent("Scheme Comparison: Select Schemes");
        this.assertTextPresent("Select between 2 and 5 schemes for comparison.");
        this.selectMultiOptionByValue("selectedSchemeIds", "0");
        this.selectMultiOptionByValue("selectedSchemeIds", "10000");
        this.submit("Compare Schemes");
        this.assertTextPresent("If any entries for a permission do not match, the row will be displayed in red and bold.");
        this.assertTextPresent("Scheme Difference: <span class=\"redText\">&nbsp;35%&nbsp;</span>");
        this.assertTextPresent("Set Issue Security");
        this.assertTextPresent("Homosapien Permission Scheme");
        this.assertTextPresent("Default Permission Scheme");
        this.assertTextPresent("Add Comments");
        this.assertTextPresent("Create Attachments");
        this.assertTextPresent("Create Issues");
        this.assertTextPresent("Browse Projects");
        this.assertTextNotPresent("Administer Projects");
        this.assertTextNotPresent("Edit Issues");
        this.assertTextNotPresent("Schedule Issues");
        this.assertTextNotPresent("Move Issues");
        this.assertTextNotPresent("Assign Issues");
        this.assertTextNotPresent("Assignable User");
        this.assertTextNotPresent("Resolve Issues");
        this.assertTextNotPresent("Close Issues");
        this.assertTextNotPresent("Modify Reporter");
        this.assertTextNotPresent("Delete Issues");
        this.assertTextNotPresent("Work On Issues");
        this.assertTextNotPresent("Link Issues");
        this.assertTextNotPresent("View Version Control");
        this.assertTextNotPresent("View Voters and Watchers");
        this.assertTextNotPresent(MANAGE_WATCHERS);
    }

    public void testNotificationSchemesHaveNoDifference() {
        this.gotoPage("secure/admin/SchemeComparisonPicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
        this.navigation.checkWebSudoWithLastPassword();
        this.selectMultiOptionByValue("selectedSchemeIds", "10021");
        this.selectMultiOptionByValue("selectedSchemeIds", "10000");
        this.submit("Compare Schemes");
        this.assertTextPresent("If any entries for a notification event do not match");
        this.assertTextPresent("Scheme Difference: <span class=\"greenText\">&nbsp;0% (identical)&nbsp;</span>");
        this.assertTextNotPresent("Issue Resolved");
        this.assertTextNotPresent("Issue Assigned");
        this.assertTextNotPresent("Work Started On Issue");
        this.assertTextNotPresent("Issue Moved");
        this.assertTextNotPresent("Work Stopped On Issue");
        this.assertTextNotPresent("Issue Reopened");
        this.assertTextNotPresent("Issue Closed");
        this.assertTextNotPresent("Issue Created");
        this.assertTextNotPresent("Issue Deleted");
        this.assertTextNotPresent("Issue Commented");
        this.assertTextNotPresent("Work Logged On Issue");
        this.assertTextNotPresent("Issue Updated");
        this.assertTextPresent("Notification Scheme Equal A");
        this.assertTextPresent("Notification Scheme Equal B");
        this.assertTextPresent("have no differences");
    }

    public void testUnableToSelectMoreThan5Schemes() {
        this.gotoPage("secure/admin/SchemeComparisonPicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
        this.navigation.checkWebSudoWithLastPassword();
        this.selectMultiOptionByValue("selectedSchemeIds", "10021");
        this.selectMultiOptionByValue("selectedSchemeIds", "10022");
        this.selectMultiOptionByValue("selectedSchemeIds", "10023");
        this.selectMultiOptionByValue("selectedSchemeIds", "10024");
        this.selectMultiOptionByValue("selectedSchemeIds", "10010");
        this.selectMultiOptionByValue("selectedSchemeIds", "10000");
        this.submit("Compare Schemes");
        this.assertTextPresent("Can not perform a comparison on more than 5 schemes.");
    }

    public void testMustSelectMoreThan1Scheme() {
        this.gotoPage("secure/admin/SchemeComparisonPicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
        this.navigation.checkWebSudoWithLastPassword();
        this.selectMultiOptionByValue("selectedSchemeIds", "10021");
        this.submit("Compare Schemes");
        this.assertTextPresent("At least 2 schemes must be selected for comparison.");
    }

    public void testPermissionSchemesWithSomeDifference() throws SAXException {
        this.gotoPage("secure/admin/SchemeComparisonPicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=PermissionScheme");
        this.navigation.checkWebSudoWithLastPassword();
        this.selectMultiOptionByValue("selectedSchemeIds", "0");
        this.selectMultiOptionByValue("selectedSchemeIds", "10020");
        this.submit("Compare Schemes");
        this.assertTextPresent("Scheme Difference: <span class=\"redText\">&nbsp;8%&nbsp;</span>");
        this.assertTextPresent("Administer Projects");
        this.assertTextNotPresent("Add Comments");
        this.assertTextNotPresent("Create Attachments");
        this.assertTextNotPresent("Set Issue Security");
        this.assertTextNotPresent("Create Issues");
        this.assertTextNotPresent("Browse Projects");
        this.assertTextNotPresent("Edit Issues");
        this.assertTextNotPresent("Schedule Issues");
        this.assertTextNotPresent("Move Issues");
        this.assertTextNotPresent("Assign Issues");
        this.assertTextNotPresent("Assignable User");
        this.assertTextNotPresent("Resolve Issues");
        this.assertTextNotPresent("Close Issues");
        this.assertTextNotPresent("Modify Reporter");
        this.assertTextNotPresent("Delete Issues");
        this.assertTextNotPresent("Work On Issues");
        this.assertTextNotPresent("Link Issues");
        this.assertTextNotPresent("View Version Control");
        this.assertTextNotPresent("View Voters and Watchers");
        this.assertTextNotPresent(MANAGE_WATCHERS);
        this.assertTextPresent("Default Permission Scheme");
        this.assertTextPresent("Permission Scheme To Compare");
        WebTable projectRolesTable = this.getDialog().getResponse().getTableWithID("scheme_comparison_table");
        TestSchemeComparisonTool.assertTrue((boolean)this.tableCellHasText(projectRolesTable, 1, 0, "Administer Projects"));
        TestSchemeComparisonTool.assertTrue((boolean)this.tableCellHasText(projectRolesTable, 1, 1, "Group (jira-administrators)"));
        TestSchemeComparisonTool.assertFalse((boolean)this.tableCellHasText(projectRolesTable, 1, 1, "Project Role (Administrators) "));
        TestSchemeComparisonTool.assertFalse((boolean)this.tableCellHasText(projectRolesTable, 1, 1, "Single User (fred)"));
        TestSchemeComparisonTool.assertTrue((boolean)this.tableCellHasText(projectRolesTable, 1, 2, "Group (jira-administrators)"));
        TestSchemeComparisonTool.assertTrue((boolean)this.tableCellHasText(projectRolesTable, 1, 2, "Project Role (Administrators)"));
        TestSchemeComparisonTool.assertTrue((boolean)this.tableCellHasText(projectRolesTable, 1, 2, "Single User (fred)"));
    }

    public void testNotificationSchemesAreCompletelyDifferent() {
        this.gotoPage("secure/admin/SchemeComparisonPicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
        this.navigation.checkWebSudoWithLastPassword();
        this.selectMultiOptionByValue("selectedSchemeIds", "10022");
        this.selectMultiOptionByValue("selectedSchemeIds", "10000");
        this.submit("Compare Schemes");
        this.assertTextPresent("If any entries for a notification event do not match");
        this.assertTextPresent("Scheme Difference: <span class=\"redText\">&nbsp;100%&nbsp;</span>");
        this.assertTextPresent("Issue Resolved");
        this.assertTextPresent("Issue Assigned");
        this.assertTextPresent("Work Started On Issue");
        this.assertTextPresent("Issue Moved");
        this.assertTextPresent("Work Stopped On Issue");
        this.assertTextPresent("Issue Reopened");
        this.assertTextPresent("Issue Closed");
        this.assertTextPresent("Issue Created");
        this.assertTextPresent("Issue Deleted");
        this.assertTextPresent("Issue Commented");
        this.assertTextPresent("Work Logged On Issue");
        this.assertTextPresent("Issue Updated");
        this.assertTextPresent("Notification Scheme Unequal B");
        this.assertTextPresent("Notification Scheme Equal A");
    }

    public void testDistilledSchemes() throws SAXException {
        this.gotoPage("secure/admin/SchemeComparisonPicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
        this.navigation.checkWebSudoWithLastPassword();
        this.selectMultiOptionByValue("selectedSchemeIds", "10021");
        this.selectMultiOptionByValue("selectedSchemeIds", "10000");
        this.selectMultiOptionByValue("selectedSchemeIds", "10010");
        this.submit("Compare Schemes");
        this.assertTextPresent("If any entries for a notification event do not match");
        this.assertTextPresent("Scheme Difference: <span class=\"redText\">&nbsp;9%&nbsp;</span>");
        this.assertTextPresent("Issue Resolved");
        this.assertTextPresent("Issue Assigned");
        this.assertTextNotPresent("Work Started On Issue");
        this.assertTextNotPresent("Issue Moved");
        this.assertTextNotPresent("Work Stopped On Issue");
        this.assertTextNotPresent("Issue Reopened");
        this.assertTextNotPresent("Issue Closed");
        this.assertTextNotPresent("Issue Created");
        this.assertTextNotPresent("Issue Deleted");
        this.assertTextNotPresent("Issue Commented");
        this.assertTextNotPresent("Work Logged On Issue");
        this.assertTextNotPresent("Issue Updated");
        this.assertTextNotPresent("Issue Worklog Updated");
        this.assertTextNotPresent("Issue Worklog Deleted");
        WebTable projectRolesTable = this.getDialog().getResponse().getTableWithID("scheme_comparison_table");
        TestSchemeComparisonTool.assertTrue((boolean)this.tableCellHasText(projectRolesTable, 0, 1, "Matching Schemes"));
        TestSchemeComparisonTool.assertTrue((boolean)this.tableCellHasText(projectRolesTable, 0, 1, "Notification Scheme Equal A"));
        TestSchemeComparisonTool.assertTrue((boolean)this.tableCellHasText(projectRolesTable, 0, 1, "Notification Scheme Equal B"));
        TestSchemeComparisonTool.assertTrue((boolean)this.tableCellHasText(projectRolesTable, 0, 2, "Notification Scheme Unequal A"));
    }

    public void testLinkToMergeTool() {
        this.gotoPage("secure/admin/SchemeComparisonPicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
        this.navigation.checkWebSudoWithLastPassword();
        this.selectMultiOptionByValue("selectedSchemeIds", "10021");
        this.selectMultiOptionByValue("selectedSchemeIds", "10000");
        this.submit("Compare Schemes");
        this.assertTextPresent("merge duplicate schemes tool");
        this.clickLinkWithText("merge duplicate schemes tool");
        this.assertTextPresent("Choose Schemes to Merge");
        this.assertTextPresent("Notification Scheme Equal A");
        this.assertTextPresent("Notification Scheme Equal B");
    }

    public void testLinkToMergeToolWithDifferentSchemes() {
        this.gotoPage("secure/admin/SchemeComparisonPicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
        this.navigation.checkWebSudoWithLastPassword();
        this.selectMultiOptionByValue("selectedSchemeIds", "10021");
        this.selectMultiOptionByValue("selectedSchemeIds", "10000");
        this.submit("Compare Schemes");
        this.assertTextPresent("merge duplicate schemes tool");
        this.clickLinkWithText("merge duplicate schemes tool");
        this.assertTextPresent("Choose Schemes to Merge");
        this.assertTextPresent("Notification Scheme Equal A");
        this.assertTextPresent("Notification Scheme Equal B");
        this.gotoPage("secure/admin/SchemeComparisonPicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
        this.navigation.checkWebSudoWithLastPassword();
        this.selectMultiOptionByValue("selectedSchemeIds", "10024");
        this.selectMultiOptionByValue("selectedSchemeIds", "10010");
        this.submit("Compare Schemes");
        this.assertTextPresent("merge duplicate schemes tool");
        this.clickLinkWithText("merge duplicate schemes tool");
        this.assertTextPresent("Choose Schemes to Merge");
        this.assertTextPresent("Copy of Notification Scheme Unequal A");
        this.assertTextPresent("Notification Scheme Unequal A");
    }
}

