/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.issuetypes;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.table.AndCell;
import com.atlassian.jira.webtests.table.LinkCell;
import com.atlassian.jira.webtests.table.NotCell;
import com.atlassian.jira.webtests.table.TextCell;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

public class TestIssueTypeSchemes
extends JIRAWebTest {
    private static final String DEFAULT_ISSUE_TYPE_SCHEME_NAME = "Default Issue Type Scheme";
    private static final String DEFAULT_ISSUE_TYPE_SCHEME_DESC = "Default issue type scheme is the list of global issue types. All newly created issue types will automatically be added to this scheme.";

    public void testIssueTypeSchemesSelectOrder() throws SAXException {
        this.restoreData("TestIssueTypeSchemes_Order.xml");
        this.tester.clickLink("admin_link");
        this.tester.clickLink("view-project-10000");
        this.tester.clickLink("selectIssueTypeScheme");
        this.tester.checkCheckbox("createType", "chooseScheme");
        WebForm select = this.getDialog().getResponse().getFormWithName("jiraform");
        String[] values = select.getOptionValues("schemeId");
        TestIssueTypeSchemes.assertEquals((String)"10000", (String)values[0]);
        TestIssueTypeSchemes.assertEquals((String)"10010", (String)values[1]);
        TestIssueTypeSchemes.assertEquals((String)"10013", (String)values[2]);
        TestIssueTypeSchemes.assertEquals((String)"10012", (String)values[3]);
        TestIssueTypeSchemes.assertEquals((String)"10011", (String)values[4]);
    }

    public TestIssueTypeSchemes(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestIssueTypeSchemes.xml");
    }

    public void testIssueTypeSchemesView() {
        this.gotoIssueTypeSchemes();
        this.assertCommonIssueTypeSchemesTable();
    }

    public void testIssueTypeSchemeCreate() {
        this._testIssueTypeSchemeCreateValidation();
        this._testIssueTypeSchemeCreate();
    }

    public void testIssueTypeSchemeCopy() {
        this._testIssueTypeSchemeCopyValidation();
        this._testIssueTypeSchemeCopy();
    }

    public void testIssueTypeSchemeEdit() {
        this._testIssueTypeSchemeEditValidation();
    }

    public void testIssueTypeSchemeDelete() {
        this.gotoIssueTypeSchemes();
        this.clickLink("delete_10011");
        this.assertTextPresent("Delete Issue Type Scheme: Associated Issue Type Scheme");
        this.assertTextSequence(new String[]{"You are about to delete the Issue Type Scheme named", "Associated Issue Type Scheme"});
        this.assertTextPresent("There is one project (monkey) currently using this scheme. This project will revert to using the default global issue type scheme.");
        this.submit("Delete");
        try {
            WebTable issueTypeSchemesTable = this.getDialog().getResponse().getTableWithID("issuetypeschemes");
            TestIssueTypeSchemes.assertEquals((int)3, (int)issueTypeSchemesTable.getRowCount());
            this.assertTableRowEquals(issueTypeSchemesTable, 0, new Object[]{"Name", "Description", "Options", "Projects", "Operations"});
            this.assertTableHasMatchingRowFrom(issueTypeSchemesTable, 1, new Object[]{DEFAULT_ISSUE_TYPE_SCHEME_NAME, DEFAULT_ISSUE_TYPE_SCHEME_DESC, new TextCell(new String[]{"Bug", "(Default)", "New Feature", "Task", "Improvement"}), "Global (all unconfigured projects)", new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10000", "Edit"), new LinkCell("AssociateIssueTypeSchemesWithDefault!default.jspa?fieldId=issuetype&schemeId=10000", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10000", "Copy"), new NotCell(new TextCell("Delete")))});
            this.assertTableHasNoMatchingRow(issueTypeSchemesTable, 1, new Object[]{"Associated Issue Type Scheme", "Description for associated issue type scheme", new AndCell(new TextCell(new String[]{"Bug", "Improvement"}), new NotCell(new TextCell("(Default)"))), new LinkCell(this.page.addXsrfToken("ViewProject.jspa?pid=10001"), "monkey"), new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10011", "Edit"), new LinkCell("AssociateIssueTypeSchemes!default.jspa?fieldId=issuetype&schemeId=10011", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10011", "Copy"), new LinkCell("DeleteOptionScheme!default.jspa?fieldId=issuetype&schemeId=10011", "Delete"))});
            this.assertTableHasMatchingRowFrom(issueTypeSchemesTable, 1, new Object[]{"Test Issue Type Scheme", "Description for test issue type scheme", new TextCell(new String[]{"Improvement", "New Feature", "Bug", "(Default)", "Task"}), "No projects", new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10010", "Edit"), new LinkCell("AssociateIssueTypeSchemes!default.jspa?fieldId=issuetype&schemeId=10010", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10010", "Copy"), new LinkCell("DeleteOptionScheme!default.jspa?fieldId=issuetype&schemeId=10010", "Delete"))});
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        this.gotoIssueTypeSchemes();
        this.clickLink("delete_10010");
        this.assertTextPresent("Delete Issue Type Scheme: Test Issue Type Scheme");
        this.assertTextSequence(new String[]{"You are about to delete the Issue Type Scheme named", "Test Issue Type Scheme"});
        this.assertTextPresent("There are no projects currently using this scheme.");
        this.submit("Delete");
        try {
            WebTable issueTypeSchemesTable1 = this.getDialog().getResponse().getTableWithID("issuetypeschemes");
            TestIssueTypeSchemes.assertEquals((int)2, (int)issueTypeSchemesTable1.getRowCount());
            this.assertTableRowEquals(issueTypeSchemesTable1, 0, new Object[]{"Name", "Description", "Options", "Projects", "Operations"});
            this.assertTableHasMatchingRowFrom(issueTypeSchemesTable1, 1, new Object[]{DEFAULT_ISSUE_TYPE_SCHEME_NAME, DEFAULT_ISSUE_TYPE_SCHEME_DESC, new TextCell(new String[]{"Bug", "(Default)", "New Feature", "Task", "Improvement"}), "Global (all unconfigured projects)", new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10000", "Edit"), new LinkCell("AssociateIssueTypeSchemesWithDefault!default.jspa?fieldId=issuetype&schemeId=10000", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10000", "Copy"), new NotCell(new TextCell("Delete")))});
            this.assertTableHasNoMatchingRow(issueTypeSchemesTable1, 1, new Object[]{"Associated Issue Type Scheme", "Description for associated issue type scheme", new AndCell(new TextCell(new String[]{"Bug", "Improvement"}), new NotCell(new TextCell("(Default)"))), new LinkCell(this.page.addXsrfToken("ViewProject.jspa?pid=10001"), "monkey"), new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10011", "Edit"), new LinkCell("AssociateIssueTypeSchemes!default.jspa?fieldId=issuetype&schemeId=10011", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10011", "Copy"), new LinkCell("DeleteOptionScheme!default.jspa?fieldId=issuetype&schemeId=10011", "Delete"))});
            this.assertTableHasNoMatchingRow(issueTypeSchemesTable1, 1, new Object[]{"Test Issue Type Scheme", "Description for test issue type scheme", new TextCell(new String[]{"Improvement", "New Feature", "Bug", "(Default)", "Task"}), "No projects", new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10010", "Edit"), new LinkCell("AssociateIssueTypeSchemes!default.jspa?fieldId=issuetype&schemeId=10010", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10010", "Copy"), new LinkCell("DeleteOptionScheme!default.jspa?fieldId=issuetype&schemeId=10010", "Delete"))});
        }
        catch (SAXException e1) {
            throw new RuntimeException(e1);
        }
    }

    public void testIssueTypeSchemeAssociateDefaultScheme() {
        this.gotoIssueTypeSchemes();
        this.clickLink("associate_10000");
        this.assertTextPresent("Associate Issue Type Scheme");
        this.assertTextPresent("Only projects not currently associated with the default scheme are displayed.");
        this.assertOptionsEqual("projects", new String[]{"monkey"});
        this.selectOption("projects", "monkey");
        this.submit("Associate");
        try {
            WebTable issueTypeSchemesTable1 = this.getDialog().getResponse().getTableWithID("issuetypeschemes");
            TestIssueTypeSchemes.assertEquals((int)4, (int)issueTypeSchemesTable1.getRowCount());
            this.assertTableRowEquals(issueTypeSchemesTable1, 0, new Object[]{"Name", "Description", "Options", "Projects", "Operations"});
            this.assertTableHasMatchingRowFrom(issueTypeSchemesTable1, 1, new Object[]{DEFAULT_ISSUE_TYPE_SCHEME_NAME, DEFAULT_ISSUE_TYPE_SCHEME_DESC, new TextCell(new String[]{"Bug", "(Default)", "New Feature", "Task", "Improvement"}), "Global (all unconfigured projects)", new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10000", "Edit"), new LinkCell("AssociateIssueTypeSchemesWithDefault!default.jspa?fieldId=issuetype&schemeId=10000", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10000", "Copy"), new NotCell(new TextCell("Delete")))});
            this.assertTableHasMatchingRowFrom(issueTypeSchemesTable1, 1, new Object[]{"Associated Issue Type Scheme", "Description for associated issue type scheme", new AndCell(new TextCell(new String[]{"Bug", "Improvement"}), new NotCell(new TextCell("(Default)"))), "No projects", new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10011", "Edit"), new LinkCell("AssociateIssueTypeSchemes!default.jspa?fieldId=issuetype&schemeId=10011", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10011", "Copy"), new LinkCell("DeleteOptionScheme!default.jspa?fieldId=issuetype&schemeId=10011", "Delete"))});
            this.assertTableHasMatchingRowFrom(issueTypeSchemesTable1, 1, new Object[]{"Test Issue Type Scheme", "Description for test issue type scheme", new TextCell(new String[]{"Improvement", "New Feature", "Bug", "(Default)", "Task"}), "No projects", new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10010", "Edit"), new LinkCell("AssociateIssueTypeSchemes!default.jspa?fieldId=issuetype&schemeId=10010", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10010", "Copy"), new LinkCell("DeleteOptionScheme!default.jspa?fieldId=issuetype&schemeId=10010", "Delete"))});
        }
        catch (SAXException e1) {
            throw new RuntimeException(e1);
        }
        this.clickLink("associate_10000");
        this.assertTextPresent("Associate Issue Type Scheme");
        this.assertTextSequence(new String[]{"No projects available to be associated with scheme", DEFAULT_ISSUE_TYPE_SCHEME_NAME});
        this.assertFormElementNotPresent("projects");
        this.assertSubmitButtonNotPresent("Associate");
    }

    public void testIssueTypeSchemeAssociateSchemeWithProjectAssociation() {
        this.gotoIssueTypeSchemes();
        this.clickLink("associate_10011");
        this.assertTextPresent("Associate Issue Type Scheme");
        this.assertOptionsEqual("projects", new String[]{"homosapien", "monkey"});
        this.assertOptionSelected("projects", "monkey");
        this.selectMultiOption("projects", "monkey");
        this.selectMultiOption("projects", "homosapien");
        this.submit("Associate");
        try {
            WebTable issueTypeSchemesTable = this.getDialog().getResponse().getTableWithID("issuetypeschemes");
            TestIssueTypeSchemes.assertEquals((int)4, (int)issueTypeSchemesTable.getRowCount());
            this.assertTableRowEquals(issueTypeSchemesTable, 0, new Object[]{"Name", "Description", "Options", "Projects", "Operations"});
            this.assertTableHasMatchingRowFrom(issueTypeSchemesTable, 1, new Object[]{DEFAULT_ISSUE_TYPE_SCHEME_NAME, DEFAULT_ISSUE_TYPE_SCHEME_DESC, new TextCell(new String[]{"Bug", "(Default)", "New Feature", "Task", "Improvement"}), "Global (all unconfigured projects)", new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10000", "Edit"), new LinkCell("AssociateIssueTypeSchemesWithDefault!default.jspa?fieldId=issuetype&schemeId=10000", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10000", "Copy"), new NotCell(new TextCell("Delete")))});
            this.assertTableHasMatchingRowFrom(issueTypeSchemesTable, 1, new Object[]{"Associated Issue Type Scheme", "Description for associated issue type scheme", new AndCell(new TextCell(new String[]{"Bug", "Improvement"}), new NotCell(new TextCell("(Default)"))), new AndCell(new LinkCell(this.page.addXsrfToken("ViewProject.jspa?pid=10001"), "monkey"), new LinkCell(this.page.addXsrfToken("ViewProject.jspa?pid=10000"), "homosapien")), new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10011", "Edit"), new LinkCell("AssociateIssueTypeSchemes!default.jspa?fieldId=issuetype&schemeId=10011", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10011", "Copy"), new LinkCell("DeleteOptionScheme!default.jspa?fieldId=issuetype&schemeId=10011", "Delete"))});
            this.assertTableHasMatchingRowFrom(issueTypeSchemesTable, 1, new Object[]{"Test Issue Type Scheme", "Description for test issue type scheme", new TextCell(new String[]{"Improvement", "New Feature", "Bug", "(Default)", "Task"}), "No projects", new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10010", "Edit"), new LinkCell("AssociateIssueTypeSchemes!default.jspa?fieldId=issuetype&schemeId=10010", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10010", "Copy"), new LinkCell("DeleteOptionScheme!default.jspa?fieldId=issuetype&schemeId=10010", "Delete"))});
        }
        catch (SAXException e1) {
            throw new RuntimeException(e1);
        }
        this.clickLink("associate_10011");
        this.assertTextPresent("Associate Issue Type Scheme");
        this.assertOptionsEqual("projects", new String[]{"homosapien", "monkey"});
        this.assertOptionSelected("projects", "monkey");
        this.assertOptionSelected("projects", "homosapien");
        this.selectOption("projects", "homosapien");
        this.submit("Associate");
        try {
            WebTable issueTypeSchemesTable1 = this.getDialog().getResponse().getTableWithID("issuetypeschemes");
            TestIssueTypeSchemes.assertEquals((int)4, (int)issueTypeSchemesTable1.getRowCount());
            this.assertTableRowEquals(issueTypeSchemesTable1, 0, new Object[]{"Name", "Description", "Options", "Projects", "Operations"});
            this.assertTableHasMatchingRowFrom(issueTypeSchemesTable1, 1, new Object[]{DEFAULT_ISSUE_TYPE_SCHEME_NAME, DEFAULT_ISSUE_TYPE_SCHEME_DESC, new TextCell(new String[]{"Bug", "(Default)", "New Feature", "Task", "Improvement"}), "Global (all unconfigured projects)", new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10000", "Edit"), new LinkCell("AssociateIssueTypeSchemesWithDefault!default.jspa?fieldId=issuetype&schemeId=10000", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10000", "Copy"), new NotCell(new TextCell("Delete")))});
            this.assertTableHasMatchingRowFrom(issueTypeSchemesTable1, 1, new Object[]{"Associated Issue Type Scheme", "Description for associated issue type scheme", new AndCell(new TextCell(new String[]{"Bug", "Improvement"}), new NotCell(new TextCell("(Default)"))), new LinkCell(this.page.addXsrfToken("ViewProject.jspa?pid=10000"), "homosapien"), new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10011", "Edit"), new LinkCell("AssociateIssueTypeSchemes!default.jspa?fieldId=issuetype&schemeId=10011", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10011", "Copy"), new LinkCell("DeleteOptionScheme!default.jspa?fieldId=issuetype&schemeId=10011", "Delete"))});
            this.assertTableHasMatchingRowFrom(issueTypeSchemesTable1, 1, new Object[]{"Test Issue Type Scheme", "Description for test issue type scheme", new TextCell(new String[]{"Improvement", "New Feature", "Bug", "(Default)", "Task"}), "No projects", new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10010", "Edit"), new LinkCell("AssociateIssueTypeSchemes!default.jspa?fieldId=issuetype&schemeId=10010", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10010", "Copy"), new LinkCell("DeleteOptionScheme!default.jspa?fieldId=issuetype&schemeId=10010", "Delete"))});
        }
        catch (SAXException e1) {
            throw new RuntimeException(e1);
        }
    }

    public void testIssueTypeSchemeAssociateSchemeWithNoProjectAssociation() {
        this.gotoIssueTypeSchemes();
        this.clickLink("associate_10010");
        this.assertTextPresent("Associate Issue Type Scheme");
        this.assertOptionsEqual("projects", new String[]{"homosapien", "monkey"});
        this.selectMultiOption("projects", "monkey");
        this.submit("Associate");
        try {
            WebTable issueTypeSchemesTable1 = this.getDialog().getResponse().getTableWithID("issuetypeschemes");
            TestIssueTypeSchemes.assertEquals((int)4, (int)issueTypeSchemesTable1.getRowCount());
            this.assertTableRowEquals(issueTypeSchemesTable1, 0, new Object[]{"Name", "Description", "Options", "Projects", "Operations"});
            this.assertTableHasMatchingRowFrom(issueTypeSchemesTable1, 1, new Object[]{DEFAULT_ISSUE_TYPE_SCHEME_NAME, DEFAULT_ISSUE_TYPE_SCHEME_DESC, new TextCell(new String[]{"Bug", "(Default)", "New Feature", "Task", "Improvement"}), "Global (all unconfigured projects)", new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10000", "Edit"), new LinkCell("AssociateIssueTypeSchemesWithDefault!default.jspa?fieldId=issuetype&schemeId=10000", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10000", "Copy"), new NotCell(new TextCell("Delete")))});
            this.assertTableHasMatchingRowFrom(issueTypeSchemesTable1, 1, new Object[]{"Associated Issue Type Scheme", "Description for associated issue type scheme", new AndCell(new TextCell(new String[]{"Bug", "Improvement"}), new NotCell(new TextCell("(Default)"))), "No projects", new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10011", "Edit"), new LinkCell("AssociateIssueTypeSchemes!default.jspa?fieldId=issuetype&schemeId=10011", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10011", "Copy"), new LinkCell("DeleteOptionScheme!default.jspa?fieldId=issuetype&schemeId=10011", "Delete"))});
            this.assertTableHasMatchingRowFrom(issueTypeSchemesTable1, 1, new Object[]{"Test Issue Type Scheme", "Description for test issue type scheme", new TextCell(new String[]{"Improvement", "New Feature", "Bug", "(Default)", "Task"}), new LinkCell(this.page.addXsrfToken("ViewProject.jspa?pid=10001"), "monkey"), new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10010", "Edit"), new LinkCell("AssociateIssueTypeSchemes!default.jspa?fieldId=issuetype&schemeId=10010", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10010", "Copy"), new LinkCell("DeleteOptionScheme!default.jspa?fieldId=issuetype&schemeId=10010", "Delete"))});
        }
        catch (SAXException e1) {
            throw new RuntimeException(e1);
        }
    }

    private void _testIssueTypeSchemeCreateValidation() {
        this.gotoIssueTypeSchemes();
        this.submit("Add");
        this.assertFormElementHasValue("name", "");
        this.assertFormElementHasValue("description", "");
        this.assertIssueTypeSchemeFormValidation();
    }

    private void _testIssueTypeSchemeCreate() {
        this.gotoIssueTypeSchemes();
        this.setFormElement("name", "testIssueTypeSchemeCreate scheme");
        this.setFormElement("description", "description for testIssueTypeSchemeCreate scheme");
        this.submit("Add");
        this.assertFormElementHasValue("name", "testIssueTypeSchemeCreate scheme");
        this.assertFormElementHasValue("description", "description for testIssueTypeSchemeCreate scheme");
    }

    private void _testIssueTypeSchemeCopyValidation() {
        this.gotoIssueTypeSchemes();
        this.clickLink("copy_10000");
        this.assertFormElementHasValue("name", "Copy of Default Issue Type Scheme");
        this.assertFormElementHasValue("description", DEFAULT_ISSUE_TYPE_SCHEME_DESC);
        this.assertIssueTypeSchemeFormValidation();
        this.gotoIssueTypeSchemes();
        this.clickLink("copy_10010");
        this.assertFormElementHasValue("name", "Copy of Test Issue Type Scheme");
        this.assertFormElementHasValue("description", "Description for test issue type scheme");
        this.assertIssueTypeSchemeFormValidation();
        this.gotoIssueTypeSchemes();
        this.clickLink("copy_10011");
        this.assertFormElementHasValue("name", "Copy of Associated Issue Type Scheme");
        this.assertFormElementHasValue("description", "Description for associated issue type scheme");
        this.assertIssueTypeSchemeFormValidation();
    }

    private void _testIssueTypeSchemeCopy() {
        this.gotoIssueTypeSchemes();
        this.assertCommonIssueTypeSchemesTable(4);
        this.clickLink("copy_10000");
        this.assertTextPresent("Add Issue Types Scheme");
        this.assertFormElementHasValue("name", "Copy of Default Issue Type Scheme");
        this.assertFormElementHasValue("description", DEFAULT_ISSUE_TYPE_SCHEME_DESC);
        this.gotoIssueTypeSchemes();
        this.clickLink("copy_10010");
        this.assertTextPresent("Add Issue Types Scheme");
        this.assertFormElementHasValue("name", "Copy of Test Issue Type Scheme");
        this.assertFormElementHasValue("description", "Description for test issue type scheme");
        this.gotoIssueTypeSchemes();
        this.clickLink("copy_10011");
        this.assertTextPresent("Add Issue Types Scheme");
        this.assertFormElementHasValue("name", "Copy of Associated Issue Type Scheme");
        this.assertFormElementHasValue("description", "Description for associated issue type scheme");
    }

    private void _testIssueTypeSchemeEditValidation() {
        this.gotoIssueTypeSchemes();
        this.clickLink("edit_10000");
        this.assertFormElementHasValue("name", DEFAULT_ISSUE_TYPE_SCHEME_NAME);
        this.assertFormElementHasValue("description", DEFAULT_ISSUE_TYPE_SCHEME_DESC);
        this.assertIssueTypeSchemeFormValidation();
        this.gotoIssueTypeSchemes();
        this.clickLink("edit_10010");
        this.assertFormElementHasValue("name", "Test Issue Type Scheme");
        this.assertFormElementHasValue("description", "Description for test issue type scheme");
        this.assertIssueTypeSchemeFormValidation();
        this.gotoIssueTypeSchemes();
        this.clickLink("edit_10011");
        this.assertFormElementHasValue("name", "Associated Issue Type Scheme");
        this.assertFormElementHasValue("description", "Description for associated issue type scheme");
        this.assertIssueTypeSchemeFormValidation();
    }

    public void gotoIssueTypeSchemes() {
        this.gotoAdmin();
        this.clickLink("issue_types");
        this.clickLinkWithText("Issue Types Scheme");
    }

    public void assertCommonIssueTypeSchemesTable() {
        this.assertCommonIssueTypeSchemesTable(4);
    }

    public void assertCommonIssueTypeSchemesTable(int numberOfRows) {
        try {
            WebTable issueTypeSchemesTable = this.getDialog().getResponse().getTableWithID("issuetypeschemes");
            TestIssueTypeSchemes.assertEquals((int)numberOfRows, (int)issueTypeSchemesTable.getRowCount());
            this.assertTableRowEquals(issueTypeSchemesTable, 0, new Object[]{"Name", "Description", "Options", "Projects", "Operations"});
            this.assertTableHasMatchingRowFrom(issueTypeSchemesTable, 1, new Object[]{DEFAULT_ISSUE_TYPE_SCHEME_NAME, DEFAULT_ISSUE_TYPE_SCHEME_DESC, new TextCell(new String[]{"Bug", "(Default)", "New Feature", "Task", "Improvement"}), "Global (all unconfigured projects)", new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10000", "Edit"), new LinkCell("AssociateIssueTypeSchemesWithDefault!default.jspa?fieldId=issuetype&schemeId=10000", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10000", "Copy"), new NotCell(new TextCell("Delete")))});
            this.assertTableHasMatchingRowFrom(issueTypeSchemesTable, 1, new Object[]{"Test Issue Type Scheme", "Description for test issue type scheme", new TextCell(new String[]{"Improvement", "New Feature", "Bug", "(Default)", "Task"}), "No projects", new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10010", "Edit"), new LinkCell("AssociateIssueTypeSchemes!default.jspa?fieldId=issuetype&schemeId=10010", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10010", "Copy"), new LinkCell("DeleteOptionScheme!default.jspa?fieldId=issuetype&schemeId=10010", "Delete"))});
            this.assertTableHasMatchingRowFrom(issueTypeSchemesTable, 1, new Object[]{"Associated Issue Type Scheme", "Description for associated issue type scheme", new AndCell(new TextCell(new String[]{"Bug", "Improvement"}), new NotCell(new TextCell("(Default)"))), new LinkCell(this.page.addXsrfToken("ViewProject.jspa?pid=10001"), "monkey"), new AndCell(new LinkCell("ConfigureOptionSchemes!default.jspa?fieldId=issuetype&schemeId=10011", "Edit"), new LinkCell("AssociateIssueTypeSchemes!default.jspa?fieldId=issuetype&schemeId=10011", "Associate"), new LinkCell("ConfigureOptionSchemes!copy.jspa?fieldId=issuetype&schemeId=10011", "Copy"), new LinkCell("DeleteOptionScheme!default.jspa?fieldId=issuetype&schemeId=10011", "Delete"))});
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void assertIssueTypeSchemeFormValidation() {
        this.assertTextNotPresent("You must select at least one option");
        this.assertTextNotPresent("You must enter a valid name.");
        this.setFormElement("name", "");
        this.setFormElement("description", "");
        this.submit("Save");
        this.assertTextPresent("You must select at least one option");
        this.assertTextPresent("You must enter a valid name.");
        this.setFormElement("name", "test name");
        this.submit("Save");
        this.assertTextPresent("You must select at least one option");
        this.assertTextNotPresent("You must enter a valid name.");
    }
}

