/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.XPathLocator;

public class TestTimeTrackingAdmin
extends FuncTestCase {
    @Override
    public void setUpTest() {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdmin();
        this.administration.plugins().enablePlugin("com.atlassian.jira.plugin.system.issueoperations");
        this.administration.plugins().enablePluginModule("com.atlassian.jira.plugin.system.issueoperations", "com.atlassian.jira.plugin.system.issueoperations:log-work");
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
    }

    public void testIssueOperationsPluginDisabled() {
        this.navigation.gotoAdminSection("timetracking");
        this.tester.assertTextNotPresent("The Issue Operations plugin is currently disabled, and thus users will not be able to log work done against any issues.");
        this.administration.timeTracking().disable();
        this.tester.assertTextNotPresent("The Issue Operations plugin is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the plugin before activating Time Tracking.");
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.administration.plugins().disablePlugin("com.atlassian.jira.plugin.system.issueoperations");
        this.navigation.gotoAdminSection("timetracking");
        this.tester.assertTextPresent("The Issue Operations plugin is currently disabled, and thus users will not be able to log work done against any issues.");
        this.administration.timeTracking().disable();
        this.tester.assertTextPresent("The Issue Operations plugin is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the plugin before activating Time Tracking.");
    }

    public void testLogWorkModuleDisabled() {
        this.navigation.gotoAdminSection("timetracking");
        this.tester.assertTextNotPresent("The Log Work module is currently disabled, and thus users will not be able to log work done against any issues.");
        this.administration.timeTracking().disable();
        this.tester.assertTextNotPresent("The Log Work module is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the module before activating Time Tracking.");
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.administration.plugins().disablePluginModule("com.atlassian.jira.plugin.system.issueoperations", "com.atlassian.jira.plugin.system.issueoperations:log-work");
        this.navigation.gotoAdminSection("timetracking");
        this.tester.assertTextPresent("The Log Work module is currently disabled, and thus users will not be able to log work done against any issues.");
        this.administration.timeTracking().disable();
        this.tester.assertTextPresent("The Log Work module is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the module before activating Time Tracking.");
    }

    public void testIssueOperationsPluginDisabledAndLogWorkModuleDisabled() {
        this.navigation.gotoAdminSection("timetracking");
        this.tester.assertTextNotPresent("The Issue Operations plugin is currently disabled, and thus users will not be able to log work done against any issues.");
        this.tester.assertTextNotPresent("The Log Work module is currently disabled, and thus users will not be able to log work done against any issues.");
        this.administration.timeTracking().disable();
        this.tester.assertTextNotPresent("The Issue Operations plugin is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the plugin before activating Time Tracking.");
        this.tester.assertTextNotPresent("The Log Work module is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the module before activating Time Tracking.");
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.administration.plugins().disablePluginModule("com.atlassian.jira.plugin.system.issueoperations", "com.atlassian.jira.plugin.system.issueoperations:log-work");
        this.administration.plugins().disablePlugin("com.atlassian.jira.plugin.system.issueoperations");
        this.navigation.gotoAdminSection("timetracking");
        this.tester.assertTextPresent("The Issue Operations plugin is currently disabled, and thus users will not be able to log work done against any issues.");
        this.tester.assertTextNotPresent("The Log Work module is currently disabled, and thus users will not be able to log work done against any issues.");
        this.administration.timeTracking().disable();
        this.tester.assertTextPresent("The Issue Operations plugin is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the plugin before activating Time Tracking.");
        this.tester.assertTextNotPresent("The Log Work module is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the module before activating Time Tracking.");
    }

    public void testValidation() throws Exception {
        this.administration.timeTracking().disable();
        this.enableWithErrors("0", "7", "The number must be greater than 0.");
        this.enableWithErrors("-5", "7", "The number must be greater than 0.");
        this.enableWithErrors("5", "0", "The number must be greater than 0.");
        this.enableWithErrors("5", "-7", "The number must be greater than 0.");
        this.enableWithErrors("badtext", "7", "The specified value is not a number.");
        this.enableWithErrors("25.5.5", "7", "The specified value is not a number.");
        this.enableWithErrors("8", "badtext", "The specified value is not a number.");
        this.enableWithErrors("8", "25.5.5", "The specified value is not a number.");
        this.enableWithErrors("8.253", "7", "A maximum of two decimal points of accuracy is permitted.");
        this.enableWithErrors("8", "7.5423", "A maximum of two decimal points of accuracy is permitted.");
    }

    private void enableWithErrors(String hoursPerDay, String daysPerWeek, String error) {
        this.tester.gotoPage("/secure/admin/jira/TimeTrackingAdmin!default.jspa");
        this.navigation.checkWebSudoWithLastPassword();
        TestTimeTrackingAdmin.assertTrue((boolean)this.tester.getDialog().hasSubmitButton("Activate"));
        this.tester.setFormElement("hoursPerDay", hoursPerDay);
        this.tester.setFormElement("daysPerWeek", daysPerWeek);
        this.tester.checkCheckbox("timeTrackingFormat", "pretty");
        this.tester.selectOption("defaultUnit", "hour");
        this.tester.submit("Activate");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//td[@class='jiraformheader']"), "Time Tracking is currently OFF.");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//span[@class='errMsg']"), error);
    }

    private static class ErrorMessages {
        private static final String ISSUE_OPS_DISABLED_ACTIVE = "The Issue Operations plugin is currently disabled, and thus users will not be able to log work done against any issues.";
        private static final String ISSUE_OPS_DISABLED_INACTIVE = "The Issue Operations plugin is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the plugin before activating Time Tracking.";
        private static final String LOG_WORK_DISABLED_ACTIVE = "The Log Work module is currently disabled, and thus users will not be able to log work done against any issues.";
        private static final String LOG_WORK_DISABLED_INACTIVE = "The Log Work module is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the module before activating Time Tracking.";

        private ErrorMessages() {
        }
    }
}

