/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

public class TestPermissionSchemes
extends JIRAWebTest {
    private static final String MOVE_TABLE_ID = "move_confirm_table";
    private static final int MOVE_TABLE_FIELD_NAME_COLUMN_INDEX = 0;
    private static final int MOVE_TABLE_OLD_VALUE_COLUMN_INDEX = 1;
    private static final int MOVE_TABLE_NEW_VALUE_COLUMN_INDEX = 2;

    public TestPermissionSchemes(String name) {
        super(name);
    }

    public void testPermissionSchemes() {
        this.restoreBlankInstance();
        if (this.projectExists("homosapien")) {
            TestPermissionSchemes.log("Project 'homosapien' exists");
        } else {
            this.addProject("homosapien", "HSP", "", "admin", "Project for homosapiens");
        }
        if (this.projectExists("neanderthal")) {
            TestPermissionSchemes.log("Project 'neanderthal' exists");
        } else {
            this.addProject("neanderthal", "NDT", "", "admin", "Project for neanderthals");
        }
        if (this.projectExists("monkey")) {
            TestPermissionSchemes.log("Project 'monkey' exists");
        } else {
            this.addProject("monkey", "MKY", "", "admin", "Project for monkeys");
        }
        if (this.permissionSchemeExists("New Permission Scheme")) {
            this.deletePermissionScheme("New Permission Scheme");
        }
        this.resetFields();
        this.deleteAllIssuesInAllPages();
        String issueKeyNormal = this.addIssue("homosapien", "HSP", "Bug", "test 1", "Minor", null, null, null, "Administrator", "test environment 1", "test description for permission schemes", null, null, null);
        this.permissionSchemesCreateScheme();
        this.permissionSchemeAssociateScheme();
        this.permissionSchemeAddDuplicateScheme();
        this.permissionSchemeAddInvalidScheme();
        this.permissionSchemesMoveIssueToProjectWithAssignablePermission(issueKeyNormal);
        this.permissionSchemesMoveIssueToProjectWithAssignPermission();
        this.permissionSchemesMoveIssueWithSchedulePermission(issueKeyNormal);
        this.permissionSchemesMoveIssueToProjectWithCreatePermission(issueKeyNormal);
        this.permissionSchemeDeleteScheme();
        this.deleteIssue(issueKeyNormal);
    }

    public void testProjectRolePermissionScheme() {
        TestPermissionSchemes.logSection("Test to check that project role permission scheme works");
        this.restoreData("TestSchemesProjectRoles.xml");
        this.gotoPermissionSchemes();
        this.clickLinkWithText("Default Permission Scheme");
        this.assertTextPresent("Edit Permissions &mdash; Default Permission Scheme");
        this.clickLink("add_perm_25");
        this.assertTextPresent("Choose a project role");
        this.checkCheckbox("type", "projectrole");
        this.selectOption("projectrole", "test role");
        this.submit();
        this.assertTextPresent("(test role)");
    }

    public void permissionSchemesCreateScheme() {
        TestPermissionSchemes.log("Permission Schemes: Create a new permission scheme");
        this.createPermissionScheme("New Permission Scheme", "permission scheme for testing");
        this.assertLinkPresentWithText("New Permission Scheme");
        this.assertTextPresent("permission scheme for testing");
    }

    public void permissionSchemeDeleteScheme() {
        TestPermissionSchemes.log("Permission Schemes:Delete a permission scheme");
        this.deletePermissionScheme("New Permission Scheme");
        this.assertLinkNotPresentWithText("New Permission Scheme");
    }

    public void permissionSchemeAssociateScheme() {
        TestPermissionSchemes.log("Permission Schemes: Associate a permission scheme with a project");
        this.associatePermSchemeToProject("neanderthal", "New Permission Scheme");
        this.goToProject("neanderthal");
        this.assertTextPresent("New Permission Scheme");
        this.associatePermSchemeToProject("neanderthal", "Default Permission Scheme");
    }

    public void permissionSchemeAddDuplicateScheme() {
        TestPermissionSchemes.log("Permission Schemes: Attempt to create a scheme with a duplicate name");
        this.createPermissionScheme("New Permission Scheme", "");
        this.assertTextPresent("Add Permission Scheme");
        this.assertTextPresent("A Scheme with this name already exists.");
    }

    public void permissionSchemeAddInvalidScheme() {
        TestPermissionSchemes.log("Permission Schemes: Attempt to create a scheme with an invalid name");
        this.createPermissionScheme("", "");
        this.assertTextPresent("Add Permission Scheme");
        this.assertTextPresent("Please specify a name for this Scheme.");
    }

    private void permissionSchemesMoveIssueToProjectWithAssignablePermission(String issueKey) {
        TestPermissionSchemes.log("Move Operation: Moving issue to a project with 'Assign Issue' Permission.");
        this.associatePermSchemeToProject("neanderthal", "New Permission Scheme");
        this.setUnassignedIssuesOption(true);
        this.grantGroupPermission("New Permission Scheme", 11, "jira-users");
        this.grantGroupPermission("New Permission Scheme", 17, "jira-developers");
        this.gotoIssue(issueKey);
        this.clickLink("move-issue");
        this.selectOption("pid", "neanderthal");
        this.submit();
        this.assertTextPresent("Step 3 of 4");
        this.assertTextNotPresent("The default assignee does NOT have ASSIGNABLE permission OR Unassigned issues are turned off.");
        this.removeGroupPermission("New Permission Scheme", 17, "jira-developers");
        this.gotoIssue(issueKey);
        this.clickLink("move-issue");
        this.selectOption("pid", "neanderthal");
        this.submit();
        this.assertTextPresent("Step 3 of 4");
        this.setWorkingForm("jiraform");
        this.submit();
        this.assertTextPresent("The default assignee does NOT have ASSIGNABLE permission OR Unassigned issues are turned off.");
        this.setUnassignedIssuesOption(false);
        this.gotoIssue(issueKey);
        this.clickLink("move-issue");
        this.selectOption("pid", "neanderthal");
        this.submit();
        this.assertTextPresent("Step 3 of 4");
        this.assertTextNotPresent("The default assignee does NOT have ASSIGNABLE permission OR Unassigned issues are turned off.");
        this.removeGroupPermission("New Permission Scheme", 11, "jira-users");
        this.associatePermSchemeToProject("neanderthal", "Default Permission Scheme");
    }

    public void permissionSchemesMoveIssueToProjectWithAssignPermission() {
        TestPermissionSchemes.log("Move Operation: Test that assignee is autoassigned if assignee does not have assign permission");
        this.associatePermSchemeToProject("neanderthal", "New Permission Scheme");
        this.grantGroupPermission("New Permission Scheme", 11, "jira-users");
        this.grantGroupPermission("New Permission Scheme", 13, "jira-administrators");
        this.grantGroupPermission("New Permission Scheme", 17, "jira-users");
        this.grantGroupPermission("New Permission Scheme", 10, "jira-users");
        this.grantGroupPermission("New Permission Scheme", 25, "jira-users");
        this.addUser("bob", "bob_password", "Bob The Builder", "bob@stuff.com.com");
        String issueKey = this.addIssue("neanderthal", "NDT", "Bug", "test 1", "Minor", null, null, null, "Bob The Builder", "Original Assignee - Bob\n New Assignee - Administrator", "This issue should be moved and auto-assigned to Administrator", null, null, null);
        this.removeGroupPermission(13, "jira-developers");
        this.gotoIssue(issueKey);
        this.clickLink("move-issue");
        this.selectOption("pid", "homosapien");
        this.submit();
        this.assertTextPresent("Step 3 of 4");
        this.setWorkingForm("jiraform");
        this.submit();
        try {
            WebTable fieldTable = this.getDialog().getResponse().getTableWithID(MOVE_TABLE_ID);
            for (int i = 1; i < fieldTable.getRowCount(); ++i) {
                String field = fieldTable.getCellAsText(i, 0);
                if (field.indexOf("Assignee") <= -1) continue;
                String oldValue = fieldTable.getCellAsText(i, 1);
                String newValue = fieldTable.getCellAsText(i, 2);
                TestPermissionSchemes.assertTrue((oldValue.indexOf("Bob The Builder") > -1 ? 1 : 0) != 0);
                TestPermissionSchemes.assertTrue((newValue.indexOf("Administrator") > -1 ? 1 : 0) != 0);
                this.grantGroupPermission(13, "jira-developers");
                this.removeGroupPermission("New Permission Scheme", 11, "jira-users");
                this.removeGroupPermission("New Permission Scheme", 13, "jira-administrators");
                this.removeGroupPermission("New Permission Scheme", 17, "jira-users");
                this.removeGroupPermission("New Permission Scheme", 10, "jira-users");
                this.removeGroupPermission("New Permission Scheme", 25, "jira-users");
                this.associatePermSchemeToProject("neanderthal", "Default Permission Scheme");
                this.deleteIssue(issueKey);
                this.deleteUser("bob");
                return;
            }
            TestPermissionSchemes.fail((String)"Cannot find field chamge for 'Assignee'");
        }
        catch (SAXException e) {
            TestPermissionSchemes.fail((String)"Cannot find table with id 'move_confirm_table'.");
            e.printStackTrace();
        }
    }

    public void permissionSchemesMoveIssueWithSchedulePermission(String issueKey) {
        TestPermissionSchemes.log("Move Operation: Moving issue to a project with 'Schedule Issue' Permission.");
        this.associatePermSchemeToProject("neanderthal", "New Permission Scheme");
        this.removeGroupPermission("New Permission Scheme", 28, "jira-developers");
        this.grantGroupPermission("New Permission Scheme", 11, "jira-users");
        this.setDueDateToRequried();
        this.gotoIssue(issueKey);
        this.clickLink("move-issue");
        this.selectOption("pid", "neanderthal");
        this.submit();
        this.assertTextPresent("Step 3 of 4");
        this.setWorkingForm("jiraform");
        this.submit();
        this.assertTextPresent("&quot;Due Date&quot; field is required and you do not have permission to Schedule Issues for project &quot;neanderthal&quot;.");
        this.resetFields();
        this.grantGroupPermission("New Permission Scheme", 28, "jira-developers");
        this.removeGroupPermission("New Permission Scheme", 11, "jira-users");
        this.associatePermSchemeToProject("neanderthal", "Default Permission Scheme");
    }

    public void permissionSchemesMoveIssueToProjectWithCreatePermission(String issueKey) {
        TestPermissionSchemes.log("Move Operation: Moving issue to a project with 'Create Issue' Permission.");
        this.associatePermSchemeToProject("neanderthal", "New Permission Scheme");
        this.grantGroupPermission("New Permission Scheme", 11, "jira-users");
        this.gotoIssue(issueKey);
        this.clickLink("move-issue");
        this.assertOptionsEqual("pid", new String[]{"homosapien", "monkey", "neanderthal"});
        this.removeGroupPermission("New Permission Scheme", 11, "jira-users");
        this.gotoIssue(issueKey);
        this.clickLink("move-issue");
        this.assertOptionsEqual("pid", new String[]{"homosapien", "monkey"});
        this.associatePermSchemeToProject("neanderthal", "Default Permission Scheme");
    }
}

