/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableLocator;

public class TestLookAndFeelUpgrade
extends FuncTestCase {
    public void test312NonModified() throws Exception {
        this.administration.restoreData("TestUpgradeBase312.xml");
        this.navigation.gotoAdminSection("lookandfeel");
        this.assertHasDefaultLookAndFeel();
    }

    public void test312Modified() throws Exception {
        this.administration.restoreData("TestUpgradeModifiedLookAndFeel312.xml");
        this.navigation.gotoAdminSection("lookandfeel");
        this.assertHas312Modifications();
    }

    public void test313NonModified() throws Exception {
        this.administration.restoreData("TestUpgradeBase313.xml");
        this.navigation.gotoAdminSection("lookandfeel");
        this.assertHasDefaultLookAndFeel();
    }

    public void test313Modified() throws Exception {
        this.administration.restoreData("TestUpgradeModifiedLookAndFeel313.xml");
        this.navigation.gotoAdminSection("lookandfeel");
        this.assertHas313Modifications();
    }

    private void assertHas312Modifications() {
        TableLocator tableLocatorLogo = new TableLocator(this.tester, "lookAndFeelLogo");
        this.text.assertTextSequence(tableLocatorLogo, new String[]{"URL", "/images/debug/debug.png", "Preview", "Logo Width", "16", "Logo Height", "16"});
        TableLocator tableLocatorColors = new TableLocator(this.tester, "lookAndFeelColors");
        String textStr = tableLocatorColors.getText();
        this.text.assertTextSequence(textStr, new String[]{"Header Background Colour", "#99ccff", "Header Highlight Background Colour", "<default>", "Header Text Colour", "#cc00ff", "Header Text Highlight Colour", "<default>", "Header Separator Color", "#99ccff", "Navigation Bar Background Colour", "#3366ff", "Navigation Bar Text Colour", "#000066", "Navigation Bar Separator Colour", "<default>"});
    }

    private void assertHas313Modifications() {
        TableLocator tableLocatorLogo = new TableLocator(this.tester, "lookAndFeelLogo");
        this.text.assertTextSequence(tableLocatorLogo, new String[]{"URL", "/images/debug/debug.png", "Preview", "Logo Width", "16", "Logo Height", "16"});
        TableLocator tableLocatorColors = new TableLocator(this.tester, "lookAndFeelColors");
        String textStr = tableLocatorColors.getText();
        this.text.assertTextSequence(textStr, new String[]{"Header Background Colour", "#663399", "Header Highlight Background Colour", "#ff33cc", "Header Text Colour", "#cccccc", "Header Text Highlight Colour", "#6666cc", "Header Separator Color", "<default>", "Navigation Bar Background Colour", "#9966ff", "Navigation Bar Text Colour", "#777777", "Navigation Bar Separator Colour", "<default>"});
    }

    private void assertHasDefaultLookAndFeel() {
        TableLocator tableLocatorLogo = new TableLocator(this.tester, "lookAndFeelLogo");
        this.text.assertTextSequence(tableLocatorLogo, new String[]{"URL", "<default>", "Preview", "<N/A>", "Logo Width", "<default>", "Logo Height", "<default>"});
        TableLocator tableLocatorColors = new TableLocator(this.tester, "lookAndFeelColors");
        String textStr = tableLocatorColors.getText();
        this.text.assertTextSequence(textStr, new String[]{"Header Background Colour", "<default>", "Header Highlight Background Colour", "<default>", "Header Text Colour", "<default>", "Header Text Highlight Colour", "<default>", "Header Separator Color", "<default>", "Navigation Bar Background Colour", "<default>", "Navigation Bar Text Colour", "<default>", "Navigation Bar Separator Colour", "<default>", "Link Colour", "<default>", "Link Active Colour", "<default>", "Heading Colour", "<default>"});
        TableLocator tableLocatorGadgetColors = new TableLocator(this.tester, "lookAndFeelGadgetChromeColours");
        textStr = tableLocatorGadgetColors.getText();
        this.text.assertTextSequence(textStr, new String[]{"Colour 1", "<default>", "Colour 2", "<default>", "Colour 3", "<default>", "Colour 4", "<default>", "Colour 5", "<default>", "Colour 6", "<default>", "Colour 7", "<default>"});
        TableLocator tableLocatorFormats = new TableLocator(this.tester, "lookAndFeelFormats");
        this.text.assertTextSequence(tableLocatorFormats, new String[]{"Time Format", "h:mm a", "Day Format", "EEEE h:mm a", "Complete Date/Time Format", "dd/MMM/yy h:mm a", "Day/Month/Year Format", "dd/MMM/yy", "Date Picker Format (javascript format)", "d/MMM/yy (%e/%b/%y)", "Date Time Picker Format (javascript format)", "dd/MMM/yy h:mm a (%e/%b/%y %I:%M %p)"});
    }
}

