/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class TestGroupBrowser
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testGroupPagingWorks() {
        this.addSomeGroups();
        this.assertGroupNamesIsPresent(0, 19);
        this.assertNextOnlyIsPresent();
        this.clickNext();
        this.assertGroupNamesIsPresent(20, 39);
        this.assertNextAndPrevOnlyIsPresent();
        this.clickNext();
        this.assertGroupNamesIsPresent(40, 49);
        this.assertPrevOnlyIsPresent();
        this.clickPrevious();
        this.assertGroupNamesIsPresent(20, 39);
        this.assertNextAndPrevOnlyIsPresent();
        this.clickPrevious();
        this.assertGroupNamesIsPresent(0, 19);
        this.assertNextOnlyIsPresent();
    }

    public void testGroupFilteringPagingWorks() {
        this.addSomeGroups();
        this.assertGroupNamesIsPresent(0, 19);
        this.assertNextOnlyIsPresent();
        this.setFilter("03");
        this.assertGroupNamesIsPresent(3, 3);
        this.assertGroupNamesIsPresent(30, 39);
        this.assertNextAndPrevNotPresent();
        this.setFilter("group");
        this.assertGroupNamesIsPresent(0, 19);
        this.assertNextOnlyIsPresent();
        this.assertGroupNamesIsPresent(0, 19);
        this.assertNextOnlyIsPresent();
        this.clickNext();
        this.assertGroupNamesIsPresent(20, 39);
        this.assertNextAndPrevOnlyIsPresent();
        this.clickNext();
        this.assertGroupNamesIsPresent(40, 49);
        this.assertPrevOnlyIsPresent();
        this.clickPrevious();
        this.assertGroupNamesIsPresent(20, 39);
        this.assertNextAndPrevOnlyIsPresent();
        this.clickPrevious();
        this.assertGroupNamesIsPresent(0, 19);
        this.assertNextOnlyIsPresent();
    }

    private void setFilter(String filterStr) {
        this.tester.setFormElement("nameFilter", filterStr);
        this.tester.submit("");
    }

    private void assertPrevOnlyIsPresent() {
        this.tester.assertTextNotPresent("Next");
        this.tester.assertTextPresent("Previous");
    }

    private void assertNextAndPrevOnlyIsPresent() {
        this.tester.assertTextPresent("Next");
        this.tester.assertTextPresent("Previous");
    }

    private void assertNextAndPrevNotPresent() {
        this.tester.assertTextNotPresent("Next");
        this.tester.assertTextNotPresent("Previous");
    }

    private void assertNextOnlyIsPresent() {
        this.tester.assertTextPresent("Next");
        this.tester.assertTextNotPresent("Previous");
    }

    private void clickNext() {
        this.tester.clickLinkWithText("Next >>");
    }

    private void clickPrevious() {
        this.tester.clickLinkWithText("Previous");
    }

    private void assertGroupNamesIsPresent(int start, int end) {
        ArrayList<String> listOfGroupNames = new ArrayList<String>();
        for (int i = start; i <= end; ++i) {
            listOfGroupNames.add(this.makeGroupName("group", i));
        }
        String[] groupNames = listOfGroupNames.toArray(new String[listOfGroupNames.size()]);
        this.text.assertTextSequence(new XPathLocator(this.tester, "//table[@id='group_browser_table']"), groupNames);
    }

    private void addSomeGroups() {
        for (int i = 0; i < 50; ++i) {
            this.addGroup("group", i);
        }
    }

    private void addGroup(String userName, int i) {
        this.tester.clickLink("admin_link");
        this.tester.clickLink("group_browser");
        this.navigation.checkWebSudoWithLastPassword();
        this.tester.setFormElement("addName", this.makeGroupName(userName, i));
        this.tester.submit("add_group");
    }

    private String makeGroupName(String userName, int i) {
        return userName + new DecimalFormat("000").format(i);
    }

    public void testAddBlankGroup() {
        this.tester.clickLink("admin_link");
        this.tester.clickLink("group_browser");
        this.navigation.checkWebSudoWithLastPassword();
        this.tester.setFormElement("addName", "");
        this.tester.submit("add_group");
        this.tester.assertTextPresent("You must specify valid group name.");
    }
}

