/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeBomb {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
    private final Date explosionDate;

    public TimeBomb(String date) {
        try {
            this.explosionDate = DATE_FORMAT.parse(date);
        }
        catch (ParseException ex) {
            throw new RuntimeException("Failed to parse date '" + date + "'.", ex);
        }
    }

    public boolean ignoreTest() {
        return new Date().before(this.explosionDate);
    }

    public boolean runTest() {
        return !this.ignoreTest();
    }

    public static boolean runAfter(String explosionDate) {
        Date explosion;
        try {
            explosion = DATE_FORMAT.parse(explosionDate);
        }
        catch (ParseException ex) {
            throw new RuntimeException("Failed to parse date '" + explosionDate + "'.", ex);
        }
        return new Date().after(explosion);
    }
}

