/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.table;

import com.atlassian.jira.functest.framework.util.text.TextKit;
import com.atlassian.jira.util.dbc.Assertions;
import com.meterware.httpunit.WebTable;
import net.sourceforge.jwebunit.WebTester;

public class HtmlTable {
    private WebTable webTable;

    public HtmlTable(WebTable webTable) {
        Assertions.notNull("webTable", webTable);
        this.webTable = webTable;
    }

    public static HtmlTable newHtmlTable(WebTester tester, String tableID) {
        WebTable webTable = tester.getDialog().getWebTableBySummaryOrId(tableID);
        return new HtmlTable(webTable);
    }

    public Row getRow(int rowIndex) {
        return new Row(this.webTable, rowIndex);
    }

    public Row findRowWhereCellEquals(int columnIndex, String cellValue) {
        for (int rowNum = 0; rowNum < this.webTable.getRowCount(); ++rowNum) {
            String value = this.webTable.getCellAsText(rowNum, columnIndex);
            if (value == null || !value.trim().equals(cellValue)) continue;
            return this.getRow(rowNum);
        }
        return null;
    }

    public Row findRowWhereCellStartsWith(int columnIndex, String prefix) {
        for (int rowNum = 0; rowNum < this.webTable.getRowCount(); ++rowNum) {
            String value = this.webTable.getCellAsText(rowNum, columnIndex);
            if (value == null || !value.trim().startsWith(prefix)) continue;
            return this.getRow(rowNum);
        }
        return null;
    }

    public boolean doesCellHaveText(int row, int col, String text) {
        String cellContent = this.webTable.getCellAsText(row, col);
        return cellContent.contains(text);
    }

    public int getRowCount() {
        return this.webTable.getRowCount();
    }

    public static class Row {
        private final WebTable webTable;
        private final int rowIndex;

        Row(WebTable webTable, int rowIndex) {
            this.webTable = webTable;
            this.rowIndex = rowIndex;
        }

        public String getCellAsText(int cellIndex) {
            return TextKit.collapseWhitespace(this.webTable.getCellAsText(this.rowIndex, cellIndex));
        }

        public int getRowIndex() {
            return this.rowIndex;
        }
    }
}

