/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Closeable;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.collect.CollectionUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public interface CloseableIterator<E>
extends Iterator<E>,
Closeable {
    @Override
    public void remove();

    public static final class Functions {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <T> void foreach(CloseableIterator<T> iterator, Consumer<T> consumer) {
            try {
                CollectionUtil.foreach(iterator, consumer);
            }
            finally {
                iterator.close();
            }
        }

        private Functions() {
            throw new AssertionError((Object)"cannot instantiate!");
        }
    }

    public static class ListResolver<T> {
        public List<T> get(CloseableIterator<T> it) {
            final ArrayList result = new ArrayList();
            Functions.foreach(it, new Consumer<T>(){

                @Override
                public void consume(T element) {
                    result.add(element);
                }
            });
            return result;
        }
    }
}

