/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util.text;

import com.opensymphony.util.TextUtils;
import java.util.StringTokenizer;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

public class TextKit {
    public static String collapseWhitespace(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(text);
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            if (!st.hasMoreTokens()) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public static boolean equalsCollapseWhiteSpace(String string1, String string2) {
        if (string1 == null) {
            return string2 == null;
        }
        String collapsed1 = TextKit.collapseWhitespace(string1);
        String collapsed2 = TextKit.collapseWhitespace(string2);
        return collapsed1.equals(collapsed2);
    }

    public static boolean containsCollapseWhiteSpace(String needle, String haystack) {
        if (haystack == null) {
            return needle == null;
        }
        if (needle == null) {
            return false;
        }
        String collapsedNeedle = TextKit.collapseWhitespace(needle);
        String collapsedHaystack = TextKit.collapseWhitespace(haystack);
        return collapsedHaystack.contains(collapsedNeedle);
    }

    public static int getNumOccurences(String text, String subString) {
        int index;
        if (text == null || subString == null) {
            throw new IllegalArgumentException("Parameters cannot be null.");
        }
        if (subString.length() == 0) {
            throw new IllegalArgumentException("subString cannot be empty.");
        }
        int fromIndex = 0;
        int count = 0;
        do {
            if ((index = text.indexOf(subString, fromIndex)) <= -1) continue;
            ++count;
            fromIndex = index + subString.length();
        } while (index > -1);
        return count;
    }

    public static boolean containsTextSequence(String srcText, String[] expectedTextSequence) {
        try {
            TextKit.assertContainsTextSequence(srcText, expectedTextSequence);
            return true;
        }
        catch (AssertionFailedError ex) {
            return false;
        }
    }

    public static void assertContainsTextSequence(String srcText, String[] expectedTextSequence) {
        if (srcText == null || expectedTextSequence == null) {
            throw new IllegalArgumentException("Parameters cannot be null.");
        }
        int fromIndex = 0;
        String remainingText = srcText;
        for (int i = 0; i < expectedTextSequence.length; ++i) {
            String expected = expectedTextSequence[i];
            int index = srcText.indexOf(expected, fromIndex);
            if (index < 0) {
                if (remainingText.length() > 40) {
                    remainingText = remainingText.substring(0, 40);
                }
                Assert.fail((String)("Sequence assertion failed on the " + TextKit.getOrdinalFor(i + 1) + " member of the expectedTextSequence: '" + expected + "'." + " around about here : ....'" + remainingText + "'..."));
            }
            fromIndex = index + expected.length();
            remainingText = srcText.substring(fromIndex);
        }
    }

    private static String getOrdinalFor(int n) {
        if (n > 10 && n < 20) {
            return String.valueOf(n) + "th";
        }
        if (n % 10 == 1) {
            return String.valueOf(n) + "st";
        }
        if (n % 10 == 2) {
            return String.valueOf(n) + "nd";
        }
        if (n % 10 == 3) {
            return String.valueOf(n) + "rd";
        }
        return String.valueOf(n) + "th";
    }

    public static String htmlEncode(String text) {
        return TextUtils.htmlEncode((String)text, (boolean)false);
    }
}

