/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.sharing;

import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class SharedEntityInfo {
    private Long id;
    private String name;
    private String description;
    private boolean favourite;
    private Set<? extends TestSharingPermission> sharingPermissions;
    private String owner;
    private Integer favCount;

    public SharedEntityInfo(String name, String description, boolean favourite, Set<? extends TestSharingPermission> sharingPermissions, String owner, Integer favCount) {
        this(null, name, description, favourite, sharingPermissions, owner, favCount);
    }

    public SharedEntityInfo(Long id, String name, String description, boolean favourite, Set<? extends TestSharingPermission> sharingPermissions, String owner, Integer favCount) {
        this.setId(id);
        this.setName(name);
        this.setDescription(description);
        this.setFavourite(favourite);
        this.setSharingPermissions(sharingPermissions);
        this.setOwner(owner);
        this.setFavCount(favCount);
    }

    public SharedEntityInfo(String name, String description, boolean favourite, Set<? extends TestSharingPermission> sharingPermissions) {
        this(null, name, description, favourite, sharingPermissions, null, null);
    }

    public SharedEntityInfo(Long id, String name, String description, boolean favourite, Set<? extends TestSharingPermission> sharingPermissions) {
        this(id, name, description, favourite, sharingPermissions, null, null);
    }

    public SharedEntityInfo(SharedEntityInfo sharedEntityInfo) {
        this.setId(sharedEntityInfo.getId());
        this.setName(sharedEntityInfo.getName());
        this.setDescription(sharedEntityInfo.getDescription());
        this.setFavourite(sharedEntityInfo.isFavourite());
        this.setSharingPermissions(sharedEntityInfo.getSharingPermissions());
        this.setOwner(sharedEntityInfo.getOwner());
        this.setFavCount(sharedEntityInfo.getFavCount());
    }

    public Long getId() {
        return this.id;
    }

    public SharedEntityInfo setId(Long id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public SharedEntityInfo setName(String name) {
        this.name = name == null ? "" : name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public SharedEntityInfo setDescription(String description) {
        this.description = description == null ? "" : description;
        return this;
    }

    public boolean isFavourite() {
        return this.favourite;
    }

    public SharedEntityInfo setFavourite(boolean favourite) {
        this.favourite = favourite;
        return this;
    }

    public Set<? extends TestSharingPermission> getSharingPermissions() {
        return this.sharingPermissions;
    }

    public SharedEntityInfo setSharingPermissions(Set<? extends TestSharingPermission> sharingPermissions) {
        this.sharingPermissions = sharingPermissions;
        return this;
    }

    public String getOwner() {
        return this.owner;
    }

    public SharedEntityInfo setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public Integer getFavCount() {
        return this.favCount;
    }

    public SharedEntityInfo setFavCount(Integer favCount) {
        this.favCount = favCount;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedEntityInfo that = (SharedEntityInfo)o;
        if (this.favourite != that.favourite) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.favCount != null ? !this.favCount.equals(that.favCount) : that.favCount != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.owner != null ? !this.owner.equals(that.owner) : that.owner != null) {
            return false;
        }
        return !(this.sharingPermissions != null ? !((Object)this.sharingPermissions).equals(that.sharingPermissions) : that.sharingPermissions != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.favourite ? 1 : 0);
        result = 31 * result + (this.sharingPermissions != null ? ((Object)this.sharingPermissions).hashCode() : 0);
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        result = 31 * result + (this.favCount != null ? this.favCount.hashCode() : 0);
        return result;
    }
}

