/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.parser.worklog;

import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.parser.worklog.Worklog;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Node;

public class WorklogParser {
    public static List<Worklog> getWorklogs(WebTester tester) {
        ArrayList<Worklog> worklogList = new ArrayList<Worklog>();
        XPathLocator xPathLocator = new XPathLocator(tester, "//div[@class='actionContainer']");
        for (int i = 0; i < xPathLocator.getNodes().length; ++i) {
            Node actionContainerNode = xPathLocator.getNodes()[i];
            String details = WorklogParser.getTextFromSubNode(actionContainerNode, "div[@class='action-details']");
            if (details.indexOf("logged work") == -1) continue;
            Worklog worklog = new Worklog();
            worklog.setDetails(details);
            worklog.setTimeWorked(WorklogParser.getTextFromSubNode(actionContainerNode, "div[@class='action-body']//dd[@class='worklog-duration']"));
            worklog.setLog(WorklogParser.getTextFromSubNode(actionContainerNode, "div[@class='action-body']//dd[@class='worklog-comment']"));
            worklogList.add(worklog);
        }
        return worklogList;
    }

    private static String getTextFromSubNode(Node node, String xpath) {
        String text = new XPathLocator(node, xpath).getText();
        if (text == null) {
            return null;
        }
        return text.trim();
    }
}

