/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.log;

import com.atlassian.jira.functest.framework.log.FuncTestLogger;
import com.atlassian.jira.functest.framework.log.FuncTestOut;
import java.io.PrintWriter;
import java.io.StringWriter;

public class FuncTestLoggerImpl
implements FuncTestLogger {
    private static final char LOG_PREFIX_CHAR = '.';
    private final int indentLevel;

    public FuncTestLoggerImpl() {
        this(0);
    }

    public FuncTestLoggerImpl(int indetLevel) {
        this.indentLevel = indetLevel;
    }

    @Override
    public void log(Object logData) {
        FuncTestLoggerImpl.logIndented(this.indentLevel, logData);
    }

    @Override
    public void log(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        FuncTestLoggerImpl.logIndented(this.indentLevel, sw);
    }

    static void logIndented(Object logData) {
        FuncTestLoggerImpl.logIndented(0, logData);
    }

    static void logIndented(int indentLevel, Object logData) {
        String logDataStr = String.valueOf(logData);
        String indentStr = FuncTestLoggerImpl.buildIndentStr(indentLevel);
        if (logDataStr.indexOf(10) != -1) {
            StringBuffer sb = new StringBuffer(indentStr);
            sb.append(logDataStr);
            indentStr = '\n' + indentStr;
            int index = sb.indexOf("\n");
            while (index != -1) {
                sb.replace(index, index + 1, indentStr);
                index = sb.indexOf("\n", index + indentStr.length());
            }
            logDataStr = sb.toString();
            FuncTestOut.out.println(logDataStr);
        } else {
            FuncTestOut.out.print(indentStr);
            FuncTestOut.out.println(logDataStr);
        }
    }

    private static String buildIndentStr(int indentLevel) {
        StringBuffer sb = new StringBuffer();
        if (indentLevel == 0) {
            sb.append('.');
        } else if (indentLevel >= 1) {
            sb.append('\t');
            sb.append('.');
        }
        for (int i = 1; i < indentLevel; ++i) {
            sb.append('\t');
        }
        sb.append(' ');
        return sb.toString();
    }
}

