/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.locator;

import com.atlassian.jira.functest.framework.locator.AbstractLocator;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AggregateLocator
extends AbstractLocator
implements Locator {
    private final Locator[] locators;

    public AggregateLocator(Locator firstLocator, Locator secondLocator) {
        this(new Locator[]{firstLocator, secondLocator});
        this.getNodes();
    }

    public AggregateLocator(Locator[] locators) {
        boolean ok = true;
        if (locators == null || locators.length == 0) {
            // empty if block
        }
        for (int i = 0; i < locators.length; ++i) {
            Locator locator = locators[i];
            if (locator != null) continue;
            ok = false;
            break;
        }
        if (!ok) {
            throw new IllegalArgumentException("The provided Locators array must be nulll null and have non null Locator instances in it");
        }
        this.locators = locators;
    }

    @Override
    public Node[] getNodes() {
        if (this.nodes == null) {
            ArrayList<Node> list = new ArrayList<Node>();
            for (int i = 0; i < this.locators.length; ++i) {
                Locator locator = this.locators[i];
                Node[] nodes = locator.getNodes();
                for (int j = 0; j < nodes.length; ++j) {
                    Node node = nodes[j];
                    list.add(DomKit.betterNode(node));
                }
            }
            this.nodes = list.toArray(new Element[list.size()]);
        }
        return this.nodes;
    }

    @Override
    public String toString() {
        return this.toStringImpl("AggregateLocator");
    }
}

