/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.assertions.JiraFormAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;

public class JiraFormAssertionsImpl
extends AbstractFuncTestUtil
implements JiraFormAssertions {
    private final TextAssertions textAssertions;

    public JiraFormAssertionsImpl(TextAssertions textAssertions, WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
        this.textAssertions = textAssertions;
    }

    @Override
    public void assertFieldErrMsg(String expectedText) {
        Locator error = this.createFieldErrorMessageLocator();
        this.textAssertions.assertTextPresent(error, expectedText);
    }

    @Override
    public void assertAuiFieldErrMsg(String expectedText) {
        Locator error = this.createAuiFieldErrorMessageLocator();
        this.textAssertions.assertTextPresent(error, expectedText);
    }

    @Override
    public void assertFormErrMsg(String expectedText) {
        Locator error = this.createFormErrorMessageLocator();
        this.textAssertions.assertTextPresent(error, expectedText);
    }

    @Override
    public void assertNoFieldErrMsg(String notExpectedText) {
        this.textAssertions.assertTextNotPresent(this.createFieldErrorMessageLocator(), notExpectedText);
    }

    @Override
    public void assertNoFormErrMsg(String notExpectedText) {
        this.textAssertions.assertTextNotPresent(this.createFormErrorMessageLocator(), notExpectedText);
    }

    @Override
    public void assertNoErrorsPresent() {
        Locator errorLocator = this.createFieldErrorMessageLocator();
        Assert.assertNull((String)"Expected no errors on the page, but there was a field with an error.", (Object)errorLocator.getNode());
        errorLocator = this.createFormErrorMessageLocator();
        Assert.assertNull((String)"Expected no errors on the page, but the page had a global error.", (Object)errorLocator.getNode());
    }

    @Override
    public void assertSelectElementHasOptionSelected(String selectElementName, String optionName) {
        String actual = this.tester.getDialog().getSelectedOption(selectElementName);
        Assert.assertEquals((String)("Expected option selected '" + optionName + "' was not selected in form element '" + selectElementName + "'. Actual selected option was '" + actual + "'."), (String)optionName, (String)actual);
    }

    @Override
    public void assertFormNotificationMsg(String expectedText) {
        Locator notification = this.createFormNotificationMessageLocator();
        this.textAssertions.assertTextPresent(notification, expectedText);
    }

    private Locator createFieldErrorMessageLocator() {
        return new XPathLocator(this.tester, "//span[@class='errMsg']");
    }

    private Locator createAuiFieldErrorMessageLocator() {
        return new XPathLocator(this.tester, "//form[@class='aui']//div[@class='field-group']/div[@class='error']");
    }

    private Locator createFormErrorMessageLocator() {
        return new XPathLocator(this.tester, "//div[@class='errorArea'] | //div[@class='notify error']");
    }

    private Locator createFormNotificationMessageLocator() {
        return new XPathLocator(this.tester, "//div[@class='notify info']");
    }
}

