/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.CommentAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;

public class DefaultCommentAssertions
implements CommentAssertions {
    private Iterable<String> comments;
    private Navigation navigation;
    private TextAssertions text;
    private LocatorFactory locator;

    DefaultCommentAssertions(Iterable<String> comments, Navigation navigation, TextAssertions text, LocatorFactory locator) {
        this.comments = comments;
        this.navigation = navigation;
        this.text = text;
        this.locator = locator;
    }

    @Override
    public void areVisibleTo(String userName, String issueKey) {
        this.navigation.logout();
        this.navigation.login(userName);
        this.navigation.issue().gotoIssue(issueKey);
        for (String comment : this.comments) {
            this.text.assertTextPresent(this.locator.xpath("//*[@id='issue_actions_container']//div[contains(concat(' ', normalize-space(@class), ' '), ' action-body ')]"), comment);
        }
        this.navigation.login("admin", "admin");
    }

    @Override
    public void areNotVisibleTo(String userName, String issueKey) {
        this.navigation.logout();
        this.navigation.login(userName);
        this.navigation.issue().gotoIssue(issueKey);
        for (String comment : this.comments) {
            this.text.assertTextNotPresent(this.locator.xpath("//*[@id='issue_actions_container']//div[contains(concat(' ', normalize-space(@class), ' '), ' action-body ')]"), comment);
        }
        this.navigation.login("admin", "admin");
    }
}

