/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.admin.WorkflowSchemes;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.util.Map;
import net.sourceforge.jwebunit.WebTester;

public class WorkflowSchemesImpl
extends AbstractFuncTestUtil
implements WorkflowSchemes {
    private static final String WORKFLOW_SCHEMES_LINK_ID = "workflow_schemes";
    private static final String ADD_WORKFLOWSCHEME_LINK_ID = "add_workflowscheme";
    private static final String EDIT_WORKFLOWS_LINK_ID_PREFIX = "edit_workflows_";
    private static final String ISSUE_TYPE_SELECT_NAME = "type";
    private static final String WORKFLOW_SELECT_NAME = "workflow";

    public WorkflowSchemesImpl(WebTester tester, JIRAEnvironmentData environmentData, int logIndentLevel) {
        super(tester, environmentData, logIndentLevel);
    }

    @Override
    public WorkflowSchemes goTo() {
        this.navigation().gotoAdminSection(WORKFLOW_SCHEMES_LINK_ID);
        return this;
    }

    @Override
    public Integer addWorkflowScheme(String name, String description) {
        this.tester.clickLink(ADD_WORKFLOWSCHEME_LINK_ID);
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("name", name);
        this.tester.setFormElement("description", description);
        this.tester.submit("Add");
        return Integer.valueOf(this.locators.id("workflow-scheme-id").getNode().getAttributes().getNamedItem("value").getNodeValue());
    }

    @Override
    public WorkflowSchemes assignWorkflows(String schemeName, Map<String, String> workflowMappings) {
        this.goToEditWorkflows(schemeName);
        for (Map.Entry<String, String> mapping : workflowMappings.entrySet()) {
            this.assignWorkflowFromEditWorkflowsPage(mapping.getKey(), mapping.getValue());
        }
        return this;
    }

    @Override
    public WorkflowSchemes assignWorkflow(String schemeName, String issueTypeId, String workflowName) {
        this.goToEditWorkflows(schemeName);
        this.assignWorkflowFromEditWorkflowsPage(issueTypeId, workflowName);
        return this;
    }

    @Override
    public WorkflowSchemes assignWorkflowToAllIssueTypes(String schemeName, String workflowName) {
        return this.assignWorkflow(schemeName, "All Unassigned Issue Types", workflowName);
    }

    private void goToEditWorkflows(String schemeName) {
        this.tester.clickLink(EDIT_WORKFLOWS_LINK_ID_PREFIX + schemeName);
    }

    private void assignWorkflowFromEditWorkflowsPage(String issueType, String workflowName) {
        this.navigation().clickLinkWithExactText("Assign a workflow");
        this.tester.selectOption(ISSUE_TYPE_SELECT_NAME, issueType);
        this.tester.selectOption(WORKFLOW_SELECT_NAME, workflowName);
        this.tester.submit("Add");
    }
}

