/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;

public class GeneralConfigurationImpl
extends AbstractFuncTestUtil
implements GeneralConfiguration {
    public GeneralConfigurationImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
    }

    @Override
    public void setAllowUnassignedIssues(boolean enable) {
        this.gotoEditGeneralConfig();
        this.tester.getDialog().setFormParameter("allowUnassigned", String.valueOf(enable));
        this.tester.submit();
    }

    @Override
    public void setExternalUserManagement(boolean enable) {
        this.gotoEditGeneralConfig();
        if (enable) {
            this.tester.checkCheckbox("externalUM", "true");
            this.tester.selectOption("mode", "Private");
        } else {
            this.tester.checkCheckbox("externalUM", "false");
        }
        this.tester.submit();
    }

    @Override
    public void setExternalPasswordManagement(boolean enable) {
        this.gotoEditGeneralConfig();
        if (enable) {
            this.tester.checkCheckbox("externalPM", "true");
        } else {
            this.tester.checkCheckbox("externalPM", "false");
        }
        this.tester.submit();
    }

    @Override
    public void enableVoting() {
        this.gotoEditGeneralConfig();
        this.tester.getDialog().setFormParameter("voting", "true");
        this.tester.submit();
    }

    @Override
    public void setUserSearchingByFullName(boolean enable) {
        this.gotoEditGeneralConfig();
        this.tester.getDialog().setFormParameter("ajaxUserPicker", String.valueOf(enable));
        this.tester.submit();
    }

    @Override
    public void setEncoding(String newEncoding) {
        this.gotoEditGeneralConfig();
        this.tester.getDialog().setFormParameter("encoding", newEncoding);
        this.tester.submit();
    }

    @Override
    public void setCommentVisibility(GeneralConfiguration.CommentVisibility commentVisibility) {
        this.gotoEditGeneralConfig();
        this.tester.checkCheckbox("groupVisibility", commentVisibility.getCheckBoxValue().toString());
        this.tester.submit();
    }

    @Override
    public void setUserEmailVisibility(GeneralConfiguration.EmailVisibility emailVisibility) {
        this.gotoEditGeneralConfig();
        this.tester.getDialog().setFormParameter("emailVisibility", String.valueOf((Object)emailVisibility));
        this.tester.submit();
    }

    @Override
    public void setJqlAutocomplete(boolean enable) {
        this.gotoEditGeneralConfig();
        this.tester.getDialog().setFormParameter("jqlAutocompleteDisabled", String.valueOf(!enable));
        this.tester.submit();
    }

    @Override
    public void disableVoting() {
        this.gotoEditGeneralConfig();
        this.tester.getDialog().setFormParameter("voting", "false");
        this.tester.submit();
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.log("Setting baseurl to '" + baseUrl + "'");
        this.gotoEditGeneralConfig();
        this.tester.setFormElement("baseURL", baseUrl);
        this.tester.submit();
    }

    @Override
    public void fixBaseUrl() {
        this.setBaseUrl(this.getEnvironmentData().getBaseUrl().toString());
    }

    @Override
    public void setJiraLocale(String locale) {
        String[] localeOptions;
        this.log("Setting locale to '" + locale + "'");
        this.gotoEditGeneralConfig();
        this.tester.setWorkingForm("jiraform");
        String localeToSelect = null;
        for (String localeOption : localeOptions = this.tester.getDialog().getOptionsFor("defaultLocale")) {
            if (localeOption.equals(locale)) {
                localeToSelect = locale;
                continue;
            }
            if (!localeOption.equals(locale.concat(" [Default]"))) continue;
            localeToSelect = locale.concat(" [Default]");
        }
        Assert.assertNotNull((String)localeToSelect, (Object)("The locale: " + locale + "could not be found as an option in the Default " + "Language select list on the Administration --> General Configuration --> Edit Configuration Page"));
        this.tester.selectOption("defaultLocale", localeToSelect);
        this.tester.submit();
    }

    @Override
    public void disableWatching() {
        this.gotoEditGeneralConfig();
        this.tester.getDialog().setFormParameter("watching", "false");
        this.tester.submit();
    }

    @Override
    public void enableWatching() {
        this.gotoEditGeneralConfig();
        this.tester.getDialog().setFormParameter("watching", "true");
        this.tester.submit();
    }

    @Override
    public void turnOnGZipCompression() {
        this.gotoEditGeneralConfig();
        this.tester.checkCheckbox("useGzip", "true");
        this.tester.submit();
    }

    protected Navigation getNavigation() {
        return this.getFuncTestHelperFactory().getNavigation();
    }

    private void gotoEditGeneralConfig() {
        this.getNavigation().gotoAdminSection("general_configuration");
        this.getNavigation().checkWebSudoWithLastPassword();
        this.tester.clickLink("edit-app-properties");
    }
}

