/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.Splitable;
import com.atlassian.jira.functest.framework.log.FuncTestOut;
import com.atlassian.jira.functest.framework.util.testcase.TestCaseKit;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.IteratorEnumeration;
import com.atlassian.jira.webtests.util.EnvironmentAware;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.util.TenantOverridingEnvironmentData;
import com.atlassian.jira.webtests.util.TestCaseMethodNameDetector;
import com.atlassian.jira.webtests.ztests.misc.TestDefaultJiraDataFromInstall;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.junit.Ignore;

public final class TestSuiteBuilder {
    private int maxBatch;
    private int batch;
    private boolean log;
    private boolean parallel;
    private final Set<Class<? extends TestCase>> testClasses = new LinkedHashSet<Class<? extends TestCase>>();

    public TestSuiteBuilder(int batch, int maxBatch) {
        this.batch(batch);
        this.maxBatch(maxBatch);
        this.log(false);
    }

    public TestSuiteBuilder() {
        this(-1, -1);
    }

    public TestSuiteBuilder addTests(Collection<Class<? extends TestCase>> tests) {
        this.testClasses.addAll(tests);
        return this;
    }

    public TestSuiteBuilder addTests(Class<? extends TestCase> ... tests) {
        return this.addTests(Arrays.asList(tests));
    }

    public TestSuiteBuilder addTest(Class<? extends TestCase> test) {
        this.testClasses.add(test);
        return this;
    }

    public TestSuiteBuilder log(boolean log) {
        this.log = log;
        return this;
    }

    public TestSuiteBuilder batch(int batch) {
        if (batch == 0) {
            throw new IllegalArgumentException("batch == 0");
        }
        this.batch = batch;
        return this;
    }

    public TestSuiteBuilder maxBatch(int maxBatch) {
        if (maxBatch == 0) {
            throw new IllegalArgumentException("maxBatch == 0");
        }
        this.maxBatch = maxBatch;
        return this;
    }

    public TestSuiteBuilder parallel(boolean parallel) {
        this.parallel = parallel;
        return this;
    }

    private boolean isBatchMode() {
        return this.batch >= 0;
    }

    public Test build() {
        if (this.parallel) {
            return this.createParallelTests();
        }
        return this.isBatchMode() ? this.createTestBatch(this.batch, this.maxBatch) : this.createAllTest();
    }

    private Test createParallelTests() {
        ParallelEnvironmentTestSuite suite = new ParallelEnvironmentTestSuite();
        for (int i = 1; i <= this.maxBatch; ++i) {
            suite.addTest(this.createTestBatch(i, this.maxBatch));
        }
        return suite;
    }

    private Test createAllTest() {
        EnvironmentTestSuite suite = new EnvironmentTestSuite();
        for (Class<? extends TestCase> testClass : this.testClasses) {
            suite.addTestSuite(testClass);
        }
        if (this.log) {
            FuncTestOut.log("** Tests in global **");
            TestSuiteBuilder.outputTest(suite);
            TestSuiteBuilder.outputIgnored(suite);
            FuncTestOut.log("** End tests in global **");
        }
        return suite;
    }

    private Test createTestBatch(int batchNo, int maxBatches) {
        this.checkBatchState(batchNo, maxBatches);
        int numberOfTests = 0;
        ArrayList<TestPair> tests = new ArrayList<TestPair>(this.testClasses.size());
        for (Class<? extends TestCase> testClass : this.testClasses) {
            EnvironmentTestSuite currentTest = new EnvironmentTestSuite(testClass);
            if (!TestSuiteBuilder.isBatchable(testClass)) {
                if (batchNo != maxBatches || currentTest.countTestCases() <= 0) continue;
                tests.add(new TestPair(testClass, (Test)currentTest));
                continue;
            }
            if (TestSuiteBuilder.isSplittable(testClass)) {
                currentTest = this.splitSuite(currentTest, batchNo, maxBatches);
            } else {
                numberOfTests += currentTest.countTestCases();
            }
            if (currentTest.allTests().isEmpty()) continue;
            tests.add(new TestPair(testClass, (Test)currentTest));
        }
        EnvironmentTestSuite suite = new EnvironmentTestSuite();
        int currentBatchSize = numberOfTests / maxBatches;
        if (numberOfTests % maxBatches > 0) {
            ++currentBatchSize;
        }
        int batch = 1;
        int size = 0;
        for (TestPair pair : tests) {
            if (!TestSuiteBuilder.isBatchable(pair.getKlazz())) {
                suite.addTest(pair.getTest());
                continue;
            }
            if (TestSuiteBuilder.isSplittable(pair.getKlazz())) {
                suite.addTest(pair.getTest());
                continue;
            }
            if (batch > batchNo) continue;
            if (batch == batchNo) {
                suite.addTest(pair.getTest());
            }
            if ((size += pair.getTest().countTestCases()) < currentBatchSize) continue;
            numberOfTests -= size;
            int remainingBatches = maxBatches - batch;
            if (remainingBatches > 0) {
                currentBatchSize = numberOfTests / remainingBatches;
                if (numberOfTests % remainingBatches > 0) {
                    ++currentBatchSize;
                }
            } else {
                assert (numberOfTests == 0);
                currentBatchSize = 0;
            }
            ++batch;
            size = 0;
        }
        if (this.log) {
            FuncTestOut.log(String.format("** Tests in batch %d of %d **", batchNo, maxBatches));
            TestSuiteBuilder.outputTest(suite);
            TestSuiteBuilder.outputIgnored(suite);
            FuncTestOut.log(String.format("** End tests in batch %d of %d **", batchNo, maxBatches));
        }
        return suite;
    }

    private void checkBatchState(int batchNo, int maxBatches) {
        if (maxBatches < 0) {
            throw new IllegalStateException(String.format("Invalid maxBatch(%d) when batch(%d) >= 0.", maxBatches, batchNo));
        }
        if (batchNo > maxBatches) {
            throw new IllegalStateException(String.format("batch(%d) > maxBatch(%d).", batchNo, maxBatches));
        }
    }

    private static boolean isBatchable(Class<?> testClass) {
        return EnvironmentAware.class.isAssignableFrom(testClass);
    }

    private static boolean isSplittable(Class<? extends TestCase> testClass) {
        return testClass.getAnnotation(Splitable.class) != null;
    }

    private EnvironmentTestSuite splitSuite(TestSuite splitTest, int batchNo, int maxBatches) {
        EnvironmentTestSuite newSuite = new EnvironmentTestSuite(splitTest.getName());
        ArrayList<TestCase> newTests = new ArrayList<TestCase>(splitTest.countTestCases());
        Enumeration enumeration = splitTest.tests();
        while (enumeration.hasMoreElements()) {
            Test innerTest = (Test)enumeration.nextElement();
            if (innerTest instanceof TestCase) {
                newTests.add((TestCase)innerTest);
                continue;
            }
            if (batchNo != 1) continue;
            newSuite.addTest(innerTest);
        }
        Collections.sort(newTests, new Comparator<TestCase>(){

            @Override
            public int compare(TestCase o1, TestCase o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        int testsInBatch = newTests.size() / maxBatches;
        int testsInBatchRem = newTests.size() % maxBatches;
        int startPos = testsInBatch * (batchNo - 1);
        if (testsInBatchRem != 0) {
            startPos = batchNo <= testsInBatchRem ? (startPos += batchNo - 1) : (startPos += testsInBatchRem);
        }
        if (startPos < newTests.size()) {
            int endPos = testsInBatch + startPos;
            if (endPos > newTests.size()) {
                endPos = newTests.size();
            } else if (endPos < newTests.size() && batchNo <= testsInBatchRem) {
                ++endPos;
            }
            for (TestCase testCase : newTests.subList(startPos, endPos)) {
                newSuite.addTest((Test)testCase);
            }
        }
        return newSuite;
    }

    private static void outputTest(TestSuite suite) {
        Enumeration enumeration = suite.tests();
        while (enumeration.hasMoreElements()) {
            Test nextTest = (Test)enumeration.nextElement();
            if (nextTest instanceof TestSuite) {
                TestSuiteBuilder.outputTest((TestSuite)nextTest);
                continue;
            }
            TestSuiteBuilder.outputTestCase(nextTest);
        }
    }

    private static void outputIgnored(TestSuite suite) {
        FuncTestOut.log("** Ignored tests **");
        TestSuiteBuilder.outputIgnoredRecursively(suite);
    }

    private static void outputIgnoredRecursively(TestSuite suite) {
        if (suite instanceof EnvironmentTestSuite) {
            EnvironmentTestSuite ets = (EnvironmentTestSuite)suite;
            for (IgnoredTest test : ets.ignoredTests()) {
                TestSuiteBuilder.outputIgnoredTestCase(test.wrapped, TestSuiteBuilder.getReason(test));
            }
        }
    }

    private static String getReason(IgnoredTest test) {
        return StringUtils.isNotEmpty((String)test.reason) ? test.reason : "not provided";
    }

    private static void outputTestCase(Test nextTest) {
        if (nextTest instanceof TestCase) {
            FuncTestOut.log(TestCaseKit.getFullName((TestCase)nextTest));
        } else {
            FuncTestOut.log("Unknown Test: " + nextTest);
        }
    }

    private static void outputIgnoredTestCase(Test nextTest, String reason) {
        if (nextTest instanceof TestCase) {
            FuncTestOut.log(TestCaseKit.getFullName((TestCase)nextTest) + " --- REASON: " + reason);
        } else {
            FuncTestOut.log("Unknown Test: " + nextTest + " --- REASON: " + reason);
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private static class IgnoredTest
    implements Test {
        final Test wrapped;
        final String reason;

        public IgnoredTest(Test wrapped, String reason) {
            this.wrapped = wrapped;
            this.reason = reason;
        }

        public int countTestCases() {
            return 0;
        }

        public void run(TestResult result) {
            result.addError(this.wrapped, (Throwable)new IllegalStateException("Test deemed ignored (reason: " + this.reason + ") attempted to be run <" + this.wrapped + ">"));
        }
    }

    public class ParallelEnvironmentTestSuite
    extends EnvironmentTestSuite {
        private JIRAEnvironmentData environmentData;

        @Override
        public void setEnvironmentData(JIRAEnvironmentData environmentData) {
            this.environmentData = environmentData;
            int tenantNo = 0;
            Enumeration enumeration = this.tests();
            while (enumeration.hasMoreElements()) {
                Object testObj = enumeration.nextElement();
                if (!(testObj instanceof EnvironmentAware)) continue;
                ((EnvironmentAware)testObj).setEnvironmentData(new TenantOverridingEnvironmentData("tenant" + ++tenantNo, environmentData));
            }
        }

        public void run(final TestResult result) {
            EnvironmentTestSuite setupTest = new EnvironmentTestSuite(TestDefaultJiraDataFromInstall.class);
            setupTest.setEnvironmentData(this.environmentData);
            this.runTest((Test)setupTest, result);
            ExecutorService testExecutor = Executors.newFixedThreadPool(this.testCount());
            try {
                ArrayList futures = new ArrayList();
                for (final Test test : this.allTests()) {
                    futures.add(testExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            ParallelEnvironmentTestSuite.this.runTest(test, result);
                        }
                    }));
                }
                for (Future future : futures) {
                    future.get();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            finally {
                testExecutor.shutdownNow();
            }
        }
    }

    private static class EnvironmentTestSuite
    extends TestSuite
    implements EnvironmentAware {
        public EnvironmentTestSuite() {
        }

        public EnvironmentTestSuite(Class theClass) {
            super(theClass);
        }

        public EnvironmentTestSuite(String name) {
            super(name);
        }

        @Override
        public void setEnvironmentData(JIRAEnvironmentData environmentData) {
            Enumeration<Test> enumeration = this.tests();
            while (enumeration.hasMoreElements()) {
                Test testObj = enumeration.nextElement();
                if (!(testObj instanceof EnvironmentAware)) continue;
                ((EnvironmentAware)testObj).setEnvironmentData(environmentData);
            }
        }

        public void addTestSuite(Class testClass) {
            this.addTest((Test)new EnvironmentTestSuite(testClass));
        }

        public void addTest(Test test) {
            if (this.isIgnored(test)) {
                super.addTest((Test)new IgnoredTest(test, this.extractIgnoreReason(test)));
            } else {
                super.addTest(test);
            }
        }

        public Enumeration<Test> tests() {
            return IteratorEnumeration.fromIterable(CollectionUtil.filter(this.allTests(), new Predicate<Test>(){

                @Override
                public boolean evaluate(Test input) {
                    return !IgnoredTest.class.isInstance(input);
                }
            }));
        }

        public void runTest(Test test, TestResult result) {
            if (!IgnoredTest.class.isInstance(test)) {
                super.runTest(test, result);
            }
        }

        List<Test> allTests() {
            return CollectionUtil.toList(super.tests());
        }

        List<IgnoredTest> ignoredTests() {
            ArrayList<IgnoredTest> answer = new ArrayList<IgnoredTest>();
            for (Test test : this.allTests()) {
                if (test instanceof IgnoredTest) {
                    answer.add((IgnoredTest)test);
                    continue;
                }
                if (!(test instanceof EnvironmentTestSuite)) continue;
                answer.addAll(((EnvironmentTestSuite)test).ignoredTests());
            }
            return answer;
        }

        private boolean isIgnored(Test test) {
            if (!TestCase.class.isInstance(test)) {
                return false;
            }
            Class<?> testClass = test.getClass();
            Method testMethod = this.getMethod((TestCase)test);
            return testClass.isAnnotationPresent(Ignore.class) || testMethod != null && testMethod.isAnnotationPresent(Ignore.class);
        }

        private String extractIgnoreReason(Test test) {
            TestCase testCase = (TestCase)test;
            return this.getIgnoreAnnotation(testCase).value();
        }

        private Ignore getIgnoreAnnotation(TestCase testCase) {
            Ignore answer = testCase.getClass().getAnnotation(Ignore.class);
            if (answer == null) {
                answer = this.getMethod(testCase).getAnnotation(Ignore.class);
            }
            if (answer == null) {
                throw new IllegalArgumentException("Test case <" + testCase + "> was supposed to be annotated");
            }
            return answer;
        }

        private Method getMethod(TestCase test) {
            return new TestCaseMethodNameDetector(test).resolve();
        }
    }

    private static final class TestPair {
        private final Class<? extends TestCase> klazz;
        private final Test test;

        private TestPair(Class<? extends TestCase> klazz, Test test) {
            this.klazz = klazz;
            this.test = test;
        }

        private Class<? extends TestCase> getKlazz() {
            return this.klazz;
        }

        private Test getTest() {
            return this.test;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

