/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config.mail;

import com.atlassian.jira.functest.config.ConfigException;
import com.atlassian.jira.functest.config.ConfigXmlUtils;
import com.atlassian.jira.functest.config.mail.ConfigMailServer;
import com.atlassian.jira.functest.config.mail.ConfigMailServerManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class DefaultConfigMailServerManager
implements ConfigMailServerManager {
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String ATTRIBUTE_FROM = "from";
    private static final String ATTRIBUTE_PREFIX = "prefix";
    private static final String ATTRIBUTE_SMTP_PORT = "smtpPort";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_SERVERNAME = "servername";
    private static final String ATTRIBUTE_JNDILOCATION = "jndilocation";
    private static final String ATTRIBUTE_USERNAME = "username";
    private static final String ATTRIBUTE_PASSWORD = "password";
    private final Document document;

    public DefaultConfigMailServerManager(Document document) {
        this.document = document;
    }

    @Override
    public List<ConfigMailServer> loadServers() {
        List<Element> configNodes = ConfigXmlUtils.getTopElementsByName(this.document, "MailServer");
        ArrayList<ConfigMailServer> returnList = new ArrayList<ConfigMailServer>(configNodes.size());
        for (Element configNode : configNodes) {
            Long id = ConfigXmlUtils.getLongValue(configNode, ATTRIBUTE_ID);
            if (id == null) {
                throw new ConfigException("Trying to read mail server without an ID.");
            }
            ConfigMailServer currentServer = new ConfigMailServer();
            currentServer.setId(id);
            currentServer.setName(ConfigXmlUtils.getTextValue(configNode, ATTRIBUTE_NAME));
            currentServer.setDescription(ConfigXmlUtils.getTextValue(configNode, ATTRIBUTE_DESCRIPTION));
            currentServer.setFrom(ConfigXmlUtils.getTextValue(configNode, ATTRIBUTE_FROM));
            currentServer.setPrefix(ConfigXmlUtils.getTextValue(configNode, ATTRIBUTE_PREFIX));
            currentServer.setPort(ConfigXmlUtils.getTextValue(configNode, ATTRIBUTE_SMTP_PORT));
            currentServer.setType(ConfigXmlUtils.getTextValue(configNode, ATTRIBUTE_TYPE));
            currentServer.setServerName(ConfigXmlUtils.getTextValue(configNode, ATTRIBUTE_SERVERNAME));
            currentServer.setJndiLocation(ConfigXmlUtils.getTextValue(configNode, ATTRIBUTE_JNDILOCATION));
            currentServer.setUserName(ConfigXmlUtils.getTextValue(configNode, ATTRIBUTE_USERNAME));
            currentServer.setPassword(ConfigXmlUtils.getTextValue(configNode, ATTRIBUTE_PASSWORD));
            returnList.add(currentServer);
        }
        return returnList;
    }

    @Override
    public boolean saveServers(List<ConfigMailServer> newList) {
        List<ConfigMailServer> oldList = this.loadServers();
        HashMap<Long, ConfigMailServer> oldMap = new HashMap<Long, ConfigMailServer>();
        for (ConfigMailServer oldService : oldList) {
            oldMap.put(oldService.getId(), oldService);
        }
        boolean returnValue = false;
        for (ConfigMailServer newServer : newList) {
            ConfigMailServer oldServer = (ConfigMailServer)oldMap.get(newServer.getId());
            if (oldServer == null) {
                throw new ConfigException("Trying to add new mail server to configuration.");
            }
            if (!newServer.equals(oldServer)) {
                throw new ConfigException("Trying to modify old server configuration.");
            }
            oldMap.remove(newServer.getId());
        }
        for (ConfigMailServer deleteServer : oldMap.values()) {
            Element element = this.findServerElement(deleteServer);
            if (element == null) {
                throw new ConfigException("Could not find mail server with id '" + deleteServer.getId() + "'");
            }
            ConfigXmlUtils.removeElement(element);
            returnValue = true;
        }
        return returnValue;
    }

    private Element findServerElement(ConfigMailServer oldServer) {
        return ConfigXmlUtils.getElementByXpath(this.document, String.format("/entity-engine-xml/MailServer[@id='%d']", oldServer.getId()));
    }
}

