/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import com.atlassian.jira.functest.config.ConfigSequence;
import com.atlassian.jira.functest.config.ConfigXmlUtils;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;

public class DefaultConfigSequence
implements ConfigSequence {
    private static final String ELEMENT_SEQUENCE_VALUE_ITEM = "SequenceValueItem";
    private static final String ATTRIB_SEQ_NAME = "seqName";
    private static final String ATTRIB_SEQ_ID = "seqId";
    private Map<String, Long> map = new HashMap<String, Long>();
    private final Document document;

    public DefaultConfigSequence(Document document) {
        this.document = document;
    }

    @Override
    public Long getNextId(String elementType) {
        Long nextId = this.map.get(elementType);
        if (nextId == null) {
            Number number = this.document.numberValueOf("/entity-engine-xml/SequenceValueItem[@seqName='" + elementType + "']/@seqId");
            nextId = number == null || Float.isNaN(number.floatValue()) || Float.isInfinite(number.floatValue()) ? Long.valueOf(10000L) : Long.valueOf(number.longValue() + 1L);
        }
        this.map.put(elementType, nextId + 1L);
        return nextId;
    }

    @Override
    public boolean save() {
        boolean ret = false;
        for (Map.Entry<String, Long> entry : this.map.entrySet()) {
            long l = entry.getValue();
            l = l + 10L - l % 10L;
            Element element = ConfigXmlUtils.getElementByXpath(this.document, "/entity-engine-xml/SequenceValueItem[@seqName='" + entry.getKey() + "']");
            if (element == null) {
                Element newElement = ConfigXmlUtils.createNewElement(this.document.getRootElement(), ELEMENT_SEQUENCE_VALUE_ITEM);
                ConfigXmlUtils.setAttribute(newElement, ATTRIB_SEQ_NAME, (Object)entry.getKey());
                ConfigXmlUtils.setAttribute(newElement, ATTRIB_SEQ_ID, (Object)String.valueOf(l));
                ret = true;
                continue;
            }
            Long value = ConfigXmlUtils.getLongValue(element, ATTRIB_SEQ_ID);
            if (value != null && value == l) continue;
            ConfigXmlUtils.setAttribute(element, ATTRIB_SEQ_ID, (Object)String.valueOf(l));
            ret = true;
        }
        return ret;
    }

    public String toString() {
        return "Sequences: [" + this.map.toString() + "]";
    }
}

