/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import com.atlassian.jira.functest.config.AnnotationFinder;
import com.atlassian.jira.util.dbc.Assertions;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Ignore;

public final class BlankIgnoresFinder {
    private static final Logger log = Logger.getLogger(BlankIgnoresFinder.class);
    private final String suiteName;
    private final Iterable<Class<? extends TestCase>> testsInSuite;
    private final AnnotationFinder<Ignore> annotationFinder;

    public BlankIgnoresFinder(String suiteName, Iterable<Class<? extends TestCase>> testsInSuite) {
        this.suiteName = Assertions.notNull("suiteName", suiteName);
        this.testsInSuite = Assertions.notNull("testsInSuite", testsInSuite);
        this.annotationFinder = AnnotationFinder.newFinder(this.allTests(), Ignore.class);
    }

    public void assertNoIgnoresWithoutReason() {
        ArrayList<String> withReason = new ArrayList<String>();
        ArrayList<String> blankReasons = new ArrayList<String>();
        for (Map.Entry<AnnotatedElement, Ignore> ignoredTest : this.annotationFinder.findAll().entrySet()) {
            if (StringUtils.isBlank((String)ignoredTest.getValue().value())) {
                blankReasons.add(ignoredTest.getKey().toString());
                continue;
            }
            withReason.add(ignoredTest.getKey().toString() + " REASON: " + ignoredTest.getValue().value());
        }
        this.log(withReason);
        if (!blankReasons.isEmpty()) {
            Assert.fail((String)this.errorMsg(blankReasons));
        }
    }

    private void log(List<String> withReasons) {
        log.info((Object)("** Ignored tests in suite '" + this.suiteName + "':"));
        for (String withReason : withReasons) {
            log.info((Object)withReason);
        }
    }

    private String errorMsg(List<String> blankReasons) {
        StringBuilder answer = new StringBuilder("No reasons for @Ignore:\n");
        for (String blankReason : blankReasons) {
            answer.append(blankReason).append("\n");
        }
        return answer.toString();
    }

    private Set<Class<?>> allTests() {
        return (Set)this.testsInSuite;
    }
}

