/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class AnnotationFinder<A extends Annotation> {
    private final Iterable<Class<?>> classes;
    private final Class<A> annotationClass;

    public static <B extends Annotation> AnnotationFinder<B> newFinder(Iterable<Class<?>> classes, Class<B> annotationClass) {
        return new AnnotationFinder<B>(classes, annotationClass);
    }

    public AnnotationFinder(Iterable<Class<?>> classes, Class<A> annotationClass) {
        this.classes = Assertions.notNull("classes", classes);
        this.annotationClass = Assertions.notNull("annotationClass", annotationClass);
    }

    public Map<AnnotatedElement, A> findAll() {
        HashMap answer = Maps.newHashMap();
        for (Class<?> clazz : this.classes) {
            this.checkAndAdd(clazz, answer);
            for (Method method : clazz.getMethods()) {
                this.checkAndAdd(method, answer);
            }
        }
        return answer;
    }

    private void checkAndAdd(AnnotatedElement elem, Map<AnnotatedElement, A> answer) {
        if (elem.isAnnotationPresent(this.annotationClass)) {
            answer.put(elem, elem.getAnnotation(this.annotationClass));
        }
    }
}

