/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.webtests.JIRAWebTest;
import org.apache.oro.text.regex.MalformedPatternException;

public class TestWorkflowConditions
extends JIRAWebTest {
    public TestWorkflowConditions(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    public void testProjectRoleWorkflowCondition() throws MalformedPatternException {
        this.gotoAdmin();
        this.clickLink("workflows");
        this.setFormElement("newWorkflowName", "");
        this.clickLink("copy_jira");
        this.setFormElement("newWorkflowName", "Copy of jira");
        this.submit("Copy");
        this.setFormElement("newWorkflowName", "");
        this.clickLink("steps_live_Copy of jira");
        this.clickLinkWithText("Start Progress");
        this.clickLinkWithText("Add");
        this.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:isuserinprojectrole-condition");
        this.submit("Add");
        this.selectOption("jira.projectrole.id", "Users");
        this.submit("Add");
        this.assertTextSequence(new String[]{"Only users in project role ", "Users", " can execute this transition."});
        this.clickLinkWithText("workflow steps");
        this.clickLinkWithText("Stop Progress");
        this.clickLinkWithText("Add");
        this.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:isuserinprojectrole-condition");
        this.submit("Add");
        this.selectOption("jira.projectrole.id", "Developers");
        this.submit("Add");
        this.assertTextSequence(new String[]{"Only users in project role ", "Developers", " can execute this transition."});
        this.gotoPage("/secure/admin/workflows/EditWorkflowTransitionConditionParams!default.jspa?workflowStep=1&workflowTransition=4&count=2&workflowName=Copy+of+jira&workflowMode=live");
        this.selectOption("jira.projectrole.id", "Administrators");
        this.submit("Update");
        this.assertTextSequence(new String[]{"Only users in project role ", "Administrators", " can execute this transition."});
        this.clickLinkWithText("Delete");
        this.clickLink("project_role_browser");
        this.setFormElement("name", "");
        this.clickLink("view_Administrators");
        this.clickLinkWithText("Start Progress");
        this.assertTextSequence(new String[]{"Only users in project role ", "Administrators", " can execute this transition."});
    }

    public void testGroupCFAddCondition() {
        this.createGroupPickerCF("CF_GP1");
        this.createGroupPickerCF("CF_GP2");
        this.clickLink("workflows");
        this.setFormElement("newWorkflowName", "");
        this.clickLink("copy_jira");
        this.setFormElement("newWorkflowName", "Copy of jira");
        this.submit("Copy");
        this.setFormElement("newWorkflowName", "");
        this.clickLink("steps_live_Copy of jira");
        this.clickLinkWithText("Start Progress");
        this.clickLinkWithText("Add");
        this.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:isuseringroupcf-condition");
        this.submit("Add");
        this.assertTextPresent("<select name=\"groupcf\">");
        this.assertTextPresent("<option value=\"customfield_10000\"");
        this.assertTextPresent("CF_GP1");
        this.assertTextPresent("<option value=\"customfield_10001\"");
        this.assertTextPresent("CF_GP2");
        this.submit("Add");
        this.gotoPage("secure/admin/workflows/EditWorkflowTransitionConditionParams!default.jspa?workflowStep=1&workflowTransition=4&count=2&workflowName=Copy+of+jira&workflowMode=live");
        this.assertTextPresent("<select name=\"groupcf\">");
        this.assertTextPresent("<option value=\"customfield_10000\"");
        this.assertTextPresent("CF_GP1");
        this.assertTextPresent("<option value=\"customfield_10001\"");
        this.assertTextPresent("CF_GP2");
    }

    public void testPermissionCondition() {
        this.gotoAdmin();
        this.clickLink("workflows");
        this.setFormElement("newWorkflowName", "");
        this.clickLink("copy_jira");
        this.setFormElement("newWorkflowName", "Copy of jira");
        this.submit("Copy");
        this.setFormElement("newWorkflowName", "");
        this.clickLink("steps_live_Copy of jira");
        this.clickLinkWithText("Start Progress");
        this.clickLinkWithText("Add");
        this.tester.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:permission-condition");
        this.tester.submit("Add");
        this.tester.selectOption("permission", "Resolve Issues");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Resolve Issues");
        this.tester.gotoPage("/secure/admin/workflows/EditWorkflowTransitionConditionParams!default.jspa?workflowMode=live&workflowStep=1&workflowTransition=4&count=2&workflowName=Copy+of+jira");
        this.tester.assertRadioOptionSelected("permission", "14");
        this.tester.assertTextNotPresent("NullPointerException");
        this.tester.selectOption("permission", "Modify Reporter");
        this.tester.submit("Update");
        this.tester.assertTextNotPresent("Resolve Issues");
        this.tester.assertTextPresent("Modify Reporter");
    }

    private void createGroupPickerCF(String fieldName) {
        this.clickLink("admin_link");
        this.clickLink("view_custom_fields");
        this.clickLink("add_custom_fields");
        this.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:grouppicker");
        this.submit("nextBtn");
        this.setFormElement("fieldName", fieldName);
        this.submit("nextBtn");
        this.submit("Update");
    }
}

