/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryRecord;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class AbstractTestWorkflowMigration
extends JIRAWebTest {
    protected static final String WORKFLOW_FIELD_ID = "Workflow";
    protected static final String STATUS_FIELD_ID = "Status";
    protected static final String CUSTOM_STATUS_1 = "Custom Status 1";
    protected static final String CUSTOM_STATUS_2 = "Custom Status 2";
    protected static final String CUSTOM_STATUS_3 = "Custom Status 3";
    protected static final String CUSTOM_STATUS_4 = "Custom Status 4";
    protected static final String RESOLVED_STATUS_NAME = "Resolved";
    protected static final String CLOSED_STATUS_NAME = "Closed";
    protected static final String IN_PROGRESS_STATUS_NAME = "In Progress";
    private Assertions assertions;

    public AbstractTestWorkflowMigration(String name) {
        super(name);
    }

    protected void assertIssuesWorkflowState(String issueKey, String statusName, Collection availableWorkflowActionNames) throws SAXException {
        this.gotoIssueChangeHistory(issueKey);
        this.assertIssueStatus(statusName);
        this.assertAvailableWorkflowActions(availableWorkflowActionNames);
    }

    private void gotoIssueChangeHistory(String issueKey) {
        if (issueKey == null) {
            throw new IllegalArgumentException("IssueKey should not be null.");
        }
        this.beginAt("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:changehistory-tabpanel");
    }

    private void assertAvailableWorkflowActions(Collection names) throws SAXException {
        WebTable table = this.getDialog().getResponse().getTableWithID("available_workflow_actions");
        if (names != null && !names.isEmpty()) {
            Node[] nodes;
            ArrayList<String> actions = new ArrayList<String>();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@class='ops-cont']//a");
            for (Node node : nodes = xPathLocator.getNodes()) {
                String nodeText;
                Node id = node.getAttributes().getNamedItem("id");
                if (id == null || !(nodeText = DomKit.getCollapsedText(id).trim()).startsWith("action_id")) continue;
                actions.add(DomKit.getCollapsedText(node));
            }
            AbstractTestWorkflowMigration.assertEquals(new HashSet(names), new HashSet(actions));
        } else {
            AbstractTestWorkflowMigration.assertNull((Object)table);
        }
    }

    private void assertIssueStatus(String statusName) {
        this.text.assertTextPresent(new IdLocator(this.tester, "status-val"), statusName);
    }

    protected void assertLastChangeHistoryRecords(String issueKey, ExpectedChangeHistoryRecord expectedChangeHistoryRecord) throws SAXException {
        this.getAssertions().assertLastChangeHistoryRecords(issueKey, expectedChangeHistoryRecord);
    }

    protected void assertLastChangeHistoryRecords(String issueKey, List expectedChangeHistoryRecords) throws SAXException {
        this.getAssertions().assertLastChangeHistoryRecords(issueKey, expectedChangeHistoryRecords);
    }

    protected Assertions getAssertions() {
        if (this.assertions == null) {
            FuncTestHelperFactory funcTestHelperFactory = new FuncTestHelperFactory((TestCase)this, this.getEnvironmentData());
            this.assertions = funcTestHelperFactory.getAssertions();
        }
        return this.assertions;
    }

    protected void assertTwoDimentionalPortlet(Long portletId, String portletTitle, String xAxisHeading, String yAxisHeading, String[] xAxisHeadings, String[][] data, boolean totalsShown) throws SAXException {
        String url = this.getDialog().getResponse().getURL().toString();
        if (!url.endsWith("/secure/Dashboard.jspa")) {
            this.gotoDashboard();
        }
        WebTable table = this.getDialog().getResponse().getTableWithID("portlet_" + portletId);
        AbstractTestWorkflowMigration.assertNotNull((String)("Could not find a 2D portlet with id '" + portletId + "'."), (Object)table);
        String title = table.getCellAsText(0, 0);
        AbstractTestWorkflowMigration.assertNotNull((Object)title);
        title = title.trim();
        AbstractTestWorkflowMigration.assertTrue((boolean)title.startsWith("Statistics Table:"));
        AbstractTestWorkflowMigration.assertTrue((title.indexOf(portletTitle) > -1 ? 1 : 0) != 0);
        String axes = table.getCellAsText(1, 0);
        AbstractTestWorkflowMigration.assertNotNull((Object)axes);
        axes = axes.trim();
        AbstractTestWorkflowMigration.assertTrue((boolean)axes.startsWith(xAxisHeading));
        AbstractTestWorkflowMigration.assertTrue((axes.indexOf(yAxisHeading) > -1 ? 1 : 0) != 0);
        ArrayList<String> xAxisHeadingsList = new ArrayList<String>(Arrays.asList(xAxisHeadings));
        if (totalsShown) {
            xAxisHeadingsList.add("T:");
        }
        int i = 1;
        for (String xHeading : xAxisHeadingsList) {
            String cellText = table.getCellAsText(1, i);
            AbstractTestWorkflowMigration.assertNotNull((Object)cellText);
            AbstractTestWorkflowMigration.assertEquals((String)xHeading, (String)cellText.trim());
            ++i;
        }
        int columnNumber = -1;
        for (int j = 0; j < data.length; ++j) {
            String[] rowData = data[j];
            columnNumber = rowData.length;
            String yHeading = rowData[0];
            for (int columnIndex = 0; columnIndex < rowData.length; ++columnIndex) {
                boolean lastRow;
                String xHeading = columnIndex == 0 ? "Y-Axis Headings" : (columnIndex < rowData.length - 1 ? xAxisHeadings[columnIndex - 1] : "Totals Column");
                String expectedCellText = rowData[columnIndex];
                int rowIndex = j + 2;
                String cellText = table.getCellAsText(rowIndex, columnIndex);
                boolean bl = lastRow = j == data.length - 1;
                if (totalsShown && lastRow && columnIndex == 0) {
                    Assert.assertTrue((String)("Totals row heading in cell with co-ordinates (" + rowIndex + ", " + columnIndex + ") for (" + yHeading + ", " + xHeading + ") does not start with '" + expectedCellText + "'"), (boolean)cellText.trim().startsWith(expectedCellText));
                    continue;
                }
                Assert.assertEquals((String)("Cell text in cell with co-ordinates (" + rowIndex + ", " + columnIndex + ") for (" + yHeading + ", " + xHeading + ") is not equal to '" + expectedCellText + "'"), (String)expectedCellText, (String)cellText.trim());
            }
        }
        int rowNumber = data.length + 2;
        Assert.assertEquals((String)("Ensure the 2D statistics portlet has " + rowNumber + " rows"), (int)rowNumber, (int)table.getRowCount());
        Assert.assertEquals((String)("Ensure the 2D statistics portlet has " + columnNumber + " columns"), (int)columnNumber, (int)table.getColumnCount());
    }
}

