/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.JIRAWebTest;
import junit.framework.AssertionFailedError;

public class TestUserManagement
extends JIRAWebTest {
    public static final String JIRA_DEVELOPERS_GROUP_NAME = "jira-developers";
    public static final String JIRA_ADMINISTRATORS_GROUP_NAME = "jira-administrators";
    public static final String ISO_8859_1_JAVA_CHARS = "!@?[]~'{};&abc123\u00a3 \u00a9 \u00e5 \u00eb \u00f8 \u00e2 \u00ee \u00f4 \u00fd \u00ff \u00fc";
    public static final String ISO_8859_1_HTML_CHARS = "!@?[]~'{};&amp;abc123&pound; &copy; &aring; &euml; &oslash; &acirc; &icirc; &ocirc; &yacute; &yuml; &uuml;";
    public static final String NON_ISO_8859_1_CHARACTERS = "\uffff???";
    private static final String DUPLICATE_GROUP_NAME = "duplicate_group";
    public static final String NON_ISO_8859_1_CHAR = "\u00e4";

    public TestUserManagement(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    public void testUserManagement() {
        this.clickOnAdminPanel("admin.usersgroups", "user_browser");
        if (this.getDialog().isLinkPresentWithText("bob")) {
            this.deleteUser("bob");
        }
        this.createUser();
        this.createValidGroup();
        this.createInvalidUsers();
        this.createInvalidGroups();
        this.addUserToGroup();
        this.loginWithNewUser();
        this.removeUserFromGroup();
        this.setUserPassword();
        this.deleteUser();
        this.loginWithInvalidUser();
    }

    public void testUserBrowserOperationsVisibility() {
        this.toggleExternalUserManagement(false);
        this.clickOnAdminPanel("admin.usersgroups", "user_browser");
        this.assertLinkPresent("editgroups_admin");
        this.assertLinkPresent("editgroups_fred");
        this.assertLinkPresent("projectroles_link_admin");
        this.assertLinkPresent("projectroles_link_fred");
        this.assertLinkPresent("edituser_link_admin");
        this.assertLinkPresent("deleteuser_link_admin");
        this.assertLinkPresent("deleteuser_link_fred");
        this.toggleExternalUserManagement(true);
        this.clickOnAdminPanel("admin.usersgroups", "user_browser");
        this.assertLinkNotPresent("editgroups_admin");
        this.assertLinkNotPresent("editgroups_fred");
        this.assertLinkPresent("projectroles_link_admin");
        this.assertLinkPresent("projectroles_link_fred");
        this.assertLinkNotPresent("edituser_link_admin");
        this.assertLinkNotPresent("deleteuser_link_admin");
        this.assertLinkNotPresent("deleteuser_link_fred");
        this.toggleExternalUserManagement(false);
        this.clickOnAdminPanel("admin.usersgroups", "user_browser");
        this.assertLinkPresent("editgroups_admin");
        this.assertLinkPresent("editgroups_fred");
        this.assertLinkPresent("projectroles_link_admin");
        this.assertLinkPresent("projectroles_link_fred");
        this.assertLinkPresent("edituser_link_admin");
        this.assertLinkPresent("deleteuser_link_admin");
        this.assertLinkPresent("deleteuser_link_fred");
    }

    public void createNonISOUser() {
        this.addUser("\u00e4bob", "bob_password", "Non-ISO-8859-1 Characters", "bob@stuff.com.com");
        this.assertTextPresent("&auml;bob");
        this.deleteUser("\u00e4bob");
    }

    public void createNonISOGroup() {
        this.addGroup("\u00e4bob");
        this.assertTextPresent("\u00e4bob");
        this.removeGroup("\u00e4bob");
    }

    public void createInvalidUsers() {
        TestUserManagement.log("Testing User Creation Validation");
        this.addUser("", "bob_password", "No Username", "bob@stuff.com.com");
        this.assertTextPresent("You must specify a username.");
        this.addUser("Bob", "bob_password", "Capital Letters Used", "bob@stuff.com.com");
        this.assertTextPresent("The username must be all lowercase.");
        this.addUser("bob", "bob_password", "duplicate_user", "bob@stuff.com.com");
        this.addUser("bob", "bob_password", "duplicate_user", "bob@stuff.com.com");
        this.assertTextPresent("A user with that username already exists.");
        this.addUser("bob", "bob_password", "Bob The Builder", "");
        this.assertTextPresent("You must specify an email address.");
        this.addUser("bob", "bob_password", "Bob The Builder", "asf.com");
        this.assertTextPresent("You must specify a valid email address.");
    }

    public void createInvalidGroups() {
        TestUserManagement.log("Testing Group Creation Validation");
        this.createGroup(DUPLICATE_GROUP_NAME);
        this.addGroup(DUPLICATE_GROUP_NAME);
        this.assertTextPresent("A group or user with this name already exists.");
        this.addUser("bob", "bob_password", "duplicate_user", "bob@stuff.com.com");
        this.addGroup("bob");
        this.assertTextPresent("A group or user with this name already exists.");
        this.removeGroup(DUPLICATE_GROUP_NAME);
    }

    private void addGroup(String groupName) {
        this.clickOnAdminPanel("admin.usersgroups", "group_browser");
        this.setFormElement("addName", groupName);
        this.submit();
    }

    public void createUser() {
        this.addUser("bob", "bob_password", "Bob The Builder", "bob@stuff.com.com");
        this.assertTextPresent("User: Bob The Builder");
        this.assertTextPresentBeforeText("Username:", "bob");
        this.assertTextPresentBeforeText("Email", "bob@stuff.com.com");
    }

    public void createValidGroup() {
        this.createGroup("Valid Group");
        this.removeGroup("Valid Group");
    }

    public void addUserToGroup() {
        this.addUserToGroup("bob", JIRA_DEVELOPERS_GROUP_NAME);
        this.addUserToGroup("bob", JIRA_ADMINISTRATORS_GROUP_NAME);
    }

    public void loginWithNewUser() {
        this.logout();
        this.login("bob", "bob_password");
        this.assertRedirectPath(this.getEnvironmentData().getContext() + "/secure/Dashboard.jspa");
        this.logout();
        this.login("admin", "admin");
    }

    public void removeUserFromGroup() {
        this.removeUserFromGroup("bob", JIRA_ADMINISTRATORS_GROUP_NAME);
    }

    public void setUserPassword() {
        String NEW_PASSWORD = "new";
        String DIFFERENT_PASSWORD = "diff";
        this.navigateToUser("bob");
        this.assertTextPresentBeforeText("User:", "Bob The Builder");
        this.clickLinkWithText("Set Password");
        this.assertTextPresentBeforeText("Set Password:", "Bob The Builder");
        this.setFormElement("password", "");
        this.setFormElement("confirm", "");
        this.submit("Update");
        this.assertTextPresent("You must specify a password");
        this.setFormElement("password", "");
        this.setFormElement("confirm", NEW_PASSWORD);
        this.submit("Update");
        this.assertTextPresent("You must specify a password");
        this.setFormElement("password", NEW_PASSWORD);
        this.setFormElement("confirm", "");
        this.submit("Update");
        this.assertTextPresent("The two passwords entered do not match.");
        this.setFormElement("password", NEW_PASSWORD);
        this.setFormElement("confirm", DIFFERENT_PASSWORD);
        this.submit("Update");
        this.assertTextPresent("The two passwords entered do not match.");
        this.setFormElement("password", NEW_PASSWORD);
        this.setFormElement("confirm", NEW_PASSWORD);
        this.submit("Update");
        this.assertTextPresentBeforeText("Successfully set new password for:", "Bob The Builder");
        this.clickButton("ok");
        this.logout();
        this.login("bob", "bob_password");
        this.assertTextPresent("Sorry, your username and password are incorrect - please try again.");
        this.login("bob", NEW_PASSWORD);
        XPathLocator currentUserName = new XPathLocator(this.tester, "//div[@id='header-details-user']/a");
        TestUserManagement.assertEquals((String)"Bob The Builder", (String)currentUserName.getText());
        this.login("admin", "admin");
    }

    public void deleteUser() {
        this.deleteUser("bob");
        this.assertTextPresent("UserBrowser");
        this.assertTextPresent("Displaying users");
        this.addUser("bob", "bob_password", "Bob The Builder", "bob@stuff.com.com");
    }

    public void testDeleteUserProjectLead() {
        this.restoreData("TestUserManagement.xml");
        this.navigateToUser("detkin");
        this.clickLink("deleteuser_link");
        this.assertTextPresent("This user cannot be deleted at this time because there are issues assigned to them, they have reported issues, or they are currently the lead of a project.");
        this.assertTextPresent("Another Project");
        this.assertTextPresent("Project 3");
        this.assertTextPresent("6 projects lead");
    }

    public void testDeleteUserComponentLead() {
        this.restoreData("TestUserManagementComponentLead.xml");
        this.navigateToUser("detkin");
        this.clickLink("deleteuser_link");
        int NUMBER_OF_COMPONENTS = 6;
        int count = 0;
        for (int i = 1; i <= 6; ++i) {
            try {
                this.assertTextPresent("comp " + i);
                ++count;
                continue;
            }
            catch (AssertionFailedError e) {
                // empty catch block
            }
        }
        TestUserManagement.assertTrue((count == 6 ? 1 : 0) != 0);
        this.assertTextPresent("6 components lead");
        this.assertSubmitButtonPresent("Delete");
    }

    public void loginWithInvalidUser() {
        this.logout();
        this.login("bob", null);
        this.assertTextPresent("Sorry, your username and password are incorrect - please try again.");
    }
}

