/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestGroupSelectorPermissions
extends JIRAWebTest {
    public void setUp() {
        super.setUp();
        this.restoreData("GroupSelectorPermissions.xml");
        this.administration.attachments().enable();
    }

    public TestGroupSelectorPermissions(String name) {
        super(name);
    }

    public void testWorkflowPermissions() {
        TestGroupSelectorPermissions.logSection("Testing group permission selector");
        TestGroupSelectorPermissions.log("Testing that 'GroupRadio' selection (helpdesk) can comment, can't attach");
        this.login("helpdesk", "helpdesk");
        this.gotoIssue("NP-1");
        this.assertLinkPresent("comment-issue");
        this.assertLinkNotPresent("attach-file");
        this.assertLinkNotPresent("delete-issue");
        this.assertLinkNotPresent("move-issue");
        TestGroupSelectorPermissions.log("Check that webadmin users cannot do anything");
        this.login("webadmin", "webadmin");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("comment-issue");
        this.assertLinkNotPresent("attach-file");
        this.assertLinkNotPresent("delete-issue");
        this.assertLinkNotPresent("move-issue");
        TestGroupSelectorPermissions.log("Check that unixadmin users cannot do anything");
        this.login("unixadmin", "unixadmin");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("comment-issue");
        this.assertLinkNotPresent("attach-file");
        this.assertLinkNotPresent("delete-issue");
        this.assertLinkNotPresent("move-issue");
        TestGroupSelectorPermissions.log("Testing that regular users can't comment, can't attach");
        this.login("test", "test");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("comment-issue");
        this.assertLinkNotPresent("attach-file");
        this.assertLinkNotPresent("delete-issue");
        this.assertLinkNotPresent("move-issue");
        this.login("dba", "dba");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("comment-issue");
        this.assertLinkNotPresent("attach-file");
        this.assertLinkNotPresent("delete-issue");
        this.assertLinkNotPresent("move-issue");
        TestGroupSelectorPermissions.log("Editing fields: setting GroupRadio (comment perm) to WebAdmin, and 'Assigned Groups' (attach perm) to helpdesk");
        this.gotoIssue("NP-1");
        this.clickLink("editIssue");
        this.assertOptionValuesEqual("customfield_10010", new String[]{"-1", "DBA User Group", "Helpdesk Group", "UNIX Admin Group", "Web Admin Group"});
        this.assertOptionValuesEqual("customfield_10030", new String[]{"-1", "DBA User Group", "Helpdesk Group", "UNIX Admin Group", "Web Admin Group"});
        this.assertOptionValuesEqual("customfield_10040", new String[]{"DBA User Group", "Helpdesk Group", "UNIX Admin Group", "Web Admin Group"});
        this.assertOptionValuesEqual("customfield_10041", new String[]{"-1", "DBA User Group", "Helpdesk Group", "UNIX Admin Group", "Web Admin Group"});
        this.selectOption("customfield_10010", "Helpdesk Group");
        this.checkCheckbox("customfield_10030", "Web Admin Group");
        this.setFormElement("customfield_10040", "DBA User Group");
        this.selectOption("customfield_10041", "UNIX Admin Group");
        this.submit();
        this.assertTextPresentBeforeText("Assigned Groups:", "Helpdesk Group");
        this.assertTextPresentBeforeText("GroupRadio:", "Web Admin Group");
        this.assertTextPresentBeforeText("Multi Checkboxes:", "DBA User Group");
        this.assertTextPresentBeforeText("Select List:", "UNIX Admin Group");
        TestGroupSelectorPermissions.log("Testing that 'GroupRadio' selection (now webadmin) can comment, can't attach");
        this.login("webadmin", "webadmin");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("attach-file");
        this.assertLinkPresent("comment-issue");
        this.assertLinkNotPresent("delete-issue");
        this.assertLinkNotPresent("move-issue");
        TestGroupSelectorPermissions.log("Testing that helpdesk can no longer comment, but can attach");
        this.login("helpdesk", "helpdesk");
        this.gotoIssue("NP-1");
        this.assertLinkPresent("attach-file");
        this.assertLinkNotPresent("comment-issue");
        this.assertLinkNotPresent("delete-issue");
        this.assertLinkNotPresent("move-issue");
        TestGroupSelectorPermissions.log("Check that DBA can delete issues");
        this.login("dba", "dba");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("attach-file");
        this.assertLinkNotPresent("comment-issue");
        this.assertLinkNotPresent("delete-issue");
        this.assertLinkPresent("move-issue");
        TestGroupSelectorPermissions.log("Check that Unix admin can move issues");
        this.login("unixadmin", "unixadmin");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("attach-file");
        this.assertLinkNotPresent("comment-issue");
        this.assertLinkPresent("delete-issue");
        this.assertLinkNotPresent("move-issue");
    }
}

