/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.assertions.TextAssertionsImpl;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.JIRAWebTest;
import org.apache.commons.lang.StringUtils;

public class TestEditUserDetails
extends JIRAWebTest {
    public TestEditUserDetails(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminCannotSetSysAdminPassword() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.navigateToUser("root");
            this.assertLinkNotPresentWithText("Set Password");
            this.assertTextPresent("This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.gotoPage(this.page.addXsrfToken("/secure/admin/user/SetPassword.jspa?name=root&password=root&confirm=root"));
            this.assertTextPresent("Error");
            this.assertions.getJiraFormAssertions().assertFormErrMsg("Must be a System Administrator to reset a System Administrator's password.");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminCannotEditSysAdminDetails() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.navigateToUser("root");
            this.assertLinkNotPresentWithText("Edit Details");
            this.assertTextPresent("This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUser.jspa?editName=root&fullName=rooty&email=root@example.com"));
            this.assertTextPresent("Error");
            this.assertTextPresent("Only System Administrators can edit other System Administrators details.");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSysAdminCanEditSysAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.login("root");
            this.addUser("anothersysadmin");
            this.addUserToGroup("anothersysadmin", "jira-sys-admins");
            this.navigateToUser("anothersysadmin");
            this.assertTextNotPresent("This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.clickLinkWithText("Edit Details");
            this.setFormElement("fullName", "Rooty");
            this.submit("Update");
            this.assertTextPresent("Rooty");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSysAdminCanSetSysAdminPassword() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.login("root");
            this.addUser("anothersysadmin", "something", "Another User", "another@example.com");
            this.addUserToGroup("anothersysadmin", "jira-sys-admins");
            this.navigateToUser("anothersysadmin");
            this.assertTextNotPresent("This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.clickLinkWithText("Set Password");
            this.setFormElement("password", "another");
            this.setFormElement("confirm", "another");
            this.submit("Update");
            this.login("anothersysadmin", "another");
            this.assertTextNotPresent("Sorry, your username and password are incorrect - please try again.");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminCanEditNormalUser() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.navigateToUser("fred");
            this.assertTextNotPresent("This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.clickLinkWithText("Edit Details");
            this.setFormElement("fullName", "Freddy Kruger");
            this.submit("Update");
            this.assertTextPresent("Freddy Kruger");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminCanSetNormalUsersPassword() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.navigateToUser("fred");
            this.assertTextNotPresent("This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.clickLinkWithText("Set Password");
            this.setFormElement("password", "another");
            this.setFormElement("confirm", "another");
            this.submit("Update");
            this.login("fred", "another");
            this.assertTextNotPresent("Sorry, your username and password are incorrect - please try again.");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserNameWithScriptTags() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            String value = "\">xss user<script>";
            String valueEncoded = "&quot;&gt;xss user&lt;script&gt;";
            this.addUser("\">xss user<script>", "password", "\">xss user<script>", "email@email.com");
            this.navigateToUser("\">xss user<script>");
            this.clickLinkWithText("Set Password");
            this.setFormElement("password", "another");
            this.setFormElement("confirm", "another");
            this.submit("Update");
            this.assertTextPresent("&quot;&gt;xss user&lt;script&gt;");
            this.assertTextNotPresent("\">xss user<script>");
            this.login("\">xss user<script>", "another");
            this.assertTextNotPresent("Sorry, your username and password are incorrect - please try again.");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFieldsExceed255() {
        try {
            this.restoreBlankInstance();
            this.addUser(StringUtils.repeat((String)"abcdefgh", (int)32), "password", StringUtils.repeat((String)"ABCDEFGH", (int)32), StringUtils.repeat((String)"x", (int)246) + "@email.com");
            this.assertTextPresent("The username must not exceed 255 characters in length.");
            this.assertTextPresent("The full name must not exceed 255 characters in length.");
            this.assertTextPresent("The email address must not exceed 255 characters in length.");
            this.addUser(StringUtils.repeat((String)"abcdefgh", (int)32).substring(0, 255), "password", StringUtils.repeat((String)"ABCDEFGH", (int)32).substring(0, 255), (StringUtils.repeat((String)"x", (int)246) + "@email.com").substring(0, 255));
            this.assertTextNotPresent("The username must not exceed 255 characters in length.");
            this.assertTextNotPresent("The full name must not exceed 255 characters in length.");
            this.assertTextNotPresent("The email address must not exceed 255 characters in length.");
            this.logout();
            this.login(StringUtils.repeat((String)"abcdefgh", (int)32).substring(0, 255), "password");
            this.assertTextPresent(StringUtils.repeat((String)"ABCDEFGH", (int)32).substring(0, 255));
        }
        finally {
            this.logout();
            this.login("admin", "admin");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAutocompleteIsOff() {
        try {
            TextAssertionsImpl text = new TextAssertionsImpl();
            this.restoreData("TestWithSystemAdmin.xml");
            this.navigateToUser("fred");
            this.clickLinkWithText("Set Password");
            XPathLocator xpathPassword = new XPathLocator(this.tester, "//*[@name=\"password\"]");
            text.assertRegexMatch(xpathPassword.getHTML(), "autocomplete=[ ]*\"off\"[ ]*");
            XPathLocator xpathConfirm = new XPathLocator(this.tester, "//*[@name=\"confirm\"]");
            text.assertRegexMatch(xpathConfirm.getHTML(), "autocomplete=[ ]*\"off\"[ ]*");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }
}

