/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class TestAddUser
extends EmailFuncTestCase {
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testEmptyData() {
        this.navigation.gotoAdminSection("user_browser");
        this.tester.clickLink("add_user");
        this.tester.assertTextPresent("Create New User");
        this.tester.setFormElement("username", "");
        this.tester.setFormElement("fullname", "");
        this.tester.setFormElement("email", "");
        this.tester.submit("Create");
        this.tester.assertTextPresent("Create New User");
        this.tester.assertTextPresent("You must specify a username.");
        this.tester.assertTextPresent("You must specify a full name.");
        this.tester.assertTextPresent("You must specify an email address.");
    }

    public void testCreateDuplicateUser() {
        this.checkSuccessUserCreate();
        this.navigation.gotoAdminSection("user_browser");
        this.tester.clickLink("add_user");
        this.tester.assertTextPresent("Create New User");
        this.tester.setFormElement("username", "user");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "username@email.com");
        this.tester.submit("Create");
        this.tester.assertTextPresent("A user with that username already exists.");
    }

    public void testCreateUserSuccess() {
        this.checkSuccessUserCreate();
    }

    public void testCreateUsernameUppercase() {
        this.navigation.gotoAdminSection("user_browser");
        this.tester.clickLink("add_user");
        this.tester.assertTextPresent("Create New User");
        this.tester.setFormElement("username", "User");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "username@email.com");
        this.tester.submit("Create");
        this.tester.assertTextPresent("The username must be all lowercase.");
    }

    public void testCreateUserInvalidEmail() {
        this.navigation.gotoAdminSection("user_browser");
        this.tester.clickLink("add_user");
        this.tester.assertTextPresent("Create New User");
        this.tester.setFormElement("username", "user");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "username.email.com");
        this.tester.submit("Create");
        this.tester.assertTextPresent("You must specify a valid email address.");
    }

    public void testCreateUserPassword() {
        this.navigation.gotoAdminSection("user_browser");
        this.tester.clickLink("add_user");
        this.tester.assertTextPresent("Create New User");
        this.tester.setFormElement("username", "user");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "username@email.com");
        this.tester.submit("Create");
        this.tester.assertTextPresent("Your password and confirmation password do not match.");
        this.tester.setFormElement("confirm", "confirm");
        this.tester.submit("Create");
        this.tester.assertTextPresent("Your password and confirmation password do not match.");
        this.tester.setFormElement("password", "abc");
        this.tester.setFormElement("confirm", "def");
        this.tester.submit("Create");
        this.tester.assertTextPresent("Your password and confirmation password do not match.");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "password");
        this.tester.submit("Create");
        this.tester.assertTextPresent("User: User Tested");
        String[] userDetails = new String[]{"Username:", "user", "Full Name:", "User Tested", "Email:", "username@email.com"};
        this.text.assertTextSequence(new WebPageLocator(this.tester), userDetails);
    }

    public void testNoPermission() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.tester.gotoPage("http://localhost:8090/jira/secure/admin/user/AddUser!default.jspa");
        this.tester.assertTextPresent("Welcome to jWebTest JIRA installation");
        this.tester.assertTextNotPresent("Project: newproject");
        this.tester.assertTextNotPresent("Add A New Project");
    }

    public void testCreateUserExternalUserConfiguration() {
        this.administration.generalConfiguration().setExternalUserManagement(true);
        this.navigation.gotoAdminSection("user_browser");
        this.tester.assertLinkNotPresent("add_user");
        this.tester.assertTextNotPresent("Add User");
        this.tester.clickLink("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.checkCheckbox("externalUM", "false");
        this.tester.submit("Update");
        this.navigation.gotoAdminSection("user_browser");
        this.tester.assertLinkPresent("add_user");
        this.tester.assertTextPresent("Add User");
        this.tester.clickLink("add_user");
        this.tester.assertTextPresent("Create New User");
        this.tester.setFormElement("username", "user");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "username@email.com");
        this.tester.submit("Create");
        this.tester.assertTextPresent("User: User Tested");
        String[] userDetails = new String[]{"Username:", "user", "Full Name:", "User Tested", "Email:", "username@email.com"};
        this.text.assertTextSequence(new WebPageLocator(this.tester), userDetails);
    }

    public void testCreateUserEmailSent() throws InterruptedException, IOException, MessagingException {
        this.configureAndStartSmtpServer();
        this.checkSuccessUserCreate(true);
        this.flushMailQueueAndWait(1);
        MimeMessage[] mimeMessages = this.getGreenMail().getReceivedMessages();
        TestAddUser.assertEquals((int)1, (int)mimeMessages.length);
        MimeMessage msg = mimeMessages[0];
        String body = msg.getContent().toString();
        TestAddUser.assertTrue((boolean)this.find(body, Pattern.compile("Username: user")));
        TestAddUser.assertTrue((boolean)this.find(body, Pattern.compile("Email: username@email.com")));
        TestAddUser.assertTrue((boolean)this.find(body, Pattern.compile("Full Name: User Tested")));
        TestAddUser.assertTrue((boolean)this.find(body, Pattern.compile("If you follow the link below you will be able to personally set your own password")));
        TestAddUser.assertTrue((boolean)this.find(body, Pattern.compile("secure/ResetPassword!default.jspa\\?os_username=user&token=")));
        TestAddUser.assertFalse((boolean)this.find(body, Pattern.compile("evilwoman")));
    }

    private void checkSuccessUserCreate() {
        this.checkSuccessUserCreate(false);
    }

    private void checkSuccessUserCreate(boolean sendEmail) {
        this.navigation.gotoAdminSection("user_browser");
        this.tester.clickLink("add_user");
        this.tester.assertTextPresent("Create New User");
        this.tester.setFormElement("username", "user");
        this.tester.setFormElement("fullname", "User Tested");
        this.tester.setFormElement("email", "username@email.com");
        this.tester.setFormElement("password", "evilwoman");
        this.tester.setFormElement("confirm", "evilwoman");
        if (sendEmail) {
            this.tester.checkCheckbox("sendEmail", "true");
        }
        this.tester.submit("Create");
        this.tester.assertTextPresent("User: User Tested");
        String[] userDetails = new String[]{"Username:", "user", "Full Name:", "User Tested", "Email:", "username@email.com"};
        this.text.assertTextSequence(new WebPageLocator(this.tester), userDetails);
    }

    private boolean find(String s, Pattern pattern) {
        return pattern.matcher(s).find();
    }
}

