/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryList;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import org.xml.sax.SAXException;

public class TestDeleteWorklog
extends FuncTestCase {
    private static final String ADMIN_COMMENT = "Admin does some work.";
    private static final String HSP_1 = "HSP-1";

    public TestDeleteWorklog(String name) {
        this.setName(name);
    }

    public void setUpTest() {
        this.administration.restoreData("TestUpdateWorklog.xml");
    }

    public void testMandatoryFields() {
        this.navigation.issue().viewIssue(HSP_1);
        this.clickWorkLogLink();
        this.getTester().clickLink("delete_worklog_10000");
        this.getTester().setFormElement("newEstimate", "");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().submit();
        this.text.assertTextPresent("You must supply a valid new estimate.");
    }

    public void testInvalidFormattedDurationFields() {
        this.navigation.issue().viewIssue(HSP_1);
        this.clickWorkLogLink();
        this.getTester().clickLink("delete_worklog_10000");
        this.getTester().setFormElement("newEstimate", "Six Days, Seven Nights");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().submit();
        this.text.assertTextPresent("Invalid new estimate entered.");
    }

    public void testInsufficientSecurityLevelCantDelete() {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLinkWithText("Work Log");
        this.getTester().clickLink("edit_worklog_10000");
        this.getTester().selectOption("commentLevel", "jira-administrators");
        this.getTester().submit("Log");
        this.navigation.logout();
        this.navigation.login("mel", "mel");
        this.getTester().gotoPage("/secure/DeleteWorklog!default.jspa?id=10000&worklogId=10000");
        this.text.assertTextPresent("Access Denied");
        this.text.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
    }

    public void testNoPermissionCantDelete() {
        this.administration.permissionSchemes().defaultScheme();
        this.getTester().clickLink("del_perm_43_");
        this.getTester().submit("Delete");
        this.navigation.logout();
        this.navigation.login("mel", "mel");
        this.getTester().gotoPage("/secure/DeleteWorklog!default.jspa?id=10000&worklogId=10000");
        this.text.assertTextPresent("Access Denied");
        this.text.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
    }

    public void testDeleteNonExistantWorklog() {
        this.getTester().gotoPage("/secure/DeleteWorklog!default.jspa?id=10000&worklogId=OMGROFLCOPTER");
        this.text.assertTextPresent("Delete Worklog");
        this.assertions.getJiraFormAssertions().assertFormErrMsg("Cannot retrieve worklog with id='null' for update.");
    }

    public void testDeleteChangeHistory() throws SAXException {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLinkWithText("Work Log");
        this.getTester().clickLink("delete_worklog_10000");
        this.getTester().submit("Delete");
        this.assertAdminWorklogDeleted();
        this.getTester().clickLinkWithText("History");
        ChangeHistoryList expectedList = new ChangeHistoryList();
        expectedList.addChangeSet("Administrator").add("Time Spent", "6 days [ 518400 ]", "5 days [ 432000 ]").add("Remaining Estimate", "3 weeks, 1 day [ 1900800 ]", "3 weeks, 2 days [ 1987200 ]").add("Worklog Id", "10000 [ 10000 ]", "").add("Worklog Time Spent", "1 day [ 86400 ]", "");
        ChangeHistoryList list = this.parse.issue().parseChangeHistory();
        list.assertContainsSomeOf(expectedList);
    }

    public void testDeleteAndAutoAdjustRemainingEstimate() {
        this.navigation.issue().viewIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.getTester().clickLink("delete_worklog_10000");
        this.getTester().checkCheckbox("adjustEstimate", "auto");
        this.getTester().submit("Delete");
        this.assertTextSequence(new String[]{"3 weeks", "5 days"});
        this.assertAdminWorklogDeleted();
    }

    public void testDeleteAndRetainRemainingEstimate() {
        this.navigation.issue().viewIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.getTester().clickLink("delete_worklog_10000");
        this.getTester().checkCheckbox("adjustEstimate", "leave");
        this.getTester().submit("Delete");
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "5 days"});
        this.assertAdminWorklogDeleted();
    }

    public void testDeleteAndSpecifyNewEstimate() {
        this.navigation.issue().viewIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.getTester().clickLink("delete_worklog_10000");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().setFormElement("newEstimate", "8w");
        this.getTester().submit("Delete");
        this.assertTextSequence(new String[]{"8 weeks", "5 days"});
        this.assertAdminWorklogDeleted();
    }

    private void assertAdminWorklogDeleted() {
        this.text.assertTextNotPresent(ADMIN_COMMENT);
        this.text.assertTextNotPresent("19/Jun/07 06:09 PM");
        this.text.assertTextNotPresent("title=\"Created: 19/Jun/07 06:10 PM\"");
        this.getTester().assertLinkNotPresent("delete_worklog_10000");
        this.getTester().assertLinkNotPresent("edit_worklog_10000");
    }

    private void clickWorkLogLink() {
        if (this.page.isLinkPresentWithExactText("Work Log")) {
            this.getTester().clickLinkWithText("Work Log");
        }
    }

    public void testManuallyIncreaseEstimate() {
        this.navigation.issue().viewIssue(HSP_1);
        this.text.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated:", "4w", "Remaining:", "3w 1d", "Logged:", "6d");
        this.getTester().clickLinkWithText("Work Log");
        this.getTester().clickLink("delete_worklog_10002");
        this.getTester().checkCheckbox("adjustEstimate", "manual");
        this.getTester().submit("Delete");
        this.text.assertTextPresent("You must supply a valid amount of time to adjust the estimate by.");
        this.getTester().setFormElement("adjustmentAmount", "heaps");
        this.getTester().submit("Delete");
        this.text.assertTextPresent("Invalid time entered for adjusting the estimate.");
        this.getTester().setFormElement("adjustmentAmount", "2d");
        this.getTester().submit("Delete");
        this.text.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated:", "4w", "Remaining:", "3w 3d", "Logged:", "3d");
    }

    private void assertTextSequence(String[] strings) {
        this.oldway_consider_porting.assertTextSequence(strings);
    }
}

