/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.XPathLocator;

public class TestWorklogAndTimeTracking
extends FuncTestCase {
    private static final String ISSUE_WITH_WORK = "HSP-1";
    private static final String NO_WORK_ISSUE = "HSP-2";
    private static final String TIMETRACKING = "timetracking";
    private static final String TIMETRACKING_ORIGINALESTIMATE = "timetracking_originalestimate";
    private static final String TIMETRACKING_REMAININGESTIMATE = "timetracking_remainingestimate";
    private static final String WORKLOG_ACTIVATE = "worklog_activate";
    private static final String WORKLOG_TIME_LOGGED = "worklog_timeLogged";
    private static final String WORKLOG_TIMETRACKINGCONTAINER = "worklog-timetrackingcontainer";
    private static final String WORKLOG_LOGWORKCONTAINER = "worklog-logworkcontainer";
    private static final String SUMMARY = "summary";

    protected void setUpTest() {
        this.administration.restoreData("TestWorklogAndTimeTracking.xml");
        this.administration.fieldConfigurations().defaultFieldConfiguration().requireField("Time Tracking");
    }

    public void testValidationOnCreateInModernMode() throws Exception {
        this.enableModernMode();
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement(SUMMARY, "The summary of this new issue");
        this.tester.setFormElement(TIMETRACKING_REMAININGESTIMATE, "5h");
        this.tester.setFormElement(WORKLOG_ACTIVATE, "true");
        this.tester.setFormElement(WORKLOG_TIME_LOGGED, "2h");
        this.tester.submit();
        this.assertions.getJiraFormAssertions().assertAuiFieldErrMsg("Original Estimate is required.");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement(SUMMARY, "The summary of this new issue");
        this.tester.setFormElement(TIMETRACKING_ORIGINALESTIMATE, "4h");
        this.tester.setFormElement(TIMETRACKING_REMAININGESTIMATE, "5h");
        this.tester.setFormElement(WORKLOG_ACTIVATE, "true");
        this.tester.setFormElement(WORKLOG_TIME_LOGGED, "2h");
        this.tester.submit();
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("4h", "2h", "2h");
        this.administration.fieldConfigurations().defaultFieldConfiguration().optionalField("Time Tracking");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement(SUMMARY, "The summary of this new issue");
        this.tester.setFormElement(TIMETRACKING_REMAININGESTIMATE, "5h");
        this.tester.setFormElement(WORKLOG_ACTIVATE, "true");
        this.tester.setFormElement(WORKLOG_TIME_LOGGED, "2h");
        this.tester.submit();
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("Not Specified", "0m", "2h");
    }

    public void testValidationOfInputsTogetherLegacyModeWorkStarted() throws Exception {
        this.editTimeAndLogWork(ISSUE_WITH_WORK, "xxxx", true, "yyyy");
        this.assertFormState(true, "4h", "yyyy", "Invalid time duration entered.", "The original estimate specified is not valid.");
        this.editTimeAndLogWork(ISSUE_WITH_WORK, "", false, "yyyy");
        this.assertFormState(false, "", "", "Time Tracking is required.", "Invalid time duration entered.");
        this.editTimeAndLogWork(ISSUE_WITH_WORK, "xxxx", true, "30m");
        this.text.assertTextNotPresent("The remaining estimate specified is not valid.");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("6h", "3h 30m", "2h 30m");
        this.editTimeAndLogWork(ISSUE_WITH_WORK, "4h 15m", false, "yyyy");
        this.text.assertTextNotPresent("Invalid time duration entered.");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("6h", "4h 15m", "2h 30m");
        this.editTimeAndLogWork(ISSUE_WITH_WORK, "7m", true, "8m");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("6h", "4h 7m", "2h 38m");
        this.editTimeAndLogWork(ISSUE_WITH_WORK, "5h", false, "3m");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("6h", "5h", "2h 38m");
    }

    public void testValidationOfInputsTogetherLegacyModeWorkNotStarted() throws Exception {
        this.administration.fieldConfigurations().defaultFieldConfiguration().requireField("Log Work");
        this.editTimeAndLogWork(NO_WORK_ISSUE, "xxxx", "");
        this.assertFormState("xxxx", "", "You must indicate the time spent working", "The original estimate specified is not valid.");
        this.editTimeAndLogWork(NO_WORK_ISSUE, "4h", "xxxx");
        this.assertFormState("4h", "xxxx", "Invalid time duration entered.");
        this.editTimeAndLogWork(NO_WORK_ISSUE, "8h", "1h");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("8h", "7h", "1h");
    }

    public void testValidationOfInputsTogetherModernModeWorkStarted() throws Exception {
        this.enableModernMode();
        this.editTimeAndLogWork(ISSUE_WITH_WORK, "zzzz", "xxxx", true, "yyyy");
        this.assertFormStateModernMode(true, "zzzz", "4h", "yyyy", new String[]{"Invalid time duration entered.", "The original estimate specified is not valid."}, new String[]{"The remaining estimate specified is not valid."});
        this.editTimeAndLogWork(ISSUE_WITH_WORK, "", "xxxx", false, "ffff");
        this.assertFormStateModernMode(false, "", "xxxx", "", new String[]{"The remaining estimate specified is not valid."}, new String[]{"Original Estimate is required.", "Invalid time duration entered."});
        this.editTimeAndLogWork(ISSUE_WITH_WORK, "", "1h", true, "30m");
        this.assertFormStateModernMode(true, "", "4h", "30m", new String[]{"Original Estimate is required."}, new String[0]);
        this.editTimeAndLogWork(ISSUE_WITH_WORK, "8h", "xxxx", true, "30m");
        this.text.assertTextNotPresent("The remaining estimate specified is not valid.");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("8h", "3h 30m", "2h 30m");
        this.editTimeAndLogWork(ISSUE_WITH_WORK, "9h", "4h", false, "xxxx");
        this.text.assertTextNotPresent("Invalid time duration entered.");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("9h", "4h", "2h 30m");
        this.editTimeAndLogWork(ISSUE_WITH_WORK, "10h", "9h", true, "15m");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("10h", "3h 45m", "2h 45m");
        this.editTimeAndLogWork(ISSUE_WITH_WORK, "11h", "7h", false, "6m");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("11h", "7h", "2h 45m");
    }

    public void testInitialRenderingOfTimeTrackingAndLogWorkFields() throws Exception {
        this._testLegacyModeWorkStartedLogWorkPresent();
        this._testLegacyModeWorkStartedLogWorkRequired();
        this._testLegacyModeWorkStartedLogWorkNotPresent();
        this._testLegacyModeWorkNotStartedLogWorkPresent();
        this._testLegacyModeWorkNotStartedLogWorkNotPresent();
        this.enableModernMode();
        this._testModernModeWorkNotStartedLogWorkPresent();
        this._testModernModeWorkNotStartedLogWorkRequired();
        this._testModernModeWorkNotStartedLogWorkNotPresent();
        this._testModernModeWorkStartedLogWorkPresent();
        this._testModernModeWorkStartedLogWorkNotPresent();
    }

    private void _testLegacyModeWorkStartedLogWorkPresent() {
        this.navigation.issue().gotoEditIssue(ISSUE_WITH_WORK);
        this.tester.assertElementPresent(TIMETRACKING);
        this.assertLabelText(TIMETRACKING, "Remaining Estimate");
        this.assertContainerVisible(WORKLOG_TIMETRACKINGCONTAINER);
        this.tester.assertCheckboxNotSelected(WORKLOG_ACTIVATE);
        this.assertContainerHidden(WORKLOG_LOGWORKCONTAINER);
    }

    private void _testLegacyModeWorkStartedLogWorkRequired() {
        this.administration.fieldConfigurations().defaultFieldConfiguration().requireField("Log Work");
        this.navigation.issue().gotoEditIssue(ISSUE_WITH_WORK);
        this.tester.assertElementNotPresent(TIMETRACKING);
        this.assertContainerNotPresent(WORKLOG_TIMETRACKINGCONTAINER);
        this.assertCheckboxNotPresent(WORKLOG_ACTIVATE);
        this.assertContainerVisible(WORKLOG_LOGWORKCONTAINER);
        this.administration.fieldConfigurations().defaultFieldConfiguration().optionalField("Log Work");
    }

    private void _testLegacyModeWorkStartedLogWorkNotPresent() {
        this.administration.fieldConfigurations().defaultFieldConfiguration().getScreens("Log Work").removeFieldFromScreen("Default Screen");
        this.navigation.issue().gotoEditIssue(ISSUE_WITH_WORK);
        this.tester.assertElementPresent(TIMETRACKING);
        this.assertLabelText(TIMETRACKING, "Remaining Estimate");
        this.assertContainerNotPresent(WORKLOG_TIMETRACKINGCONTAINER);
        this.assertCheckboxNotPresent(WORKLOG_ACTIVATE);
        this.assertContainerNotPresent(WORKLOG_LOGWORKCONTAINER);
    }

    private void _testLegacyModeWorkNotStartedLogWorkPresent() {
        this.administration.fieldConfigurations().defaultFieldConfiguration().getScreens("Log Work").addFieldToScreen("Default Screen");
        this.navigation.issue().gotoEditIssue(NO_WORK_ISSUE);
        this.tester.assertElementPresent(TIMETRACKING);
        this.assertLabelText(TIMETRACKING, "Original Estimate");
        this.assertContainerNotPresent(WORKLOG_TIMETRACKINGCONTAINER);
        this.assertCheckboxNotPresent(WORKLOG_ACTIVATE);
        this.assertContainerVisible(WORKLOG_LOGWORKCONTAINER);
    }

    private void _testLegacyModeWorkNotStartedLogWorkNotPresent() {
        this.administration.fieldConfigurations().defaultFieldConfiguration().getScreens("Log Work").removeFieldFromScreen("Default Screen");
        this.navigation.issue().gotoEditIssue(NO_WORK_ISSUE);
        this.tester.assertElementPresent(TIMETRACKING);
        this.assertLabelText(TIMETRACKING, "Original Estimate");
        this.assertContainerNotPresent(WORKLOG_TIMETRACKINGCONTAINER);
        this.assertCheckboxNotPresent(WORKLOG_ACTIVATE);
        this.assertContainerNotPresent(WORKLOG_LOGWORKCONTAINER);
    }

    private void _testModernModeWorkNotStartedLogWorkPresent() {
        this.administration.fieldConfigurations().defaultFieldConfiguration().getScreens("Log Work").addFieldToScreen("Default Screen");
        this.navigation.issue().gotoEditIssue(NO_WORK_ISSUE);
        this.tester.assertElementPresent(TIMETRACKING_ORIGINALESTIMATE);
        this.assertLabelText(TIMETRACKING_ORIGINALESTIMATE, "Original Estimate");
        this.tester.assertElementPresent(TIMETRACKING_REMAININGESTIMATE);
        this.assertLabelText(TIMETRACKING_REMAININGESTIMATE, "Remaining Estimate");
        this.assertContainerVisible(WORKLOG_TIMETRACKINGCONTAINER);
        this.tester.assertCheckboxNotSelected(WORKLOG_ACTIVATE);
        this.assertContainerHidden(WORKLOG_LOGWORKCONTAINER);
    }

    private void _testModernModeWorkNotStartedLogWorkRequired() {
        this.administration.fieldConfigurations().defaultFieldConfiguration().requireField("Log Work");
        this.navigation.issue().gotoEditIssue(NO_WORK_ISSUE);
        this.tester.assertElementPresent(TIMETRACKING_ORIGINALESTIMATE);
        this.assertLabelText(TIMETRACKING_ORIGINALESTIMATE, "Original Estimate");
        this.tester.assertElementNotPresent(TIMETRACKING_REMAININGESTIMATE);
        this.assertContainerNotPresent(WORKLOG_TIMETRACKINGCONTAINER);
        this.assertCheckboxNotPresent(WORKLOG_ACTIVATE);
        this.assertContainerVisible(WORKLOG_LOGWORKCONTAINER);
        this.administration.fieldConfigurations().defaultFieldConfiguration().optionalField("Log Work");
    }

    private void _testModernModeWorkNotStartedLogWorkNotPresent() {
        this.administration.fieldConfigurations().defaultFieldConfiguration().getScreens("Log Work").removeFieldFromScreen("Default Screen");
        this.navigation.issue().gotoEditIssue(NO_WORK_ISSUE);
        this.tester.assertElementPresent(TIMETRACKING_ORIGINALESTIMATE);
        this.assertLabelText(TIMETRACKING_ORIGINALESTIMATE, "Original Estimate");
        this.tester.assertElementPresent(TIMETRACKING_REMAININGESTIMATE);
        this.assertLabelText(TIMETRACKING_REMAININGESTIMATE, "Remaining Estimate");
        this.assertContainerNotPresent(WORKLOG_TIMETRACKINGCONTAINER);
        this.assertCheckboxNotPresent(WORKLOG_ACTIVATE);
        this.assertContainerNotPresent(WORKLOG_LOGWORKCONTAINER);
    }

    private void _testModernModeWorkStartedLogWorkPresent() {
        this.administration.fieldConfigurations().defaultFieldConfiguration().getScreens("Log Work").addFieldToScreen("Default Screen");
        this.navigation.issue().gotoEditIssue(ISSUE_WITH_WORK);
        this.tester.assertElementPresent(TIMETRACKING_ORIGINALESTIMATE);
        this.assertLabelText(TIMETRACKING_ORIGINALESTIMATE, "Original Estimate");
        this.tester.assertElementPresent(TIMETRACKING_REMAININGESTIMATE);
        this.assertLabelText(TIMETRACKING_REMAININGESTIMATE, "Remaining Estimate");
        this.assertContainerVisible(WORKLOG_TIMETRACKINGCONTAINER);
        this.tester.assertCheckboxNotSelected(WORKLOG_ACTIVATE);
        this.assertContainerHidden(WORKLOG_LOGWORKCONTAINER);
    }

    private void _testModernModeWorkStartedLogWorkNotPresent() {
        this.administration.fieldConfigurations().defaultFieldConfiguration().getScreens("Log Work").removeFieldFromScreen("Default Screen");
        this.navigation.issue().gotoEditIssue(ISSUE_WITH_WORK);
        this.tester.assertElementPresent(TIMETRACKING_ORIGINALESTIMATE);
        this.assertLabelText(TIMETRACKING_ORIGINALESTIMATE, "Original Estimate");
        this.tester.assertElementPresent(TIMETRACKING_REMAININGESTIMATE);
        this.assertLabelText(TIMETRACKING_REMAININGESTIMATE, "Remaining Estimate");
        this.assertContainerNotPresent(WORKLOG_TIMETRACKINGCONTAINER);
        this.assertCheckboxNotPresent(WORKLOG_ACTIVATE);
        this.assertContainerNotPresent(WORKLOG_LOGWORKCONTAINER);
    }

    private void assertFormStateModernMode(boolean shouldLogWorkBeChecked, String expectedOriginalEstimate, String expectedRemainingEstimate, String expectedTimeLogged, String[] presentErrors, String[] absentErrors) {
        for (String error : presentErrors) {
            this.assertions.getJiraFormAssertions().assertAuiFieldErrMsg(error);
        }
        for (String error : absentErrors) {
            this.text.assertTextNotPresent(error);
        }
        if (shouldLogWorkBeChecked) {
            this.assertCheckboxChecked(WORKLOG_ACTIVATE);
        } else {
            this.tester.assertCheckboxNotSelected(WORKLOG_ACTIVATE);
        }
        this.tester.assertFormElementEquals(TIMETRACKING_ORIGINALESTIMATE, expectedOriginalEstimate);
        this.tester.assertFormElementEquals(TIMETRACKING_REMAININGESTIMATE, expectedRemainingEstimate);
        this.tester.assertFormElementEquals(WORKLOG_TIME_LOGGED, expectedTimeLogged);
    }

    private void assertFormState(boolean shouldLogWorkBeChecked, String expectedRemainingEstimate, String expectedTimeLogged, String presentError, String absentError) {
        this.assertions.getJiraFormAssertions().assertAuiFieldErrMsg(presentError);
        this.text.assertTextNotPresent(absentError);
        if (shouldLogWorkBeChecked) {
            this.assertCheckboxChecked(WORKLOG_ACTIVATE);
        } else {
            this.tester.assertCheckboxNotSelected(WORKLOG_ACTIVATE);
        }
        this.tester.assertFormElementEquals(TIMETRACKING, expectedRemainingEstimate);
        this.tester.assertFormElementEquals(WORKLOG_TIME_LOGGED, expectedTimeLogged);
    }

    private void assertFormState(String expectedOriginalEstimate, String expectedTimeLogged, String ... presentErrors) {
        this.tester.assertFormElementEquals(TIMETRACKING, expectedOriginalEstimate);
        this.tester.assertFormElementEquals(WORKLOG_TIME_LOGGED, expectedTimeLogged);
        for (String error : presentErrors) {
            this.assertions.getJiraFormAssertions().assertAuiFieldErrMsg(error);
        }
    }

    private void editTimeAndLogWork(String issueKey, String remainingEstimate, boolean activateLogWork, String timeLogged) {
        this.navigation.issue().gotoEditIssue(issueKey);
        this.tester.setFormElement(TIMETRACKING, remainingEstimate);
        if (activateLogWork) {
            this.tester.setFormElement(WORKLOG_ACTIVATE, "true");
        }
        this.tester.setFormElement(WORKLOG_TIME_LOGGED, timeLogged);
        this.tester.submit();
    }

    private void editTimeAndLogWork(String issueKey, String originalEstimate, String remainingEstimate, boolean activateLogWork, String timeLogged) {
        this.navigation.issue().gotoEditIssue(issueKey);
        this.tester.setFormElement(TIMETRACKING_ORIGINALESTIMATE, originalEstimate);
        this.tester.setFormElement(TIMETRACKING_REMAININGESTIMATE, remainingEstimate);
        if (activateLogWork) {
            this.tester.setFormElement(WORKLOG_ACTIVATE, "true");
        }
        this.tester.setFormElement(WORKLOG_TIME_LOGGED, timeLogged);
        this.tester.submit();
    }

    private void editTimeAndLogWork(String issueKey, String originalEstimate, String timeLogged) {
        this.navigation.issue().gotoEditIssue(issueKey);
        this.tester.setFormElement(TIMETRACKING, originalEstimate);
        this.tester.setFormElement(WORKLOG_TIME_LOGGED, timeLogged);
        this.tester.submit();
    }

    private void assertLabelText(String labelField, String labelText) {
        this.text.assertTextPresent(new XPathLocator(this.tester, String.format("//label[@for='%s']", labelField)), labelText);
    }

    private void assertCheckboxNotPresent(String checkboxName) {
        this.assertions.assertNodeDoesNotExist(String.format("//input[@type='checkbox' and @name='%s']", checkboxName));
    }

    private void assertContainerNotPresent(String containerId) {
        this.assertions.assertNodeDoesNotExist(String.format("//div[@id='%s']", containerId));
    }

    private void assertCheckboxChecked(String checkboxName) {
        this.assertions.assertNodeExists(String.format("//input[@type='checkbox' and @name='%s' and @checked='checked']", checkboxName));
    }

    private void assertContainerVisible(String containerId) {
        this.assertions.assertNodeExists(String.format("//div[@id='%s' and not(@class)]", containerId));
    }

    private void assertContainerHidden(String containerId) {
        this.assertions.assertNodeExists(String.format("//div[@id='%s' and @class='hidden']", containerId));
    }

    private void enableModernMode() {
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable(TimeTracking.Mode.MODERN);
    }
}

