/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import org.xml.sax.SAXException;

public class TestSubTaskQuickCreation
extends FuncTestCase {
    private static final String ISSUE_PARENT = "HSP-6";
    private static final String SUB_TASKS_TABLE_ID = "issuetable";

    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestTimeTrackingAggregates.xml");
    }

    public void testSubTaskDisplayOptions() throws Exception {
        this.navigation.issue().resolveIssue("HSP-7", "Fixed", "");
        this.navigation.issue().gotoIssue(ISSUE_PARENT);
        this.text.assertTextSequence(this.locator.table(SUB_TASKS_TABLE_ID), "sub 1", "Resolved", "sub 2", "Open");
        this.tester.clickLink("subtasks-show-open");
        this.text.assertTextSequence(this.locator.table(SUB_TASKS_TABLE_ID), "sub 2", "Open");
        this.text.assertTextNotPresent(this.locator.table(SUB_TASKS_TABLE_ID), "sub 1");
        this.text.assertTextNotPresent(this.locator.table(SUB_TASKS_TABLE_ID), "Resolved");
        this.tester.clickLink("subtasks-show-all");
        this.text.assertTextSequence(this.locator.table(SUB_TASKS_TABLE_ID), "sub 1", "Resolved", "sub 2", "Open");
    }

    public void testFormHasVerticalLayout() throws SAXException {
        this.navigation.issue().gotoIssue(ISSUE_PARENT);
        this.assertVerticalFormPresent();
        this.assertFormFieldsPresent();
        this.assertOriginalEstimateFieldIsPresent();
    }

    public void testOriginalEstimateVisibility() throws Exception {
        this.navigation.issue().gotoIssue(ISSUE_PARENT);
        this.assertVerticalFormPresent();
        this.assertFormFieldsPresent();
        this.assertOriginalEstimateFieldIsPresent();
        this.administration.timeTracking().disable();
        this.navigation.issue().gotoIssue(ISSUE_PARENT);
        this.assertVerticalFormPresent();
        this.assertFormFieldsPresent();
        this.assertOriginalEstimateFieldIsNotPresent();
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.navigation.issue().gotoIssue(ISSUE_PARENT);
        this.assertVerticalFormPresent();
        this.assertFormFieldsPresent();
        this.assertOriginalEstimateFieldIsPresent();
    }

    public void testCreateSubTask() throws Exception {
        this.navigation.issue().gotoIssue(ISSUE_PARENT);
        this.tester.setFormElement("summary", "New test sub-task");
        this.tester.selectOption("issuetype", "Sub-task");
        this.tester.selectOption("assignee", "Fred Normal");
        this.tester.setFormElement("timetracking", "8h");
        this.tester.clickButton("stqc_submit");
        this.assertVerticalFormPresent();
        this.assertFormFieldsPresent();
        this.assertOriginalEstimateFieldIsPresent();
        this.text.assertTextSequence(this.locator.table(SUB_TASKS_TABLE_ID), "New test sub-task", "Open", "Fred Normal", "0%");
        this.navigation.issue().gotoIssue("HSP-21");
        this.text.assertTextPresent(this.locator.id("project-name-val"), "homosapien");
        this.text.assertTextPresent(this.locator.id("parent_issue_summary"), "HSP-6 parent 1");
        this.text.assertTextPresent(this.locator.id("issue_header_summary"), "New test sub-task");
    }

    public void testCreateSubTaskNotVisibleWithoutPermission() {
        this.navigation.issue().viewIssue(ISSUE_PARENT);
        this.tester.assertLinkPresent("stqc_show");
        this.administration.permissionSchemes().defaultScheme().removePermission(11, "jira-users");
        this.navigation.issue().viewIssue(ISSUE_PARENT);
        this.tester.assertLinkNotPresent("stqc_show");
    }

    private void assertVerticalFormPresent() {
        this.tester.assertElementPresent("subtask_container_vertical");
        this.text.assertTextPresent(this.locator.id("stqc_form_header"), "Create Sub-Task");
    }

    private void assertFormFieldsPresent() {
        this.tester.assertTextPresent("Summary:");
        this.tester.assertTextPresent("Issue Type:");
        this.tester.assertTextPresent("Assignee:");
        this.tester.assertFormElementPresent("summary");
        this.tester.assertFormElementPresent("issuetype");
        this.tester.assertFormElementPresent("assignee");
    }

    private void assertOriginalEstimateFieldIsPresent() {
        this.tester.assertTextPresent("Original Estimate:");
        this.tester.assertFormElementPresent("timetracking");
    }

    private void assertOriginalEstimateFieldIsNotPresent() {
        this.tester.assertTextNotPresent("Original Estimate:");
        this.tester.assertFormElementNotPresent("timetracking");
    }
}

