/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.webtests.JIRAWebTest;

public class TestSubTaskActions
extends JIRAWebTest {
    public TestSubTaskActions(String name) {
        super(name);
    }

    public void testSubTaskActions() {
        this.restoreBlankInstance();
        this.subTasksCreateSubTaskType();
        this.subTasksDeleteSubTaskType();
        this.subTaskCreateDuplicateSubTaskType();
        this.subTaskCreateInvalidSubTaskType();
    }

    public void testSubTaskOperationsHaveTheRightIssueHeader() {
        this.restoreBlankInstance();
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.administration.attachments().enable();
        this.createSubTaskType("Custom Sub Task", "Custom Sub Task");
        this.activateSubTasks();
        this.assertTextPresent("Sub-Tasks");
        this.assertTextPresent("Custom Sub Task");
        String summary = "Parent Summary";
        String childSummary = "Child Summary";
        String parentIssueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Parent Summary");
        String childIssueKey = this.navigation.issue().createSubTask(parentIssueKey, "Custom Sub Task", "Child Summary", "Sub Task Desc");
        this.gotoIssue(childIssueKey);
        this.assertSubTaskIssueHeader(parentIssueKey, childIssueKey, "Parent Summary", "Child Summary");
        this.tester.clickLink("attach-file");
        this.assertSubTaskIssueHeader(parentIssueKey, childIssueKey, "Parent Summary", "Child Summary");
        this.gotoIssue(childIssueKey);
        this.tester.clickLink("clone-issue");
        this.assertSubTaskIssueHeader(parentIssueKey, childIssueKey, "Parent Summary", "Child Summary");
        this.gotoIssue(childIssueKey);
        this.tester.clickLink("delete-issue");
        this.assertSubTaskIssueHeader(parentIssueKey, childIssueKey, "Parent Summary", "Child Summary");
        this.gotoIssue(childIssueKey);
        this.tester.clickLink("view-voters");
        this.assertSubTaskIssueHeader(parentIssueKey, childIssueKey, "Parent Summary", "Child Summary");
        this.gotoIssue(childIssueKey);
        this.tester.clickLink("manage-watchers");
        this.assertSubTaskIssueHeader(parentIssueKey, childIssueKey, "Parent Summary", "Child Summary");
        this.gotoIssue(childIssueKey);
        this.tester.clickLink("log-work");
        this.assertSubTaskIssueHeader(parentIssueKey, childIssueKey, "Parent Summary", "Child Summary");
    }

    private void assertSubTaskIssueHeader(String parentIssueKey, String childIssueKey, String parentSummary, String childSummary) {
        this.assertions.getTextAssertions().assertTextSequence(this.tester.getDialog().getResponseText(), "homosapien", parentIssueKey, parentSummary, childIssueKey, childSummary);
    }

    private void subTasksCreateSubTaskType() {
        TestSubTaskActions.log("Sub Task Action: Tests the ability to create a sub task type");
        this.createSubTaskType("Custom Sub Task", "Custom Sub Task");
        this.activateSubTasks();
        this.assertTextPresent("Sub-Tasks");
        this.assertTextPresent("Custom Sub Task");
        this.deactivateSubTasks();
    }

    private void subTasksDeleteSubTaskType() {
        TestSubTaskActions.log("Sub Task Action: Tests the ability to create a sub task type");
        this.deleteSubTaskType("Custom Sub Task");
        this.activateSubTasks();
        this.clickOnAdminPanel("admin.globalsettings", "subtasks");
        this.assertTextPresent("Sub-Tasks");
        this.assertTextNotPresent("Custom Sub Task");
        this.deactivateSubTasks();
        this.createSubTaskType("Custom Sub Task", "Custom Sub Task");
    }

    private void subTaskCreateDuplicateSubTaskType() {
        TestSubTaskActions.log("Sub Task Action: Ensures two sub task types cannot be given the same name");
        this.activateSubTasks();
        this.clickOnAdminPanel("admin.globalsettings", "subtasks");
        this.setFormElement("name", "Custom Sub Task");
        this.setFormElement("description", "Custom Sub Task");
        this.submit("Add");
        this.assertTextPresent("An issue type with this name already exists.");
        this.deactivateSubTasks();
    }

    private void subTaskCreateInvalidSubTaskType() {
        TestSubTaskActions.log("Sub Task Action: Ensures a sub task types cannot be given no name");
        this.activateSubTasks();
        this.clickOnAdminPanel("admin.globalsettings", "subtasks");
        this.setFormElement("name", "");
        this.setFormElement("description", "Custom Sub Task");
        this.submit("Add");
        this.assertTextPresent("You must specify a name for this new sub-task issue type.");
        this.deactivateSubTasks();
    }
}

