/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestIssueToSubTaskConversionSecurityLevel
extends JIRAWebTest {
    private static final String NO_SECURITY_ISSUE = "HSP-1";
    private static final String DEV_SECURITY_ISSUE = "HSP-2";
    private static final String ADMIN_SECURITY_ISSUE = "HSP-3";
    private static final String DEV_SECURITY_ISSUE_2 = "HSP-4";

    public TestIssueToSubTaskConversionSecurityLevel(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestIssueToSubTaskConversionSecurityLevel.xml");
    }

    public void testIssueToSubTaskConversionSecurityLevelIntroduced() {
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(NO_SECURITY_ISSUE);
        this.assertTextPresent(NO_SECURITY_ISSUE);
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(NO_SECURITY_ISSUE);
        this.assertTextNotPresent("Security Level:");
        this.clickLink("issue-to-subtask");
        this.setFormElement("parentIssueKey", DEV_SECURITY_ISSUE);
        this.selectOption("issuetype", "Sub-task");
        this.submit("Next >>");
        this.assertTextPresent("All fields will be updated automatically.");
        this.submit("Next >>");
        this.assertTextPresentBeforeText("Security", "Developers");
        this.submit("Finish");
        this.assertTextPresentBeforeText("Security Level:", "Developers");
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(NO_SECURITY_ISSUE);
        this.assertTextPresent("Permission Violation");
    }

    public void testIssueToSubTaskConversionSecurityLevelRemoved() {
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(DEV_SECURITY_ISSUE);
        this.assertTextPresent("Permission Violation");
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(DEV_SECURITY_ISSUE);
        this.assertTextPresentBeforeText("Security Level:", "Developers");
        this.clickLink("issue-to-subtask");
        this.setFormElement("parentIssueKey", NO_SECURITY_ISSUE);
        this.selectOption("issuetype", "Sub-task");
        this.submit("Next >>");
        this.assertTextPresent("All fields will be updated automatically.");
        this.submit("Next >>");
        this.assertTextPresentBeforeText("Security", "Developers");
        this.submit("Finish");
        this.assertTextNotPresent("Security Level:");
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(DEV_SECURITY_ISSUE);
        this.assertTextPresent(DEV_SECURITY_ISSUE);
    }

    public void testIssueToSubTaskConversionSecurityLevelChanged() {
        this.logout();
        this.login("jane", "jane");
        this.gotoIssue(DEV_SECURITY_ISSUE);
        this.assertTextPresent(DEV_SECURITY_ISSUE);
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(DEV_SECURITY_ISSUE);
        this.assertTextPresentBeforeText("Security Level:", "Developers");
        this.clickLink("issue-to-subtask");
        this.setFormElement("parentIssueKey", ADMIN_SECURITY_ISSUE);
        this.selectOption("issuetype", "Sub-task");
        this.submit("Next >>");
        this.assertTextPresent("All fields will be updated automatically.");
        this.submit("Next >>");
        this.assertTextPresentBeforeText("Security", "Developers");
        this.assertTextPresentBeforeText("Developers", "Administrators");
        this.submit("Finish");
        this.assertTextPresentBeforeText("Security Level:", "Administrators");
        this.logout();
        this.login("jane", "jane");
        this.gotoIssue(DEV_SECURITY_ISSUE);
        this.assertTextPresent("Permission Violation");
    }

    public void testIssueToSubTaskConversionSecurityLevelSame() {
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(DEV_SECURITY_ISSUE);
        this.assertTextPresent("Permission Violation");
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(DEV_SECURITY_ISSUE);
        this.assertTextPresentBeforeText("Security Level:", "Developers");
        this.clickLink("issue-to-subtask");
        this.setFormElement("parentIssueKey", DEV_SECURITY_ISSUE_2);
        this.selectOption("issuetype", "Sub-task");
        this.submit("Next >>");
        this.assertTextPresent("All fields will be updated automatically.");
        this.submit("Next >>");
        this.assertTextNotPresent("Developers");
        this.submit("Finish");
        this.assertTextPresentBeforeText("Security Level:", "Developers");
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(DEV_SECURITY_ISSUE);
        this.assertTextPresent("Permission Violation");
    }
}

