/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project.version;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.joda.time.DateTime;
import org.w3c.dom.Node;

public class TestSummaryVersionTabPanel
extends FuncTestCase {
    private static final String NEW_VERSION_1 = "New Version 1";
    private static final String NEW_VERSION_4 = "New Version 4";

    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    public void testVersionDescription() throws Exception {
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "summary");
        this.text.assertTextSequence(new XPathLocator(this.tester, "//div[@id='fragversiondescription']//h3"), "Description", new String[0]);
        this.tester.assertTextPresent("Test Version Description 1");
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//div[@id='fragversiondescription']//li"), "Due:");
        this.administration.project().editVersionDetails("homosapien", NEW_VERSION_1, null, "A description which should be <b>HTML</b> escaped", null, null);
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "summary");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@id='fragversiondescription']//h3"), "Description");
        this.tester.assertTextPresent("A description which should be &lt;b&gt;HTML&lt;/b&gt; escaped");
        this.tester.assertTextNotPresent("A description which should be <b>HTML</b> escaped");
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//div[@id='fragversiondescription']//li"), "Due:");
        this.administration.project().editVersionDetails("homosapien", NEW_VERSION_1, null, "", null, null);
        this.assertFragmentNotPresent("fragversiondescription");
        this.administration.project().editVersionDetails("homosapien", NEW_VERSION_1, null, null, "30/Oct/06", null);
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "summary");
        this.text.assertTextSequence(new XPathLocator(this.tester, "//div[@id='fragversiondescription']//li"), "Due:", "30/Oct/06");
    }

    public void testDueIssues() throws Exception {
        DateTime cal = new DateTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("d/MMM/yy EEEE", Locale.getDefault());
        cal = cal.minusDays(14);
        DateTuple twoWeeksAgo = new DateTuple(dateFormat.format(cal.toDate()));
        cal = cal.plusDays(7);
        DateTuple oneWeekAgo = new DateTuple(dateFormat.format(cal.toDate()));
        cal = cal.plusDays(6);
        DateTuple yesterday = new DateTuple(dateFormat.format(cal.toDate()));
        cal = cal.plusDays(1);
        DateTuple today = new DateTuple(dateFormat.format(cal.toDate()));
        cal = cal.plusDays(1);
        DateTuple tomorrow = new DateTuple(dateFormat.format(cal.toDate()));
        cal = cal.plusDays(6);
        DateTuple oneWeekLater = new DateTuple(dateFormat.format(cal.toDate()));
        cal = cal.plusDays(7);
        DateTuple twoWeeksLater = new DateTuple(dateFormat.format(cal.toDate()));
        this.assertFragmentNotPresent("fragdueissues");
        String issue1 = this.createIssueAndSetDueDate(twoWeeksAgo, "Bug due two weeks ago", NEW_VERSION_1);
        String issue2 = this.createIssueAndSetDueDate(oneWeekAgo, "Bug due one week ago", NEW_VERSION_1);
        String issue3 = this.createIssueAndSetDueDate(yesterday, "Bug due yesterday", NEW_VERSION_1);
        String issue4 = this.createIssueAndSetDueDate(today, "Bug due today", NEW_VERSION_1);
        String issue5 = this.createIssueAndSetDueDate(tomorrow, "Bug due tomorrow", NEW_VERSION_1);
        String issue6 = this.createIssueAndSetDueDate(oneWeekLater, "Bug due one week later", NEW_VERSION_1);
        String issue7 = this.createIssueAndSetDueDate(twoWeeksLater, "Bug due two weeks later", NEW_VERSION_1);
        String issueOtherVersion = this.createIssueAndSetDueDate(twoWeeksAgo, "Bug due two weeks ago", NEW_VERSION_4);
        this.assertTop3DueIssues(issue1, twoWeeksAgo.dateString, issue2, "Last " + oneWeekAgo.dayOfWeek, issue3, "Yesterday", issue4, issue5, issue6, issue7, issueOtherVersion);
        this.setFixForDueDateAndPriority(issue2, null, yesterday.dateString, "Blocker");
        this.setFixForDueDateAndPriority(issue3, null, yesterday.dateString, "Minor");
        this.setFixForDueDateAndPriority(issue1, null, yesterday.dateString, "Trivial");
        this.assertTop3DueIssues(issue2, "Yesterday", issue3, "Yesterday", issue1, "Yesterday", issue4, issue5, issue6, issue7, issueOtherVersion);
        this.resolveIssue(issue1);
        this.resolveIssue(issue2);
        this.resolveIssue(issue3);
        this.assertTop3DueIssues(issue4, "Today", issue5, "Tomorrow", issue6, oneWeekLater.dayOfWeek, issue1, issue2, issue3, issue7, issueOtherVersion);
        this.setFixForDueDateAndPriority(issue4, null, "", null);
        this.assertTop3DueIssues(issue5, "Tomorrow", issue6, oneWeekLater.dayOfWeek, issue7, twoWeeksLater.dateString, issue1, issue2, issue3, issue4, issueOtherVersion);
        this.setFixForDueDateAndPriority(issue5, null, "", null);
        this.assertTop3DueIssues(issue6, oneWeekLater.dayOfWeek, issue7, twoWeeksLater.dateString, issue4, "", issue1, issue2, issue3, issue5, issueOtherVersion);
        this.setFixForDueDateAndPriority(issue5, null, "", "Blocker");
        this.assertTop3DueIssues(issue6, oneWeekLater.dayOfWeek, issue7, twoWeeksLater.dateString, issue5, "", issue1, issue2, issue3, issue4, issueOtherVersion);
        this.tester.clickLink("fragdueissues_more");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldfixfor", NEW_VERSION_1);
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearchOrder("Due Date ascending", "then Priority descending", "then Created ascending");
    }

    public void testRecentlyUpdatedIssues() throws Exception {
        this.assertFragmentNotPresent("fragrecentissues");
        this.administration.restoreData("TestRecentlyUpdatedIssuesFragment.xml");
        this.assertTop3RecentIssues("HSP-4", "HSP-2", "HSP-3", "HSP-1");
        this.setFixForDueDateAndPriority("HSP-1", null, "", "Blocker");
        this.assertTop3RecentIssues("HSP-1", "HSP-4", "HSP-2", "HSP-3");
        this.setFixForDueDateAndPriority("HSP-2", NEW_VERSION_4, "", null);
        this.assertTop3RecentIssues("HSP-1", "HSP-4", "HSP-3", "HSP-2");
        this.tester.clickLink("fragrecentissues_more");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldfixfor", NEW_VERSION_1);
        this.assertSearchOrder("Updated descending", "then Priority descending", "then Created ascending");
    }

    private void assertFragmentNotPresent(String fragmentId) {
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "summary");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='" + fragmentId + "']/h3");
        Node[] nodes = pathLocator.getNodes();
        TestSummaryVersionTabPanel.assertTrue((nodes == null || nodes.length == 0 ? 1 : 0) != 0);
    }

    private void assertTop3DueIssues(String firstIssue, String firstDueDate, String secondIssue, String secondDueDate, String thirdIssue, String thirdDueDate, String ... issuesNotPresent) {
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "summary");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='fragdueissues']//ul[@class='issues']/li");
        this.text.assertTextSequence(pathLocator, new String[]{firstIssue, firstDueDate, secondIssue, secondDueDate, thirdIssue, thirdDueDate});
        for (String issue : issuesNotPresent) {
            this.text.assertTextNotPresent(pathLocator, issue);
        }
    }

    private void assertTop3RecentIssues(String firstIssue, String secondIssue, String thirdIssue, String ... issuesNotPresent) {
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "summary");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='fragrecentissues']//ul[@class='issues']/li");
        this.text.assertTextSequence(pathLocator, new String[]{firstIssue, secondIssue, thirdIssue});
        for (String issue : issuesNotPresent) {
            this.text.assertTextNotPresent(pathLocator, issue);
        }
    }

    private String createIssueAndSetDueDate(DateTuple dateTuple, String summary, String component) {
        String key = this.navigation.issue().createIssue("homosapien", "Bug", summary);
        this.setFixForDueDateAndPriority(key, component, dateTuple.dateString, null);
        return key;
    }

    private void setFixForDueDateAndPriority(String key, String fixForVersionName, String dueDate, String priority) {
        this.navigation.issue().viewIssue(key);
        this.tester.clickLink("editIssue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.setFormElement("duedate", dueDate);
        if (priority != null) {
            this.tester.selectOption("priority", priority);
        }
        if (fixForVersionName != null) {
            this.tester.selectOption("fixVersions", fixForVersionName);
        }
        this.tester.submit();
    }

    private void resolveIssue(String key) {
        this.navigation.issue().viewIssue(key);
        this.tester.clickLinkWithText("Resolve Issue");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
    }

    private void assertSearchOrder(String ... expectedSequence) {
        XPathLocator pathLocator = new XPathLocator(this.tester, "//*[@id='filter-summary']/div");
        this.text.assertTextSequence(pathLocator, "Sorted by", expectedSequence);
    }

    private void assertSearcherField(String elementId, String expectedText) {
        this.text.assertTextPresent(new XPathLocator(this.tester, "//span[@id='" + elementId + "']"), expectedText);
    }

    private static class DateTuple {
        String dateString;
        String dayOfWeek;

        DateTuple(String format) {
            String[] parts = format.split(" ");
            this.dateString = parts[0];
            this.dayOfWeek = parts[1];
        }
    }
}

